# Purpose:      Helper module for integrating C++ handler 
#               (see led2.cpp)
# Author:       Roman Rolinsky <rolinsky@femagsoft.com>
# Created:      14.03.2007
# RCS-ID:       $Id$

import os
import xxx

class xxxLEDNumberCtrl2(xxx.xxxObject):
    allParams = ['pos', 'size', 'style', 'value']
    required = ['value']            # required parameter
    default = {'value': '123'}      # default value
    winStyles = ['wxLED_ALIGN_LEFT', # specific window styles
                 'wxLED_ALIGN_RIGHT',
                 'wxLED_ALIGN_CENTER',
                 'wxLED_DRAW_FADED']

# Register C++ handlers from shared library.
# Path can be absolute, relative to the package directory,
# or will be looked in LD_LIBRARY_PATH
xxx.load_dl('./libled2.so')

# Register XRCed interface class
xxx.custom('LEDNumberCtrl2', xxxLEDNumberCtrl2)
