/////////////////////////////////////////////////////////////////////////////
// Purpose:     Example of using custom C++ XRC handler in XRCed
// Author:      Roman Rolinksy <rolinsky@femagsoft.com>
// Created:     14.03.2007
// RCS-ID:      $Id$
/////////////////////////////////////////////////////////////////////////////

#include "wx/wx.h"
#include "wx/gizmos/ledctrl.h"
#include "wx/xrc/xmlres.h"
#include <iostream>
using namespace std;

class LEDNumberCtrlXmlHandler : public wxXmlResourceHandler
{                             
    DECLARE_DYNAMIC_CLASS(LEDNumberCtrlXmlHandler)
public:
    LEDNumberCtrlXmlHandler() {
	AddWindowStyles();
	XRC_ADD_STYLE(wxLED_ALIGN_LEFT);
	XRC_ADD_STYLE(wxLED_ALIGN_RIGHT);
	XRC_ADD_STYLE(wxLED_ALIGN_CENTER);
	XRC_ADD_STYLE(wxLED_DRAW_FADED);
    }

    virtual wxObject *DoCreateResource() {
	XRC_MAKE_INSTANCE(w, wxLEDNumberCtrl)
	  
	w->Create(m_parentAsWindow,
		  GetID(),
		  GetPosition(), GetSize(),
		  GetStyle());
	w->SetValue(GetText(wxT("value")));
	SetupWindow(w);
	return w;
    }

    virtual bool CanHandle(wxXmlNode* node) {
	return IsOfClass(node, wxT("LEDNumberCtrl2"));
    }
};

IMPLEMENT_DYNAMIC_CLASS(LEDNumberCtrlXmlHandler, wxXmlResourceHandler)

extern "C"
void AddXmlHandlers()
{
    wxXmlResource::Get()->AddHandler(new LEDNumberCtrlXmlHandler);
}
