/////////////////////////////////////////////////////////////////////////////
// Name:        example2.cpp
// Purpose:     Example of using custom C++ XRC handler in XRCed
// Author:      Roman Rolinksy <rolinsky@femagsoft.com>
// Created:     14.03.2007
// RCS-ID:      $Id$
/////////////////////////////////////////////////////////////////////////////

#include "wx/wx.h"
#include "wx/gizmos/ledctrl.h"
#include "wx/xrc/xmlres.h"
#include <iostream>
using namespace std;

class LEDNumberCtrlXmlHandler : public wxXmlResourceHandler
{                             
    DECLARE_DYNAMIC_CLASS(LEDNumberCtrlXmlHandler)
public:
    LEDNumberCtrlXmlHandler() {
	AddWindowStyles();
	XRC_ADD_STYLE(wxLED_ALIGN_LEFT);
	XRC_ADD_STYLE(wxLED_ALIGN_RIGHT);
	XRC_ADD_STYLE(wxLED_ALIGN_CENTER);
	XRC_ADD_STYLE(wxLED_DRAW_FADED);
    }

    virtual wxObject *DoCreateResource() {
	XRC_MAKE_INSTANCE(w, wxLEDNumberCtrl)
	  
	w->Create(m_parentAsWindow,
		  GetID(),
		  GetPosition(), GetSize(),
		  GetStyle());
	w->SetValue(GetText(wxT("value")));
	SetupWindow(w);
	return w;
    }

    virtual bool CanHandle(wxXmlNode* node) {
	return IsOfClass(node, wxT("LEDNumberCtrl"));
    }
};

IMPLEMENT_DYNAMIC_CLASS(LEDNumberCtrlXmlHandler, wxXmlResourceHandler)

extern "C"
void AddXmlHandlers()
{
    wxXmlResource::Get()->AddHandler(new LEDNumberCtrlXmlHandler);
}

#ifdef MAIN

class TestFrame : public wxFrame
{
public:
    TestFrame() : wxFrame(NULL, wxID_ANY, _T("custom2 example")) {
	wxXmlResource::Get()->InitAllHandlers();
	AddXmlHandlers();
	wxXmlResource::Get()->Load(_T("custom2.xrc"));
	wxPanel* panel = wxXmlResource::Get()->LoadPanel(this, _T("PANEL1"));
	m_led = XRCCTRL(*panel, "LED", wxLEDNumberCtrl);
	SetClientSize(panel->GetBestSize());
	m_timer = new wxTimer(this);
	m_timer->Start(1000);
	Connect(wxEVT_TIMER, wxTimerEventHandler(TestFrame::OnTimer));
    }

    void OnTimer(wxTimerEvent& event) {
	long val;
	m_led->GetValue().ToLong(&val);
	if (--val > 0)
	    m_led->SetValue(wxString::Format(_T("%d"), val));
	else
	{
	    m_timer->Stop();
	    m_led->SetValue(_T("---"));
	}
    }

private:
    wxLEDNumberCtrl *m_led;
    wxTimer *m_timer;

    //DECLARE_EVENT_TABLE()
};

class App : public wxApp
{
public:
    // override base class virtuals
    // ----------------------------

    // this one is called on application startup and is a good place for the app
    // initialization (doing it here and not in the ctor allows to have an error
    // return: if OnInit() returns false, the application terminates)
    virtual bool OnInit() {
	TestFrame* frame = new TestFrame;
	frame->Centre();
	frame->Show(true);
	return true;
    }
};


IMPLEMENT_APP(App)

#endif
