# Name:         custom1.py
# Purpose:      Example of using custom wxPython control in XRCed
# Author:       Roman Rolinsky <rolinsky@femagsoft.com>
# Created:      14.03.2007
# RCS-ID:       $Id$

import wx
import wx.xrc as xrc
import wx.gizmos as gizmos

# Resource handler class
class LEDNumberCtrlXmlHandler(xrc.XmlResourceHandler):
    def __init__(self):
        xrc.XmlResourceHandler.__init__(self)
        # Standard styles
        self.AddWindowStyles()
        # Custom styles
        self.AddStyle('wxLED_ALIGN_LEFT', gizmos.LED_ALIGN_LEFT)
        self.AddStyle('wxLED_ALIGN_RIGHT', gizmos.LED_ALIGN_RIGHT)
        self.AddStyle('wxLED_ALIGN_CENTER', gizmos.LED_ALIGN_CENTER)
        self.AddStyle('wxLED_DRAW_FADED', gizmos.LED_DRAW_FADED)
        
    def CanHandle(self,node):
        return self.IsOfClass(node, 'LEDNumberCtrl')

    # Process XML parameters and create the object
    def DoCreateResource(self):
        assert self.GetInstance() is None
        w = gizmos.LEDNumberCtrl(self.GetParentAsWindow(),
                                 self.GetID(),
                                 self.GetPosition(),
                                 self.GetSize(),
                                 self.GetStyle())
        # wxLED_ALIGN_MASK was incorrect
        w.SetAlignment(self.GetStyle() & 7)
        w.SetValue(self.GetText('value'))
        self.SetupWindow(w)
        return w
    
# XRCed support
try:
    import xxx

    class xxxLEDNumberCtrl(xxx.xxxObject):
        allParams = ['pos', 'size', 'style', 'value']
        required = ['value']            # required parameter
        default = {'value': '123'}      # default value
        winStyles = ['wxLED_ALIGN_LEFT', # specific window styles
                     'wxLED_ALIGN_RIGHT',
                     'wxLED_ALIGN_CENTER',
                     'wxLED_DRAW_FADED']

    # Register XML handler
    xxx.register(LEDNumberCtrlXmlHandler)
    # Register XRCed interface class
    xxx.custom('LEDNumberCtrl', xxxLEDNumberCtrl)
except:
    pass                                # end of XXX section

# Running as script
if __name__ == '__main__':
    class TestFrame(wx.Frame):
        def __init__(self, parent):
            wx.Frame.__init__(self, parent, -1, "custom1 example")
            self.res = xrc.EmptyXmlResource()
            self.res.InsertHandler(LEDNumberCtrlXmlHandler())
            self.res.Load("custom1.xrc")
            panel = self.res.LoadPanel(self,'PANEL1')
            self.led = xrc.XRCCTRL(panel, 'LED')
            self.SetClientSize(panel.GetBestSize())
            self.timer = wx.Timer(self)
            self.timer.Start(1000)
            self.Bind(wx.EVT_TIMER, self.OnTimer)
            
        def OnTimer(self, evt):
            val = int(self.led.GetValue()) - 1
            if val > 0:
                self.led.SetValue(`val`)
            else:
                self.led.SetValue('---')
                self.timer.Stop()

    app = wx.PySimpleApp()
    frame = TestFrame(None)
    frame.Centre()
    frame.Show(True)
    app.MainLoop()
