
"""
Toolbook_Demo.py
    "Toolbook"
    @ http://wiki.wxpython.org/Toolbook
    Mike Driscoll
"""

import wx
import  wx.lib.mixins.listctrl  as  listmix

import images
import panelOne, panelTwo, panelThree

#------------------------------------------------------------------------------

musicdata = {
1  : ( 'Bad English', 'The Price Of Love', 'Rock' ),
2  : ( 'DNA featuring Suzanne Vega', 'Tom\'s Diner', 'Rock' ),
3  : ( 'George Michael', 'Praying For Time', 'Rock' ),
4  : ( 'Gloria Estefan', 'Here We Are', 'Rock' ),
5  : ( 'Linda Ronstadt', 'Don\'t Know Much', 'Rock' ),
6  : ( 'Michael Bolton', 'How Am I Supposed To Live Without You', 'Blues' ),
7  : ( 'Paul Young', 'Oh Girl', 'Rock' ),
8  : ( 'Paula Abdul', 'Opposites Attract', 'Rock' ),
9  : ( 'Richard Marx', 'Should\'ve Known Better', 'Rock' ),
10 : ( 'Rod Stewart', 'Forever Young', 'Rock' ),
11 : ( 'Roxette', 'Dangerous', 'Rock' ),
12 : ( 'Sheena Easton', 'The Lover In Me', 'Rock' ),
13 : ( 'Sinead O\'Connor', 'Nothing Compares 2 U', 'Rock' ),
14 : ( 'Stevie B.', 'Because I Love You', 'Rock' ),
15 : ( 'Taylor Dayne', 'Love Will Lead You Back', 'Rock' ),
16 : ( 'The Bangles', 'Eternal Flame', 'Rock' ),
17 : ( 'Wilson Phillips', 'Release Me', 'Rock' ),
18 : ( 'Billy Joel', 'Blonde Over Blue', 'Rock' ),
19 : ( 'Billy Joel', 'Famous Last Words', 'Rock' ),
20 : ( 'Billy Joel', 'Lullabye (Goodnight, My Angel)', 'Rock' ),
21 : ( 'Billy Joel', 'The River Of Dreams', 'Rock' ),
22 : ( 'Billy Joel', 'Two Thousand Years', 'Rock' ), 
}

#------------------------------------------------------------------------------
#==============================================================================
#------------------------------------------------------------------------------

class TestListCtrl( wx.ListCtrl, listmix.ListCtrlAutoWidthMixin ) :
    
    def __init__( self, parent, id=-1, pos=wx.DefaultPosition,
                        size=wx.DefaultSize, style=0 ) :
        
        wx.ListCtrl.__init__( self, parent, id, pos, size, style )
        
        listmix.ListCtrlAutoWidthMixin.__init__( self )
    
    #end __init__
    
#end class

#------------------------------------------------------------------------------
#==============================================================================
#------------------------------------------------------------------------------

class TabPanel( wx.Panel, listmix.ColumnSorterMixin ) :
    """ This will be the second notebook tab """
    
    def __init__( self, parent ) :
        """"""
        wx.Panel.__init__( self, parent=parent, id=wx.ID_ANY )
        self.createAndLayout()
        
    #end __init__
    
    #----------------------------------
    
    def createAndLayout( self ) :
        
        sizer = wx.BoxSizer( wx.VERTICAL )
        self.list = TestListCtrl( self, wx.ID_ANY, style=wx.LC_REPORT
                                        | wx.BORDER_NONE
                                        | wx.LC_EDIT_LABELS
                                        | wx.LC_SORT_ASCENDING )
        sizer.Add( self.list, proportion=1, flag=wx.EXPAND )
        self.populateList()
        
        # Now that the list exists we can init the other base class,
        #   see [ wx/lib/mixins/listctrl.py ].
        self.itemDataMap = musicdata
        numCols = 3
        listmix.ColumnSorterMixin.__init__( self, numCols )
        
        self.SetSizer( sizer )
        self.Layout()
    
    #end createAndLayout def
    
    #----------------------------------
    
    def populateList( self ) :
        
        self.list.InsertColumn( 0, 'Artist' )
        self.list.InsertColumn( 1, 'Title', wx.LIST_FORMAT_RIGHT )
        self.list.InsertColumn( 2, 'Genre' )
        items = musicdata.items()

        for key, data in items :
            index = self.list.InsertStringItem( sys.maxint, data[ 0 ] )
            self.list.SetStringItem( index, 1, data[ 1 ] )
            self.list.SetStringItem( index, 2, data[ 2 ] )
            self.list.SetItemData( index, key )

        self.list.SetColumnWidth( 0, wx.LIST_AUTOSIZE )
        self.list.SetColumnWidth( 1, wx.LIST_AUTOSIZE )
        self.list.SetColumnWidth( 2, 100 )

        # show how to select an item
        self.list.SetItemState( 5, wx.LIST_STATE_SELECTED, wx.LIST_STATE_SELECTED )

        # show how to change the colour of a couple items
        item = self.list.GetItem( 1 )
        item.SetTextColour( wx.BLUE )
        self.list.SetItem( item )
        
        item = self.list.GetItem( 4 )
        item.SetTextColour( wx.RED )
        self.list.SetItem( item )

        self.currentItem = 0
    
    #end populateList def
    
    #----------------------------------
    
    def GetListCtrl( self ) :
        """ Used by the ColumnSorterMixin, see wx/lib/mixins/listctrl.py """
        return self.list
        
#end TabPanel class

#------------------------------------------------------------------------------

def getNextImageID( count ) :
    
    imID = 0
    while True :
        
        yield imID
        
        imID += 1
    
    #end while
    
#end def

#------------------------------------------------------------------------------
#==============================================================================
#------------------------------------------------------------------------------

class ToolbookDemo( wx.Toolbook ) :
    
    def __init__( self, parent ) :
        
        wx.Toolbook.__init__( self, parent, wx.ID_ANY, style=
                              wx.BK_DEFAULT
                              #wx.BK_TOP
                              #wx.BK_BOTTOM
                              #wx.BK_LEFT
                              #wx.BK_RIGHT
                             )
        # Make an image list using the LBXX images
        il = wx.ImageList( 32, 32 )
        for x in range( 3 ) :
            
            imgObj = getattr( images, 'LB%02d' % ( x+1 ) )
            bmp = imgObj.GetBitmap()
            il.Add( bmp )
        
        self.AssignImageList( il )
        imageIdGenerator = getNextImageID( il.GetImageCount() )
        
        notebookPageList = [ (panelOne.TabPanel( self ),   'Panel One'),
                             (panelTwo.TabPanel( self ),   'Panel Two'),
                             (panelThree.TabPanel( self ), 'Panel Three') ]
        imID = 0
        for page, label in notebookPageList :
            
            self.AddPage( page, label, imageId=imageIdGenerator.next() )
            imID += 1
        
        # An undocumented method in the official docs :
        self.ChangeSelection( 1 )   # Select and view this notebook page.
                                    # Creates no events - method SetSelection does.
        
        self.Bind( wx.EVT_TOOLBOOK_PAGE_CHANGING, self.OnPageChanging )
        self.Bind( wx.EVT_TOOLBOOK_PAGE_CHANGED,  self.OnPageChanged )
    
    #end __init__
    
    #----------------------------------
    
    def OnPageChanging( self, event ) :
        
        old = event.GetOldSelection()
        new = event.GetSelection()
        sel = self.GetSelection()
        print
        print 'OnPageChanging{}:  old: %d, new: %d, sel: %d' %( old, new, sel )
        event.Skip()

    #----------------------------------
    
    def OnPageChanged( self, event ) :
        
        old = event.GetOldSelection()
        new = event.GetSelection()
        sel = self.GetSelection()
        
        print 'OnPageChanged{}:   old: %d, new: %d, sel: %d' %( old, new, sel )
        event.Skip()
    
#end ToolbookDemo class

#------------------------------------------------------------------------------
#==============================================================================
#------------------------------------------------------------------------------

class DemoFrame( wx.Frame ) :

    def __init__( self ) :
        
        wx.Frame.__init__( self, None, -1, 'Toolook Tutorial Demo', size=(500, 400) )
        panel = wx.Panel( self )

        notebook = ToolbookDemo( panel )
        
        sizer = wx.BoxSizer( wx.VERTICAL )
        sizer.Add( notebook, proportion=1, flag=wx.ALL|wx.EXPAND, border=5 )
        panel.SetSizer( sizer )
        self.Layout()

    #end __init__
    
#end class

#==============================================================================

if __name__ == '__main__' :
    
    app = wx.App( redirect=False )
    appFrame = DemoFrame()
    appFrame.Show()
    app.MainLoop()
    
#end if