# towers_of_hanoi_bis.py

"""
The Towers of Hanoi

Author: A. Polino
Link : https://code.activestate.com/recipes/577511-hanoi-towers-solver-wxpython/
"""

import wx
import sys

# def Gen_hanoi
# def Create_plates
# class Plate
# class HanoiWindow
# class HanoiFrame
# class HanoiApp
# class

#---------------------------------------------------------------------------

## Make sure the windows is focused than press any button, and the program will move a plate. keep  ## pressing until the problem is solved
## by default it will display 5 plates. To change this, you have to call the script with a second   ## argument, wich is the number of plates (max 10)

def Gen_hanoi(stack, start=1, temp=2, goal=3):
    """
    ...
    """
    
    if stack == 2:
        yield start, temp
        yield start, goal
        yield temp, goal
        
    else:
        for x in Gen_hanoi(stack - 1, start, goal, temp):
            yield x
        yield start, goal
        
        for x in Gen_hanoi(stack - 1, temp, start, goal):
            yield x        

#---------------------------------------------------------------------------
            
def Create_plates(num):
    """
    ...
    """
    
    assert num <= 10
    
    x_start = 10
    x_len = 100
    plates = []
    
    for x in range(num):
        plates.append(Plate(x_len, x_start))
        x_len -= 10
        x_start += 5
        
    return plates

#---------------------------------------------------------------------------
            
class Plate(object):
    """
    ...
    """
    def __init__(self, x_len, x_start):

        #------------
        
        self.x_len = x_len
        self.x_start = x_start

#---------------------------------------------------------------------------

class HanoiWindow(wx.Window):
    """
    ...
    """
    def __init__(self, parent, num):
        wx.Window.__init__(self, parent, id=-1, pos=wx.Point(0, 0),
                           size=wx.DefaultSize, style=wx.SUNKEN_BORDER|
                           wx.WANTS_CHARS|wx.FULL_REPAINT_ON_RESIZE)

        #------------
        
        self.SetBackgroundColour(wx.Colour('#eceade'))
        
        #------------
        
        self.BindEvents()

        #------------

        self.towers = [Create_plates(num), [], []]
        self.solver = Gen_hanoi(num)

    #-----------------------------------------------------------------------

    def BindEvents(self):
        self.Bind(wx.EVT_PAINT, self.OnPaint)
        self.Bind(wx.EVT_KEY_UP, self.OnKeyUp)
        
        
    def OnPaint(self, evt):
        def draw_rect(x_len, x_start, y_start):
            pdc = wx.PaintDC(self)   ###
            dc = wx.GCDC(pdc)
            font = dc.GetFont()
            font.SetPointSize(15)
            dc.SetFont(font)
            size, colour = 2, wx.Colour('black')
            dc.SetPen(wx.Pen(colour, size, wx.SOLID))
            point = wx.Point(x_start, y_start)
            dc.DrawLines([point, point + wx.Point(x_len, 0)])
            dc.DrawLines([point - wx.Point(0, 5), point + wx.Point(x_len, 0) - wx.Point(0, 5)])
            dc.DrawLines([point, point - wx.Point(0, 5)])
            dc.DrawLines([point + wx.Point(x_len, 0), point - wx.Point(0, 5) + wx.Point(x_len, 0)])

        w, h = self.GetClientSize()
        buffer = wx.Bitmap(w, h)
        pdc = wx.PaintDC(self)   ###
        dc = wx.GCDC(pdc)
        font = dc.GetFont()
        font.SetPointSize(15)
        dc.SetFont(font)
        msg = 'Hanoi Towers'
        w, h = dc.GetTextExtent(msg)
        dc.DrawText(msg, 200, 20)
        size, colour = 8, wx.Colour('black')
        dc.SetPen(wx.Pen(colour, size, wx.SOLID))
        for num in range(len(self.towers)):
            y_start = 300
            tower = self.towers[num]
            num = num * 200 + 10
            point = wx.Point(num, y_start)
            dc.DrawLines([point, point + wx.Point(120, 0)]) # Base
            # Plates
            for plate in tower:
                y_start -= 10
                draw_rect(plate.x_len, num + plate.x_start, y_start)


    def OnKeyUp(self, evt):
        try:
            from_, to = next(self.solver)
            self.towers[to-1].append(self.towers[from_-1].pop())
            self.Refresh()
        except StopIteration:
            wx.MessageBox('Problem Solved !', 'Problem solved', wx.OK)               

#---------------------------------------------------------------------------
            
class HanoiFrame(wx.Frame):
    """
    ...
    """
    def __init__(self, title, num):
        style=wx.DEFAULT_FRAME_STYLE ^ wx.RESIZE_BORDER ^ wx.MAXIMIZE_BOX
        wx.Frame.__init__(self, parent=None, id=-1,
                          title=title, size=(600, 500),
                          pos=(200, 200), style=style)

        #------------

        self.SetIcon(wx.Icon(".\icons\wxwin.ico"))

        #------------

        self.Window = HanoiWindow(self, num)        
        self.SetDoubleBuffered(True)  ###
        
        #------------
        
        self.BindEvents()

        #------------
        
        self.CenterOnScreen(wx.BOTH)
        self.Show(True)
        
    #-----------------------------------------------------------------------

    def BindEvents(self):
        self.Bind(wx.EVT_CLOSE, self.close_frame)


    def close_frame(self, evt):
        # sys.exit(0)
        self.Destroy()
        
#---------------------------------------------------------------------------
        
class HanoiApp(wx.App):
    """
    ...
    """
    def OnInit(self):
        if len(sys.argv) < 2:
            num = 5
        else:
            num = int(sys.argv[1])

        #------------
            
        hano = HanoiFrame('Hanoi Towers', num)
        self.SetTopWindow(hano)
        
        return True

#---------------------------------------------------------------------------

def main():
    app = HanoiApp()
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == '__main__':
    main()
