#!/usr/bin/env python
# -*- coding: utf-8 -*-
# generated by wxGlade 0.6.2 on Wed Feb 27 21:45:22 2008

"""
Demo of a simple example of using an ObjectListView
"""

__author__ = "Phillip Piper"
__date__ = "1 March 2008"
__version__ = "1.0"

from datetime import datetime, timedelta, time

import os
from time import clock, strptime
import random

import wx
import wx.lib.colourdb as colourdb

#from ObjectListView import ObjectListView, VirtualObjectListView, FastObjectListView, ColumnDefn
#from OLVEvent import EVT_CELL_EDIT_STARTING, EVT_CELL_EDIT_FINISHING
#import CellEditor

from ObjectListView import ObjectListView, VirtualObjectListView, FastObjectListView, ColumnDefn
from ObjectListView import EVT_CELL_EDIT_STARTING, EVT_CELL_EDIT_FINISHING, CellEditorRegistry, MakeAutoCompleteTextBox, MakeAutoCompleteComboBox

import OwnerDrawnEditor

# begin wxGlade: extracode
# end wxGlade


class Track:
    """
    A song in some music library
    """
    def __init__(self, **kwargs):
        self.attributeNames = kwargs.keys()
        self.attributeNames.extend(["trackColour", "font"])
        self.__dict__.update(kwargs)

    def clone(self):
        d = {}
        for x in self.attributeNames:
            d[x] = getattr(self, x, None)
        return Track(**d)

    def dateLastPlayed(self):
        return self.lastPlayed.date()

    def SetDateLastPlayed(self, value):
        self.lastPlayed = datetime.combine(value, self.lastPlayed.time())

    def SetFontFace(self, value):
        if value is None or value == "":
            self.font = None
        else:
            self.font = wx.FFont(11, wx.DEFAULT, face=value)

class MyFrame(wx.Frame):
    def __init__(self, *args, **kwds):
        # begin wxGlade: MyFrame.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.notebook_1 = wx.Notebook(self, -1, style=0)
        self.notebook_1_pane_5 = wx.Panel(self.notebook_1, -1, style=wx.DOUBLE_BORDER|wx.TAB_TRAVERSAL)
        self.notebook_1_pane_4 = wx.Panel(self.notebook_1, -1)
        self.notebook_1_pane_3 = wx.Panel(self.notebook_1, -1)
        self.notebook_1_pane_2 = wx.Panel(self.notebook_1, -1)
        self.notebook_1_pane_1 = wx.Panel(self.notebook_1, -1)
        self.sizer_5_staticbox = wx.StaticBox(self.notebook_1_pane_1, -1, "Commands")
        self.sizer_6_staticbox = wx.StaticBox(self.notebook_1_pane_1, -1, "Select")
        self.sizer_4_copy_staticbox = wx.StaticBox(self.notebook_1_pane_2, -1, "List View")
        self.sizer_5_copy_staticbox = wx.StaticBox(self.notebook_1_pane_2, -1, "Commands")
        self.sizer_6_copy_staticbox = wx.StaticBox(self.notebook_1_pane_2, -1, "Select")
        self.sizer_7_copy_staticbox = wx.StaticBox(self.notebook_1_pane_3, -1, "Commands")
        self.sizer_8_copy_staticbox = wx.StaticBox(self.notebook_1_pane_3, -1, "Select")
        self.sizer_9_copy_staticbox = wx.StaticBox(self.notebook_1_pane_4, -1, "Commands")
        self.sizer_10_copy_staticbox = wx.StaticBox(self.notebook_1_pane_4, -1, "Select")
        self.sizer_4_staticbox = wx.StaticBox(self.notebook_1_pane_1, -1, "List View")
        self.frame_1_statusbar = self.CreateStatusBar(1, 0)
        self.text_ctrl_1_copy = wx.TextCtrl(self.notebook_1_pane_1, -1, "This is a minimal example of an ObjectListView. The programmer defines the columns that should be shown -- this includes the attribute that should be should be displayed in the column. Once the columns are defined, the programmer gives the control a collection of model objects. The ObjectListView then manages the displaying and sorting of the list by itself. This tab shows what is possible using only the columns definitions, without handling any callbacks. The 'Album' column is a space filling column -- it will automatically shrink or expand to fill any available space.", style=wx.TE_MULTILINE|wx.TE_READONLY|wx.TE_LINEWRAP|wx.TE_WORDWRAP)
        self.olvSimple = ObjectListView(self.notebook_1_pane_1, -1, style=wx.LC_REPORT|wx.SUNKEN_BORDER)
        self.radio_btn_1 = wx.RadioButton(self.notebook_1_pane_1, -1, "Detail")
        self.radio_btn_2 = wx.RadioButton(self.notebook_1_pane_1, -1, "List")
        self.radio_btn_3 = wx.RadioButton(self.notebook_1_pane_1, -1, "Small Icon")
        self.radio_btn_4 = wx.RadioButton(self.notebook_1_pane_1, -1, "Large Icon")
        self.button_1 = wx.Button(self.notebook_1_pane_1, -1, "Repopulate")
        self.button_2 = wx.Button(self.notebook_1_pane_1, -1, "Add 1000")
        self.button_6 = wx.Button(self.notebook_1_pane_1, -1, "&Update selected")
        self.button_7 = wx.Button(self.notebook_1_pane_1, -1, "Clear List")
        self.button_3 = wx.Button(self.notebook_1_pane_1, -1, "All")
        self.button_4 = wx.Button(self.notebook_1_pane_1, -1, "U2's")
        self.button_5 = wx.Button(self.notebook_1_pane_1, -1, "None")
        self.text_ctrl_1_copy_copy = wx.TextCtrl(self.notebook_1_pane_2, -1, "This is a more complete example of what an ObjectListView can do. It uses callbacks to: decided the image for the Artist and Rating columns; to format the rows, taking into account any colour or font set for the row (changes to the \"Colour\" and \"Font\" values will effect their row). It also shows listening for cell edit events (the second row cannot be edited; the Artist and Album are text boxes that autocomplete, and the Genre is combo box that also alsocompletes. The Colour and Font columns have custom editors installed.", style=wx.TE_MULTILINE|wx.TE_READONLY|wx.TE_LINEWRAP|wx.TE_WORDWRAP)
        self.olvComplex = ObjectListView(self.notebook_1_pane_2, -1, style=wx.LC_REPORT|wx.SUNKEN_BORDER)
        self.radio_btn_1_copy = wx.RadioButton(self.notebook_1_pane_2, -1, "Detail")
        self.radio_btn_2_copy = wx.RadioButton(self.notebook_1_pane_2, -1, "List")
        self.radio_btn_3_copy = wx.RadioButton(self.notebook_1_pane_2, -1, "Small Icon")
        self.radio_btn_4_copy = wx.RadioButton(self.notebook_1_pane_2, -1, "Large Icon")
        self.button_1_copy = wx.Button(self.notebook_1_pane_2, -1, "Repopulate")
        self.button_2_copy = wx.Button(self.notebook_1_pane_2, -1, "Add 1000")
        self.button_6_copy = wx.Button(self.notebook_1_pane_2, -1, "&Update selected")
        self.button_7_copy_1 = wx.Button(self.notebook_1_pane_2, -1, "Clear List")
        self.button_3_copy = wx.Button(self.notebook_1_pane_2, -1, "All")
        self.button_4_copy = wx.Button(self.notebook_1_pane_2, -1, "U2's")
        self.button_5_copy = wx.Button(self.notebook_1_pane_2, -1, "None")
        self.text_ctrl_1_copy_1_copy = wx.TextCtrl(self.notebook_1_pane_3, -1, "A VirtualObjectListView can handle a large number of rows in virtually constant time. It uses the same manner of defining columns and the aspect the columns should show, but is different in its manner of accessing model objects. Instead of passing it a collection of objects, the programmer tells the control how many objects are in the list, and provides a callback that will provide the model objects when they are required. The downside of a virtual list is that it cannot iterate through its items, so it cannot sort its items.\nThe list below has 10 million rows. Do not try this with a normal list view.", style=wx.TE_MULTILINE|wx.TE_READONLY|wx.TE_LINEWRAP|wx.TE_WORDWRAP)
        self.olvVirtual = VirtualObjectListView(self.notebook_1_pane_3, -1, style=wx.LC_REPORT|wx.SUNKEN_BORDER)
        self.button_7_copy = wx.Button(self.notebook_1_pane_3, -1, "Repopulate")
        self.button_8_copy = wx.Button(self.notebook_1_pane_3, -1, "Add 1000")
        self.button_9_copy = wx.Button(self.notebook_1_pane_3, -1, "Update Selected")
        self.button_7_copy_2 = wx.Button(self.notebook_1_pane_3, -1, "Clear List")
        self.button_10_copy = wx.Button(self.notebook_1_pane_3, -1, "All")
        self.button_11_copy = wx.Button(self.notebook_1_pane_3, -1, "None")
        self.text_ctrl_1_copy_2 = wx.TextCtrl(self.notebook_1_pane_4, -1, "A FastObjectListView is a compromise between the functionality of an ObjectListView and the speed of a VirtualObjectListView. In many cases, it can be used as a drop in replacement for an ObjectListView. It supports sorting and model-level operations: SelectObject(), RefreshObject(). For a large number of objects, it is much faster than a normal list view.", style=wx.TE_MULTILINE|wx.TE_READONLY|wx.TE_LINEWRAP|wx.TE_WORDWRAP)
        self.olvFast = FastObjectListView(self.notebook_1_pane_4, -1, style=wx.LC_REPORT|wx.SUNKEN_BORDER)
        self.button_12_copy = wx.Button(self.notebook_1_pane_4, -1, "Repopulate")
        self.button_13_copy = wx.Button(self.notebook_1_pane_4, -1, "Add 1000")
        self.button_14_copy = wx.Button(self.notebook_1_pane_4, -1, "Update Selected")
        self.button_7_copy_3 = wx.Button(self.notebook_1_pane_4, -1, "Clear List")
        self.button_15_copy = wx.Button(self.notebook_1_pane_4, -1, "All")
        self.button_16_copy = wx.Button(self.notebook_1_pane_4, -1, "U2's")
        self.button_17_copy = wx.Button(self.notebook_1_pane_4, -1, "None")
        self.label_1 = wx.StaticText(self.notebook_1_pane_5, -1, "label_1")
        self.label_2 = wx.StaticText(self.notebook_1_pane_5, -1, "label_2")
        self.label_3 = wx.StaticText(self.notebook_1_pane_5, -1, "label_3")
        self.olvDummy = ObjectListView(self.notebook_1_pane_5, -1, style=wx.LC_REPORT|wx.SUNKEN_BORDER)

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_LIST_COL_DRAGGING, self.OnColDragging, self.olvSimple)
        self.Bind(wx.EVT_RADIOBUTTON, self.OnListViewDetails, self.radio_btn_1)
        self.Bind(wx.EVT_RADIOBUTTON, self.OnListViewList, self.radio_btn_2)
        self.Bind(wx.EVT_RADIOBUTTON, self.OnListViewSmallIcon, self.radio_btn_3)
        self.Bind(wx.EVT_RADIOBUTTON, self.OnListViewLargeIcon, self.radio_btn_4)
        self.Bind(wx.EVT_BUTTON, self.OnRepopulate, self.button_1)
        self.Bind(wx.EVT_BUTTON, self.OnAdd1000, self.button_2)
        self.Bind(wx.EVT_BUTTON, self.OnUpdateSelected, self.button_6)
        self.Bind(wx.EVT_BUTTON, self.OnClearListSimple, self.button_7)
        self.Bind(wx.EVT_BUTTON, self.OnSelectAll, self.button_3)
        self.Bind(wx.EVT_BUTTON, self.OnSelectU2s, self.button_4)
        self.Bind(wx.EVT_BUTTON, self.OnSelectNone, self.button_5)
        self.Bind(wx.EVT_LIST_COL_DRAGGING, self.OnColDragging, self.olvComplex)
        self.Bind(wx.EVT_RADIOBUTTON, self.OnListViewDetailsComplex, self.radio_btn_1_copy)
        self.Bind(wx.EVT_RADIOBUTTON, self.OnListViewListComplex, self.radio_btn_2_copy)
        self.Bind(wx.EVT_RADIOBUTTON, self.OnListViewSmallIconComplex, self.radio_btn_3_copy)
        self.Bind(wx.EVT_RADIOBUTTON, self.OnListViewLargeIconComplex, self.radio_btn_4_copy)
        self.Bind(wx.EVT_BUTTON, self.OnRepopulateComplex, self.button_1_copy)
        self.Bind(wx.EVT_BUTTON, self.OnAdd1000Complex, self.button_2_copy)
        self.Bind(wx.EVT_BUTTON, self.OnUpdateSelectedComplex, self.button_6_copy)
        self.Bind(wx.EVT_BUTTON, self.OnClearListComplex, self.button_7_copy_1)
        self.Bind(wx.EVT_BUTTON, self.OnSelectAllComplex, self.button_3_copy)
        self.Bind(wx.EVT_BUTTON, self.OnSelectU2sComplex, self.button_4_copy)
        self.Bind(wx.EVT_BUTTON, self.OnSelectNoneComplex, self.button_5_copy)
        self.Bind(wx.EVT_BUTTON, self.OnRepopulateVirtual, self.button_7_copy)
        self.Bind(wx.EVT_BUTTON, self.OnAdd1000Virtual, self.button_8_copy)
        self.Bind(wx.EVT_BUTTON, self.OnUpdateSelectedVirtual, self.button_9_copy)
        self.Bind(wx.EVT_BUTTON, self.OnClearListVirtual, self.button_7_copy_2)
        self.Bind(wx.EVT_BUTTON, self.OnSelectAllVirtual, self.button_10_copy)
        self.Bind(wx.EVT_BUTTON, self.OnSelectNoneVirtual, self.button_11_copy)
        self.Bind(wx.EVT_BUTTON, self.OnRepopulateFast, self.button_12_copy)
        self.Bind(wx.EVT_BUTTON, self.OnAdd1000Fast, self.button_13_copy)
        self.Bind(wx.EVT_BUTTON, self.OnUpdateSelectedFast, self.button_14_copy)
        self.Bind(wx.EVT_BUTTON, self.OnClearListFast, self.button_7_copy_3)
        self.Bind(wx.EVT_BUTTON, self.OnSelectAllFast, self.button_15_copy)
        self.Bind(wx.EVT_BUTTON, self.OnSelectU2sFast, self.button_16_copy)
        self.Bind(wx.EVT_BUTTON, self.OnSelectNoneFast, self.button_17_copy)
        # end wxGlade

        self.Init()

    def __set_properties(self):
        # begin wxGlade: MyFrame.__set_properties
        self.SetTitle("ObjectListView Demo")
        self.SetSize((1274, 788))
        self.frame_1_statusbar.SetStatusWidths([-1])
        # statusbar fields
        frame_1_statusbar_fields = ["frame_1_statusbar"]
        for i in range(len(frame_1_statusbar_fields)):
            self.frame_1_statusbar.SetStatusText(frame_1_statusbar_fields[i], i)
        self.text_ctrl_1_copy.SetBackgroundColour(wx.Colour(252, 255, 138))
        self.radio_btn_1.SetValue(1)
        self.text_ctrl_1_copy_copy.SetBackgroundColour(wx.Colour(252, 255, 138))
        self.radio_btn_1_copy.SetValue(1)
        self.text_ctrl_1_copy_1_copy.SetBackgroundColour(wx.Colour(252, 255, 138))
        self.text_ctrl_1_copy_2.SetBackgroundColour(wx.Colour(252, 255, 138))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: MyFrame.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        grid_sizer_1 = wx.GridSizer(2, 2, 4, 4)
        grid_sizer_3_copy = wx.FlexGridSizer(3, 1, 4, 4)
        grid_sizer_4_copy = wx.FlexGridSizer(1, 2, 4, 4)
        sizer_10_copy = wx.StaticBoxSizer(self.sizer_10_copy_staticbox, wx.HORIZONTAL)
        sizer_9_copy = wx.StaticBoxSizer(self.sizer_9_copy_staticbox, wx.HORIZONTAL)
        grid_sizer_1_copy = wx.FlexGridSizer(3, 1, 4, 4)
        grid_sizer_2_copy = wx.FlexGridSizer(1, 2, 4, 4)
        sizer_8_copy = wx.StaticBoxSizer(self.sizer_8_copy_staticbox, wx.HORIZONTAL)
        sizer_7_copy = wx.StaticBoxSizer(self.sizer_7_copy_staticbox, wx.HORIZONTAL)
        sizer_2_copy = wx.FlexGridSizer(3, 1, 0, 0)
        sizer_3_copy = wx.FlexGridSizer(1, 3, 0, 0)
        sizer_6_copy = wx.StaticBoxSizer(self.sizer_6_copy_staticbox, wx.HORIZONTAL)
        sizer_5_copy = wx.StaticBoxSizer(self.sizer_5_copy_staticbox, wx.HORIZONTAL)
        sizer_4_copy = wx.StaticBoxSizer(self.sizer_4_copy_staticbox, wx.HORIZONTAL)
        sizer_2 = wx.FlexGridSizer(3, 1, 0, 0)
        sizer_3 = wx.FlexGridSizer(1, 3, 0, 0)
        sizer_6 = wx.StaticBoxSizer(self.sizer_6_staticbox, wx.HORIZONTAL)
        sizer_5 = wx.StaticBoxSizer(self.sizer_5_staticbox, wx.HORIZONTAL)
        sizer_4 = wx.StaticBoxSizer(self.sizer_4_staticbox, wx.HORIZONTAL)
        sizer_2.Add(self.text_ctrl_1_copy, 0, wx.TOP|wx.EXPAND, 4)
        sizer_2.Add(self.olvSimple, 1, wx.ALL|wx.EXPAND, 4)
        sizer_4.Add(self.radio_btn_1, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_4.Add(self.radio_btn_2, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_4.Add(self.radio_btn_3, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_4.Add(self.radio_btn_4, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_3.Add(sizer_4, 1, wx.ALL|wx.EXPAND, 4)
        sizer_5.Add(self.button_1, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_5.Add(self.button_2, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_5.Add(self.button_6, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_5.Add(self.button_7, 0, wx.ALL, 4)
        sizer_3.Add(sizer_5, 1, wx.ALL|wx.EXPAND, 4)
        sizer_6.Add(self.button_3, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_6.Add(self.button_4, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_6.Add(self.button_5, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_3.Add(sizer_6, 1, wx.ALL|wx.EXPAND, 4)
        sizer_2.Add(sizer_3, 1, wx.EXPAND, 4)
        self.notebook_1_pane_1.SetSizer(sizer_2)
        sizer_2.AddGrowableRow(1)
        sizer_2.AddGrowableCol(0)
        sizer_2_copy.Add(self.text_ctrl_1_copy_copy, 0, wx.TOP|wx.EXPAND, 4)
        sizer_2_copy.Add(self.olvComplex, 1, wx.ALL|wx.EXPAND, 4)
        sizer_4_copy.Add(self.radio_btn_1_copy, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_4_copy.Add(self.radio_btn_2_copy, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_4_copy.Add(self.radio_btn_3_copy, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_4_copy.Add(self.radio_btn_4_copy, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_3_copy.Add(sizer_4_copy, 1, wx.ALL|wx.EXPAND, 4)
        sizer_5_copy.Add(self.button_1_copy, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_5_copy.Add(self.button_2_copy, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_5_copy.Add(self.button_6_copy, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_5_copy.Add(self.button_7_copy_1, 0, wx.ALL, 4)
        sizer_3_copy.Add(sizer_5_copy, 1, wx.ALL|wx.EXPAND, 4)
        sizer_6_copy.Add(self.button_3_copy, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_6_copy.Add(self.button_4_copy, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_6_copy.Add(self.button_5_copy, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_3_copy.Add(sizer_6_copy, 1, wx.ALL|wx.EXPAND, 4)
        sizer_2_copy.Add(sizer_3_copy, 1, wx.EXPAND, 4)
        self.notebook_1_pane_2.SetSizer(sizer_2_copy)
        sizer_2_copy.AddGrowableRow(1)
        sizer_2_copy.AddGrowableCol(0)
        grid_sizer_1_copy.Add(self.text_ctrl_1_copy_1_copy, 0, wx.TOP|wx.EXPAND, 4)
        grid_sizer_1_copy.Add(self.olvVirtual, 1, wx.EXPAND, 0)
        sizer_7_copy.Add(self.button_7_copy, 0, wx.ALL, 4)
        sizer_7_copy.Add(self.button_8_copy, 0, wx.ALL, 4)
        sizer_7_copy.Add(self.button_9_copy, 0, wx.ALL, 4)
        sizer_7_copy.Add(self.button_7_copy_2, 0, wx.ALL, 4)
        grid_sizer_2_copy.Add(sizer_7_copy, 1, wx.EXPAND, 0)
        sizer_8_copy.Add(self.button_10_copy, 0, wx.ALL, 4)
        sizer_8_copy.Add(self.button_11_copy, 0, wx.ALL, 4)
        grid_sizer_2_copy.Add(sizer_8_copy, 1, wx.EXPAND, 0)
        grid_sizer_1_copy.Add(grid_sizer_2_copy, 1, wx.EXPAND, 0)
        self.notebook_1_pane_3.SetSizer(grid_sizer_1_copy)
        grid_sizer_1_copy.AddGrowableRow(1)
        grid_sizer_1_copy.AddGrowableCol(0)
        grid_sizer_3_copy.Add(self.text_ctrl_1_copy_2, 0, wx.TOP|wx.EXPAND, 4)
        grid_sizer_3_copy.Add(self.olvFast, 1, wx.EXPAND, 0)
        sizer_9_copy.Add(self.button_12_copy, 0, wx.ALL, 4)
        sizer_9_copy.Add(self.button_13_copy, 0, wx.ALL, 4)
        sizer_9_copy.Add(self.button_14_copy, 0, wx.ALL, 4)
        sizer_9_copy.Add(self.button_7_copy_3, 0, wx.ALL, 4)
        grid_sizer_4_copy.Add(sizer_9_copy, 1, wx.EXPAND, 0)
        sizer_10_copy.Add(self.button_15_copy, 0, wx.ALL, 4)
        sizer_10_copy.Add(self.button_16_copy, 0, wx.ALL, 4)
        sizer_10_copy.Add(self.button_17_copy, 0, wx.ALL, 4)
        grid_sizer_4_copy.Add(sizer_10_copy, 1, wx.EXPAND, 0)
        grid_sizer_3_copy.Add(grid_sizer_4_copy, 1, wx.EXPAND, 0)
        self.notebook_1_pane_4.SetSizer(grid_sizer_3_copy)
        grid_sizer_3_copy.AddGrowableRow(1)
        grid_sizer_3_copy.AddGrowableCol(0)
        grid_sizer_1.Add(self.label_1, 0, wx.ALL, 4)
        grid_sizer_1.Add(self.label_2, 0, wx.ALL, 4)
        grid_sizer_1.Add(self.label_3, 0, wx.ALL|wx.EXPAND, 4)
        grid_sizer_1.Add(self.olvDummy, 1, wx.EXPAND, 0)
        self.notebook_1_pane_5.SetSizer(grid_sizer_1)
        self.notebook_1.AddPage(self.notebook_1_pane_1, "Simple")
        self.notebook_1.AddPage(self.notebook_1_pane_2, "Complex")
        self.notebook_1.AddPage(self.notebook_1_pane_3, "Virtual")
        self.notebook_1.AddPage(self.notebook_1_pane_4, "Fast")
        self.notebook_1.AddPage(self.notebook_1_pane_5, "Dummy")
        sizer_1.Add(self.notebook_1, 1, wx.ALL|wx.EXPAND, 4)
        self.SetSizer(sizer_1)
        self.Layout()
        # end wxGlade

    #----------------------------------------------------------------------
    # Initialize

    def Init(self):
        self.InitModel()
        self.InitUI()

    def InitModel(self):
        self.counter = 0
        self.dataObjects = [
            Track(title="Zoo Station", artist="U2", size=5.5, album="Achtung Baby", genre="Rock", rating=60, duration="4:37", lastPlayed="21/10/2007 5:42 PM"),
            Track(title="Who's Gonna Ride Your Wild Horses", artist="U2", size=6.3, album="Achtung Baby", genre="Rock", rating=80, duration="5:17", lastPlayed="9/10/2007 11:32 AM"),
            Track(title="So Cruel", artist="U2", size=6.9, album="Achtung Baby", genre="Rock", rating=60, duration="5:49", lastPlayed="9/10/2007 11:38 AM"),
            Track(title="The Fly", artist="U2", size=5.4, album="Achtung Baby", genre="Rock", rating=60, duration="4:29", lastPlayed="9/10/2007 11:42 AM"),
            Track(title="Tryin' To Throw Your Arms Around The World", artist="U2", size=4.7, album="Achtung Baby", genre="Rock", rating=60, duration="3:53", lastPlayed="9/10/2007 11:46 AM"),
            Track(title="Ultraviolet (Light My Way)", artist="U2", size=6.6, album="Achtung Baby", genre="Rock", rating=60, duration="5:31", lastPlayed="9/10/2007 11:52 AM"),
            Track(title="Acrobat", artist="U2", size=5.4, album="Achtung Baby", genre="Rock", rating=60, duration="4:30", lastPlayed="9/10/2007 11:56 AM"),
            Track(title="Love Is Blindness", artist="U2", size=5.3, album="Achtung Baby", genre="Rock", rating=60, duration="4:26", lastPlayed="9/10/2007 12:00 PM"),
            Track(title="Elevation", artist="U2", size=4.5, album="All That You Can't Leave Behind", genre="Rock", rating=60, duration="3:48", lastPlayed="25/01/2008 11:46 PM"),
            Track(title="Walk On", artist="U2", size=5.8, album="All That You Can't Leave Behind", genre="Rock", rating=100, duration="4:56", lastPlayed="18/03/2008 11:39 PM"),
            Track(title="Kite", artist="U2", size=5.2, album="All That You Can't Leave Behind", genre="Rock", rating=40, duration="4:27", lastPlayed="23/01/2008 10:36 PM"),
            Track(title="In A Little While", artist="U2", size=4.3, album="All That You Can't Leave Behind", genre="Rock", rating=60, duration="3:39", lastPlayed="20/01/2008 7:48 PM"),
            Track(title="Wild Honey", artist="U2", size=4.5, album="All That You Can't Leave Behind", genre="Rock", rating=40, duration="3:47", lastPlayed="13/04/2007 11:50 AM"),
            Track(title="Peace On Earth", artist="U2", size=5.6, album="All That You Can't Leave Behind", genre="Rock", rating=40, duration="4:48", lastPlayed="22/12/2007 2:51 PM"),
            Track(title="When I Look At The World", artist="U2", size=5.1, album="All That You Can't Leave Behind", genre="Rock", rating=40, duration="4:18", lastPlayed="22/12/2007 2:55 PM"),
            Track(title="New York", artist="U2", size=6.4, album="All That You Can't Leave Behind", genre="Rock", rating=60, duration="5:30", lastPlayed="22/12/2007 3:01 PM"),
            Track(title="Grace", artist="U2", size=6.5, album="All That You Can't Leave Behind", genre="Rock", rating=40, duration="5:32", lastPlayed="22/12/2007 3:06 PM"),
            Track(title="The Ground Beneath Her Feet(Bonus Track)", artist="U2", size=4.4, album="All That You Can't Leave Behind", genre="Rock", rating=40, duration="3:44", lastPlayed="22/12/2007 3:10 PM"),
            Track(title="Follow You Home", artist="Nickelback", size=6, album="All The Right Reasons", genre="Rock", rating=40, duration="4:20", lastPlayed="6/03/2008 10:42 PM"),
            Track(title="Fight For All The Wrong Reason", artist="Nickelback", size=5.2, album="All The Right Reasons", genre="Rock", rating=60, duration="3:44", lastPlayed="15/03/2008 5:04 PM"),
            Track(title="Photograph", artist="Nickelback", size=6, album="All The Right Reasons", genre="Rock", rating=60, duration="4:19", lastPlayed="15/03/2008 5:08 PM"),
            Track(title="Animals", artist="Nickelback", size=4.3, album="All The Right Reasons", genre="Rock", rating=40, duration="3:07", lastPlayed="16/02/2008 12:12 AM"),
            Track(title="Savin' Me", artist="Nickelback", size=5.1, album="All The Right Reasons", genre="Rock", rating=80, duration="3:39", lastPlayed="24/03/2008 10:41 AM"),
            Track(title="Far Away", artist="Nickelback", size=5.5, album="All The Right Reasons", genre="Rock", rating=40, duration="3:58", lastPlayed="15/03/2008 5:30 PM"),
            Track(title="Next Contestant", artist="Nickelback", size=5, album="All The Right Reasons", genre="Rock", rating=80, duration="3:35", lastPlayed="24/03/2008 9:47 AM"),
            Track(title="Side Of A Bullet", artist="Nickelback", size=4.2, album="All The Right Reasons", genre="Rock", rating=40, duration="3:01", lastPlayed="6/03/2008 11:00 PM"),
            Track(title="If Everyone Cared", artist="Nickelback", size=5, album="All The Right Reasons", genre="Rock", rating=60, duration="3:38", lastPlayed="6/03/2008 11:03 PM"),
            Track(title="Someone That You're With", artist="Nickelback", size=5.6, album="All The Right Reasons", genre="Rock", rating=40, duration="4:02", lastPlayed="16/02/2008 12:34 AM"),
            Track(title="Rockstar", artist="Nickelback", size=5.9, album="All The Right Reasons", genre="Rock", rating=60, duration="4:16", lastPlayed="16/02/2008 12:38 AM"),
            Track(title="Lelani", artist="Hoodoo Gurus", size=5.9, album="Ampology", genre="Rock", rating=60, duration="4:55", lastPlayed="22/10/2007 8:45 PM"),
            Track(title="Tojo", artist="Hoodoo Gurus", size=4.1, album="Ampology", genre="Rock", rating=60, duration="3:22", lastPlayed="22/10/2007 8:48 PM"),
            Track(title="My Girl", artist="Hoodoo Gurus", size=3.3, album="Ampology", genre="Rock", rating=80, duration="2:39", lastPlayed="12/11/2007 7:57 PM"),
            Track(title="Be My Guru", artist="Hoodoo Gurus", size=3.3, album="Ampology", genre="Rock", rating=100, duration="2:39", lastPlayed="20/03/2008 12:15 PM"),
            Track(title="I Want You Back", artist="Hoodoo Gurus", size=3.9, album="Ampology", genre="Rock", rating=80, duration="3:12", lastPlayed="12/11/2007 7:42 PM"),
            Track(title="I Was A Kamikaze Pilot", artist="Hoodoo Gurus", size=3.9, album="Ampology", genre="Rock", rating=60, duration="3:10", lastPlayed="22/10/2007 9:00 PM"),
            Track(title="Bittersweet", artist="Hoodoo Gurus", size=4.7, album="Ampology", genre="Rock", rating=60, duration="3:52", lastPlayed="22/10/2007 9:04 PM"),
            Track(title="Poison Pen", artist="Hoodoo Gurus", size=5, album="Ampology", genre="Rock", rating=60, duration="4:11", lastPlayed="22/10/2007 9:11 PM"),
            Track(title="In The Wild", artist="Hoodoo Gurus", size=3.9, album="Ampology", genre="Rock", rating=60, duration="3:12", lastPlayed="22/10/2007 9:14 PM"),
            Track(title="Whats My Scene?", artist="Hoodoo Gurus", size=4.6, album="Ampology", genre="Rock", rating=100, duration="3:49", lastPlayed="12/11/2007 7:51 PM"),
            Track(title="Heart Of Darkness", artist="Hoodoo Gurus", size=3.8, album="Ampology", genre="Rock", rating=60, duration="3:04", lastPlayed="22/10/2007 9:21 PM"),
            Track(title="Good Times", artist="Hoodoo Gurus", size=3.7, album="Ampology", genre="Rock", rating=80, duration="3:02", lastPlayed="20/03/2008 12:18 PM"),
            Track(title="Cajun Country", artist="Hoodoo Gurus", size=4.9, album="Ampology", genre="Rock", rating=60, duration="4:06", lastPlayed="22/10/2007 9:28 PM"),
            Track(title="Axegrinder", artist="Hoodoo Gurus", size=4.2, album="Ampology", genre="Rock", rating=60, duration="3:26", lastPlayed="22/10/2007 9:32 PM"),
            Track(title="Another World", artist="Hoodoo Gurus", size=4, album="Ampology", genre="Rock", rating=80, duration="3:16", lastPlayed="20/03/2008 12:21 PM"),
            Track(title="Meant To Live", artist="Switchfoot", size=4, album="The Beautiful Letdown", genre="Gospel & Religious", rating=100, duration="3:26", lastPlayed="3/03/2008 1:46 PM"),
            Track(title="This Is Your Life", artist="Switchfoot", size=4, album="The Beautiful Letdown", genre="Gospel & Religious", rating=100, duration="4:18", lastPlayed="3/03/2008 2:11 PM"),
            Track(title="More than fine", artist="Switchfoot", size=4.9, album="The Beautiful Letdown", genre="Gospel & Religious", rating=60, duration="4:15", lastPlayed="3/03/2008 2:16 PM"),
            Track(title="Ammunition", artist="Switchfoot", size=4.4, album="The Beautiful Letdown", genre="Gospel & Religious", rating=40, duration="3:46", lastPlayed="3/03/2008 1:58 PM"),
            Track(title="Dare you to move", artist="Switchfoot", size=4.9, album="The Beautiful Letdown", genre="Gospel & Religious", rating=80, duration="4:15", lastPlayed="3/03/2008 2:20 PM"),
            Track(title="Redemption", artist="Switchfoot", size=3.6, album="The Beautiful Letdown", genre="Gospel & Religious", rating=80, duration="3:07", lastPlayed="19/03/2008 5:19 PM"),
            Track(title="The beautiful letdown", artist="Switchfoot", size=6.2, album="The Beautiful Letdown", genre="Gospel & Religious", rating=60, duration="5:21", lastPlayed="3/03/2008 2:29 PM"),
            Track(title="Gone", artist="Switchfoot", size=4.4, album="The Beautiful Letdown", genre="Gospel & Religious", rating=80, duration="3:46", lastPlayed="3/03/2008 2:33 PM"),
            Track(title="On Fire", artist="Switchfoot", size=4.3, album="The Beautiful Letdown", genre="Gospel & Religious", rating=80, duration="4:39", lastPlayed="3/03/2008 2:37 PM"),
            Track(title="Adding to the noise", artist="Switchfoot", size=3.3, album="The Beautiful Letdown", genre="Gospel & Religious", rating=60, duration="2:51", lastPlayed="19/03/2008 5:42 PM"),
            Track(title="Twenty-four", artist="Switchfoot", size=5.7, album="The Beautiful Letdown", genre="Gospel & Religious", rating=60, duration="4:54", lastPlayed="3/03/2008 2:45 PM"),
            Track(title="Gap That Opened", artist="Boom Crash Opera", size=4.7, album="Boom Crash Opera", genre="Rock", rating=40, duration="4:02", lastPlayed="13/01/2008 10:11 PM"),
            Track(title="Hands Up In The Air", artist="Boom Crash Opera", size=4.5, album="Boom Crash Opera", genre="Rock", rating=80, duration="3:53", lastPlayed="24/03/2008 3:19 PM"),
            Track(title="Love Me To Death", artist="Boom Crash Opera", size=5.2, album="Boom Crash Opera", genre="Rock", rating=40, duration="4:27", lastPlayed="13/01/2008 10:20 PM"),
            Track(title="City Fist", artist="Boom Crash Opera", size=4.9, album="Boom Crash Opera", genre="Rock", rating=40, duration="4:11", lastPlayed="13/01/2008 10:24 PM"),
            Track(title="Her Charity", artist="Boom Crash Opera", size=5.8, album="Boom Crash Opera", genre="Rock", rating=40, duration="5:01", lastPlayed="13/01/2008 10:29 PM"),
            Track(title="Sleeping Time", artist="Boom Crash Opera", size=5.2, album="Boom Crash Opera", genre="Rock", rating=40, duration="4:26", lastPlayed="13/01/2008 10:33 PM"),
            Track(title="Great Wall", artist="Boom Crash Opera", size=4.5, album="Boom Crash Opera", genre="Rock", rating=80, duration="3:51", lastPlayed="24/03/2008 3:22 PM"),
            Track(title="Bombshell", artist="Boom Crash Opera", size=4.5, album="Boom Crash Opera", genre="Rock", rating=40, duration="3:50", lastPlayed="13/01/2008 10:41 PM"),
            Track(title="Caught Between Two Towns", artist="Boom Crash Opera", size=4, album="Boom Crash Opera", genre="Rock", rating=40, duration="3:28", lastPlayed="13/01/2008 10:44 PM"),
            Track(title="Too Hot To Think", artist="Boom Crash Opera", size=6.3, album="Boom Crash Opera", genre="Rock", rating=40, duration="5:26", lastPlayed="13/01/2008 10:50 PM"),
            Track(title="Starting Today", artist="Natalie Imbruglia", size=6.8, album="Counting Down the Days", genre="Adult Alternative Pop/Rock", rating=0, duration="2:56", lastPlayed="19/03/2008 9:48 PM"),
            Track(title="Shiver", artist="Natalie Imbruglia", size=8.6, album="Counting Down the Days", genre="Adult Alternative Pop/Rock", rating=80, duration="3:45", lastPlayed="19/03/2008 9:51 PM"),
            Track(title="Satisfied", artist="Natalie Imbruglia", size=8.1, album="Counting Down the Days", genre="Adult Alternative Pop/Rock", rating=0, duration="3:30", lastPlayed="19/03/2008 9:55 PM"),
            Track(title="Counting Down the Days", artist="Natalie Imbruglia", size=9.6, album="Counting Down the Days", genre="Adult Alternative Pop/Rock", rating=60, duration="4:09", lastPlayed="26/03/2008 10:33 PM"),
            Track(title="I Won't Be Lost", artist="Natalie Imbruglia", size=9, album="Counting Down the Days", genre="Adult Alternative Pop/Rock", rating=60, duration="3:53", lastPlayed="26/03/2008 10:37 PM"),
            Track(title="Slow Down", artist="Natalie Imbruglia", size=8.1, album="Counting Down the Days", genre="Adult Alternative Pop/Rock", rating=60, duration="3:32", lastPlayed="26/03/2008 10:41 PM"),
            Track(title="Sanctuary", artist="Natalie Imbruglia", size=7.3, album="Counting Down the Days", genre="Adult Alternative Pop/Rock", rating=60, duration="3:09", lastPlayed="26/03/2008 10:44 PM"),
            Track(title="Perfectly", artist="Natalie Imbruglia", size=7.8, album="Counting Down the Days", genre="Adult Alternative Pop/Rock", rating=80, duration="3:24", lastPlayed="26/03/2008 10:47 PM"),
            Track(title="On the Run", artist="Natalie Imbruglia", size=8.4, album="Counting Down the Days", genre="Adult Alternative Pop/Rock", rating=60, duration="3:38", lastPlayed="26/03/2008 10:51 PM"),
            Track(title="Come on Home", artist="Natalie Imbruglia", size=9.1, album="Counting Down the Days", genre="Adult Alternative Pop/Rock", rating=60, duration="3:56", lastPlayed="26/03/2008 10:55 PM"),
            Track(title="When You're Sleeping", artist="Natalie Imbruglia", size=7.2, album="Counting Down the Days", genre="Adult Alternative Pop/Rock", rating=60, duration="3:07", lastPlayed="26/03/2008 10:58 PM"),
            Track(title="Honeycomb Child", artist="Natalie Imbruglia", size=9.8, album="Counting Down the Days", genre="Adult Alternative Pop/Rock", rating=0, duration="4:15", lastPlayed="26/03/2008 11:02 PM"),
            Track(title="Last Living Souls", artist="Gorillaz", size=4.5, album="Demon Days", genre="Hip-Hop", rating=80, duration="3:11", lastPlayed="12/01/2008 9:55 PM"),
            Track(title="Kids With Guns", artist="Gorillaz", size=5.3, album="Demon Days", genre="Hip-Hop", rating=80, duration="3:46", lastPlayed="24/03/2008 12:52 PM"),
            Track(title="O Green World", artist="Gorillaz", size=6.3, album="Demon Days", genre="Hip-Hop", rating=80, duration="4:32", lastPlayed="24/03/2008 12:45 PM"),
            Track(title="Dirty Harry", artist="Gorillaz", size=5.2, album="Demon Days", genre="Hip-Hop", rating=80, duration="3:44", lastPlayed="24/03/2008 12:48 PM"),
            Track(title="Feel Good Inc.", artist="Gorillaz", size=5.4, album="Demon Days", genre="Hip-Hop", rating=100, duration="3:41", lastPlayed="24/03/2008 1:07 PM"),
            Track(title="El Manana", artist="Gorillaz", size=5.4, album="Demon Days", genre="Hip-Hop", rating=40, duration="3:50", lastPlayed="17/03/2008 5:45 PM"),
            Track(title="Every Plant We Reach Is Dead", artist="Gorillaz", size=6.8, album="Demon Days", genre="Hip-Hop", rating=80, duration="4:53", lastPlayed="24/03/2008 12:57 PM"),
            Track(title="November Has Come", artist="Gorillaz", size=3.8, album="Demon Days", genre="Hip-Hop", rating=80, duration="2:41", lastPlayed="24/03/2008 12:59 PM"),
            Track(title="All Alone", artist="Gorillaz", size=4.9, album="Demon Days", genre="Hip-Hop", rating=80, duration="3:30", lastPlayed="12/01/2008 9:49 PM"),
            Track(title="White Light", artist="Gorillaz", size=3, album="Demon Days", genre="Hip-Hop", rating=80, duration="2:09", lastPlayed="17/02/2008 3:30 PM"),
            Track(title="DARE", artist="Gorillaz", size=5.7, album="Demon Days", genre="Hip-Hop", rating=80, duration="4:05", lastPlayed="24/03/2008 1:03 PM"),
            Track(title="Don't Get Lost In Heaven", artist="Gorillaz", size=2.9, album="Demon Days", genre="Hip-Hop", rating=80, duration="2:01", lastPlayed="24/03/2008 12:36 PM"),
            Track(title="Demon Days", artist="Gorillaz", size=6.3, album="Demon Days", genre="Hip-Hop", rating=80, duration="4:29", lastPlayed="24/03/2008 12:40 PM"),
            Track(title="The Pretender", artist="Foo Fighters", size=8.3, album="Echoes, Silence, Patience & Grace", genre="Alternative", rating=60, duration="4:29", lastPlayed="24/03/2008 11:20 AM"),
            Track(title="Let It Die", artist="Foo Fighters", size=7.6, album="Echoes, Silence, Patience & Grace", genre="Alternative", rating=40, duration="4:05", lastPlayed="24/03/2008 11:24 AM"),
            Track(title="Erase/Replace", artist="Foo Fighters", size=7.8, album="Echoes, Silence, Patience & Grace", genre="Alternative", rating=60, duration="4:13", lastPlayed="24/03/2008 11:28 AM"),
            Track(title="Long Road To Ruin", artist="Foo Fighters", size=7, album="Echoes, Silence, Patience & Grace", genre="Alternative", rating=60, duration="3:45", lastPlayed="24/03/2008 11:31 AM"),
            Track(title="Come Alive", artist="Foo Fighters", size=9.6, album="Echoes, Silence, Patience & Grace", genre="Alternative", rating=60, duration="5:10", lastPlayed="24/03/2008 11:37 AM"),
            Track(title="Stranger Things Have Happened", artist="Foo Fighters", size=9.9, album="Echoes, Silence, Patience & Grace", genre="Alternative", rating=80, duration="5:21", lastPlayed="24/03/2008 11:42 AM"),
            Track(title="Cheer Up, Boys (Your Makeup Is Running)", artist="Foo Fighters", size=6.8, album="Echoes, Silence, Patience & Grace", genre="Alternative", rating=40, duration="3:41", lastPlayed="24/03/2008 11:45 AM"),
            Track(title="Summer's End", artist="Foo Fighters", size=8.6, album="Echoes, Silence, Patience & Grace", genre="Alternative", rating=60, duration="4:38", lastPlayed="24/03/2008 11:50 AM"),
            Track(title="The Ballad Of The Beaconsfield", artist="Foo Fighters", size=4.7, album="Echoes, Silence, Patience & Grace", genre="Instrumental", rating=80, duration="2:32", lastPlayed="24/03/2008 11:53 AM"),
            Track(title="Statues", artist="Foo Fighters", size=7, album="Echoes, Silence, Patience & Grace", genre="Alternative", rating=60, duration="3:48", lastPlayed="24/03/2008 11:57 AM"),
            Track(title="But, Honestly", artist="Foo Fighters", size=8.5, album="Echoes, Silence, Patience & Grace", genre="Alternative", rating=40, duration="4:35", lastPlayed="24/03/2008 12:01 PM"),
            Track(title="Home", artist="Foo Fighters", size=9, album="Echoes, Silence, Patience & Grace", genre="Alternative", rating=80, duration="4:52", lastPlayed="24/03/2008 12:06 PM"),
            Track(title="Once And For All (Demo) (Bonus Track)", artist="Foo Fighters", size=7, album="Echoes, Silence, Patience & Grace", genre="Alternative", rating=0, duration="3:48", lastPlayed="24/03/2008 12:10 PM"),
            Track(title="Going Under", artist="Evanescence", size=4.2, album="Fallen", genre="Metal", rating=0, duration="3:35", lastPlayed="4/02/2008 6:09 PM"),
            Track(title="Bring Me To Life", artist="Evanescence", size=4.6, album="Fallen", genre="Metal", rating=100, duration="3:57", lastPlayed="25/03/2008 12:56 AM"),
            Track(title="Everybody's Fool", artist="Evanescence", size=3.8, album="Fallen", genre="Metal", rating=0, duration="3:16", lastPlayed="4/02/2008 6:16 PM"),
            Track(title="Haunted", artist="Evanescence", size=3.6, album="Fallen", genre="Metal", rating=0, duration="3:07", lastPlayed="4/02/2008 6:19 PM"),
            Track(title="Tourniquet", artist="Evanescence", size=5.4, album="Fallen", genre="Metal", rating=0, duration="4:38", lastPlayed="4/02/2008 6:24 PM"),
            Track(title="Imaginary", artist="Evanescence", size=5, album="Fallen", genre="Metal", rating=0, duration="4:18", lastPlayed="4/02/2008 6:28 PM"),
            Track(title="Taking Over Me", artist="Evanescence", size=4.4, album="Fallen", genre="Metal", rating=0, duration="3:50", lastPlayed="15/03/2008 4:57 PM"),
            Track(title="Hello", artist="Evanescence", size=4.3, album="Fallen", genre="Metal", rating=0, duration="3:40", lastPlayed="4/02/2008 6:35 PM"),
            Track(title="My Last Breath", artist="Evanescence", size=4.8, album="Fallen", genre="Metal", rating=0, duration="4:07", lastPlayed="15/03/2008 4:23 PM"),
            Track(title="Whisper", artist="Evanescence", size=6.3, album="Fallen", genre="Metal", rating=0, duration="5:30", lastPlayed="4/02/2008 6:45 PM"),
            Track(title="My Immortal", artist="Evanescence", size=5.3, album="Fallen", genre="Metal", rating=0, duration="4:33", lastPlayed="4/02/2008 6:50 PM"),
            Track(title="One-Trick Pony", artist="Nelly Furtado", size=5, album="Folklore", genre="Pop", rating=80, duration="4:47", lastPlayed="15/03/2008 6:46 PM"),
            Track(title="Powerless (Say What You Want)", artist="Nelly Furtado", size=4.2, album="Folklore", genre="Pop", rating=80, duration="3:52", lastPlayed="15/03/2008 6:50 PM"),
            Track(title="Explode", artist="Nelly Furtado", size=4.1, album="Folklore", genre="Pop", rating=80, duration="3:44", lastPlayed="15/03/2008 6:53 PM"),
            Track(title="Try", artist="Nelly Furtado", size=4.9, album="Folklore", genre="Pop", rating=80, duration="4:39", lastPlayed="15/03/2008 11:49 AM"),
            Track(title="Fresh off the Boat", artist="Nelly Furtado", size=3.7, album="Folklore", genre="Pop", rating=60, duration="3:16", lastPlayed="22/02/2008 12:49 PM"),
            Track(title="Força", artist="Nelly Furtado", size=4, album="Folklore", genre="Pop", rating=40, duration="3:40", lastPlayed="22/02/2008 12:53 PM"),
            Track(title="The Grass Is Green", artist="Nelly Furtado", size=4.2, album="Folklore", genre="Pop", rating=40, duration="3:50", lastPlayed="22/02/2008 12:57 PM"),
            Track(title="Picture Perfect", artist="Nelly Furtado", size=5.5, album="Folklore", genre="Pop", rating=40, duration="5:15", lastPlayed="19/01/2008 12:08 PM"),
            Track(title="Saturdays", artist="Jarvis Church/Nelly Furtado", size=2.6, album="Folklore", genre="Pop", rating=40, duration="2:05", lastPlayed="7/01/2008 7:33 PM"),
            Track(title="Build You Up", artist="Nelly Furtado", size=5.2, album="Folklore", genre="Pop", rating=40, duration="4:58", lastPlayed="22/02/2008 1:03 PM"),
            Track(title="Island of Wonder", artist="Caetano Veloso/Nelly Furtado", size=4.2, album="Folklore", genre="Pop", rating=40, duration="3:49", lastPlayed="7/01/2008 7:42 PM"),
            Track(title="The Boy In The Bubble", artist="Paul Simon", size=5.6, album="Graceland", genre="Alternative", rating=60, duration="3:58", lastPlayed="24/01/2008 6:02 PM"),
            Track(title="Graceland", artist="Paul Simon", size=6.7, album="Graceland", genre="Alternative", rating=60, duration="4:48", lastPlayed="24/01/2008 6:07 PM"),
            Track(title="I Know What I Know", artist="Paul Simon", size=4.5, album="Graceland", genre="Alternative", rating=60, duration="3:12", lastPlayed="22/01/2008 5:27 PM"),
            Track(title="Gumboots", artist="Paul Simon", size=3.9, album="Graceland", genre="Alternative", rating=60, duration="2:43", lastPlayed="22/01/2008 5:30 PM"),
            Track(title="Diamonds On The Soles Of Her Shoes", artist="Paul Simon", size=8.1, album="Graceland", genre="Pop", rating=80, duration="5:46", lastPlayed="20/02/2008 9:44 PM"),
            Track(title="You Can Call Me Al", artist="Paul Simon", size=6.5, album="Graceland", genre="Alternative", rating=60, duration="4:39", lastPlayed="22/01/2008 5:40 PM"),
            Track(title="Under African Skies", artist="Paul Simon", size=5.1, album="Graceland", genre="Alternative", rating=60, duration="3:35", lastPlayed="19/03/2008 5:27 PM"),
            Track(title="Homeless", artist="Paul Simon", size=5.3, album="Graceland", genre="Alternative", rating=60, duration="3:47", lastPlayed="23/11/2007 7:01 PM"),
            Track(title="Crazy Love Vol II", artist="Paul Simon", size=6, album="Graceland", genre="Alternative", rating=60, duration="4:16", lastPlayed="22/01/2008 5:44 PM"),
            Track(title="That Was Your Mother", artist="Paul Simon", size=4.1, album="Graceland", genre="Alternative", rating=60, duration="2:53", lastPlayed="22/01/2008 5:47 PM"),
            Track(title="All Around The World Or The Myth of Fingerprints", artist="Paul Simon", size=4.6, album="Graceland", genre="Pop", rating=60, duration="3:13", lastPlayed="19/03/2008 5:31 PM"),
            Track(title="Vertigo", artist="U2", size=3.8, album="How To Dismantle An Atomic Bomb", genre="Rock", rating=100, duration="3:15", lastPlayed="18/12/2007 12:11 PM"),
            Track(title="Miracle Drug", artist="U2", size=4.7, album="How To Dismantle An Atomic Bomb", genre="Rock", rating=100, duration="3:59", lastPlayed="19/03/2008 12:04 AM"),
            Track(title="Sometimes You Can't Make It On Your Own", artist="U2", size=6, album="How To Dismantle An Atomic Bomb", genre="Rock", rating=60, duration="5:09", lastPlayed="18/12/2007 12:20 PM"),
            Track(title="Love And Peace Or Else", artist="U2", size=5.6, album="How To Dismantle An Atomic Bomb", genre="Rock", rating=60, duration="4:51", lastPlayed="15/03/2008 4:16 PM"),
            Track(title="City Of Blinding Lights", artist="U2", size=6.7, album="How To Dismantle An Atomic Bomb", genre="Rock", rating=80, duration="5:48", lastPlayed="19/03/2008 12:10 AM"),
            Track(title="All Because Of You", artist="U2", size=4.3, album="How To Dismantle An Atomic Bomb", genre="Rock", rating=60, duration="3:39", lastPlayed="6/11/2007 11:02 PM"),
            Track(title="A Man And A Woman", artist="U2", size=5.3, album="How To Dismantle An Atomic Bomb", genre="Rock", rating=100, duration="4:30", lastPlayed="19/03/2008 12:00 AM"),
            Track(title="Crumbs From Your Table", artist="U2", size=5.9, album="How To Dismantle An Atomic Bomb", genre="Rock", rating=60, duration="5:04", lastPlayed="6/11/2007 11:12 PM"),
            Track(title="One Step Closer", artist="U2", size=4.5, album="How To Dismantle An Atomic Bomb", genre="Rock", rating=40, duration="3:52", lastPlayed="6/11/2007 11:16 PM"),
            Track(title="Original Of The Species", artist="U2", size=5.5, album="How To Dismantle An Atomic Bomb", genre="Rock", rating=40, duration="4:41", lastPlayed="6/11/2007 11:20 PM"),
            Track(title="Yahweh", artist="U2", size=5.1, album="How To Dismantle An Atomic Bomb", genre="Rock", rating=80, duration="4:22", lastPlayed="18/03/2008 11:56 PM"),
            Track(title="Grim Travellers", artist="Bruce Cockburn", size=5.6, album="Humans", genre="Folk", rating=60, duration="4:50", lastPlayed="15/03/2008 4:31 PM"),
            Track(title="Rumours Of Glory", artist="Bruce Cockburn", size=4.3, album="Humans", genre="Folk", rating=80, duration="3:40", lastPlayed="25/03/2008 1:25 AM"),
            Track(title="More Not More", artist="Bruce Cockburn", size=4.4, album="Humans", genre="Folk", rating=60, duration="3:46", lastPlayed="27/10/2007 7:47 PM"),
            Track(title="You Get Bigger As You Go", artist="Bruce Cockburn", size=5.3, album="Humans", genre="Folk", rating=40, duration="4:36", lastPlayed="27/10/2007 7:51 PM"),
            Track(title="What About The Bond", artist="Bruce Cockburn", size=5.7, album="Humans", genre="Folk", rating=40, duration="4:56", lastPlayed="27/10/2007 7:56 PM"),
            Track(title="How I Spent My Fall Vacation", artist="Bruce Cockburn", size=5.9, album="Humans", genre="Folk", rating=60, duration="5:04", lastPlayed="27/10/2007 8:01 PM"),
            Track(title="Guerilla Betrayed", artist="Bruce Cockburn", size=4.6, album="Humans", genre="Folk", rating=60, duration="3:58", lastPlayed="27/10/2007 8:05 PM"),
            Track(title="Tokyo", artist="Bruce Cockburn", size=4.1, album="Humans", genre="Folk", rating=60, duration="3:29", lastPlayed="27/10/2007 8:09 PM"),
            Track(title="Fascist Architecture", artist="Bruce Cockburn", size=3.1, album="Humans", genre="Folk", rating=60, duration="2:38", lastPlayed="15/11/2007 3:40 PM"),
            Track(title="The Rose Above The Sky", artist="Bruce Cockburn", size=7.4, album="Humans", genre="Folk", rating=80, duration="6:22", lastPlayed="25/03/2008 1:22 AM"),
            Track(title="Torn", artist="Natalie Imbruglia", size=5.6, album="Left Of The Middle", genre="Adult Alternative Pop/Rock", rating=100, duration="4:04", lastPlayed="26/03/2008 11:06 PM"),
            Track(title="One More Addiction", artist="Natalie Imbruglia", size=4.9, album="Left Of The Middle", genre="Adult Alternative Pop/Rock", rating=60, duration="3:30", lastPlayed="26/03/2008 11:09 PM"),
            Track(title="Big Mistake", artist="Natalie Imbruglia", size=6.3, album="Left Of The Middle", genre="Adult Alternative Pop/Rock", rating=80, duration="4:32", lastPlayed="26/03/2008 11:14 PM"),
            Track(title="Leave Me Alone", artist="Natalie Imbruglia", size=6, album="Left Of The Middle", genre="Adult Alternative Pop/Rock", rating=60, duration="4:21", lastPlayed="26/03/2008 11:18 PM"),
            Track(title="Wishing I Was There", artist="Natalie Imbruglia", size=5.3, album="Left Of The Middle", genre="Adult Alternative Pop/Rock", rating=80, duration="3:51", lastPlayed="26/03/2008 11:22 PM"),
            Track(title="Smoke", artist="Natalie Imbruglia", size=6.4, album="Left Of The Middle", genre="Adult Alternative Pop/Rock", rating=60, duration="4:37", lastPlayed="26/03/2008 11:26 PM"),
            Track(title="Pigeons And Crumbs", artist="Natalie Imbruglia", size=7.4, album="Left Of The Middle", genre="Adult Alternative Pop/Rock", rating=0, duration="5:20", lastPlayed="26/03/2008 11:32 PM"),
            Track(title="Don't You Think", artist="Natalie Imbruglia", size=5.4, album="Left Of The Middle", genre="Adult Alternative Pop/Rock", rating=80, duration="3:55", lastPlayed="26/03/2008 11:36 PM"),
            Track(title="Impressed", artist="Natalie Imbruglia", size=6.6, album="Left Of The Middle", genre="Adult Alternative Pop/Rock", rating=80, duration="4:48", lastPlayed="26/03/2008 11:40 PM"),
            Track(title="Intuition", artist="Natalie Imbruglia", size=4.7, album="Left Of The Middle", genre="Adult Alternative Pop/Rock", rating=80, duration="3:22", lastPlayed="26/03/2008 11:44 PM"),
            Track(title="City", artist="Natalie Imbruglia", size=6.3, album="Left Of The Middle", genre="Adult Alternative Pop/Rock", rating=0, duration="4:33", lastPlayed="26/03/2008 11:48 PM"),
            Track(title="Left Of The Middle", artist="Natalie Imbruglia", size=5.2, album="Left Of The Middle", genre="Adult Alternative Pop/Rock", rating=60, duration="3:46", lastPlayed="26/03/2008 11:52 PM"),
            Track(title="Life For Rent", artist="Dido", size=4.3, album="Life For Rent", genre="Pop", rating=80, duration="3:43", lastPlayed="20/02/2008 9:35 PM"),
            Track(title="Mary's In India", artist="Dido", size=4.3, album="Life For Rent", genre="Pop", rating=80, duration="3:44", lastPlayed="20/02/2008 9:39 PM"),
            Track(title="See You When You're 40", artist="Dido", size=6.2, album="Life For Rent", genre="Pop", rating=80, duration="5:22", lastPlayed="20/02/2008 9:15 PM"),
            Track(title="Don't Leave Home", artist="Dido", size=4.4, album="Life For Rent", genre="Pop", rating=80, duration="3:49", lastPlayed="20/02/2008 9:31 PM"),
            Track(title="Who Makes You Feel", artist="Dido", size=5.1, album="Life For Rent", genre="Pop", rating=80, duration="4:23", lastPlayed="20/02/2008 9:09 PM"),
            Track(title="Sand In My Shoes", artist="Dido", size=5.8, album="Life For Rent", genre="Pop", rating=80, duration="5:02", lastPlayed="20/02/2008 9:24 PM"),
            Track(title="Do You Have A Little Time", artist="Dido", size=4.6, album="Life For Rent", genre="Pop", rating=80, duration="3:57", lastPlayed="20/02/2008 9:19 PM"),
            Track(title="This Land Is Mine", artist="Dido", size=4.4, album="Life For Rent", genre="Pop", rating=80, duration="3:48", lastPlayed="20/02/2008 9:27 PM"),
            Track(title="See The Sun", artist="Dido", size=12.2, album="Life For Rent", genre="Pop", rating=60, duration="10:36", lastPlayed="22/12/2007 10:28 AM"),
            Track(title="Lifesong", artist="Casting Crowns", size=4.9, album="Lifesong", genre="Religious", rating=80, duration="5:17", lastPlayed="24/03/2008 2:36 PM"),
            Track(title="Praise You in This Storm", artist="Casting Crowns", size=4.6, album="Lifesong", genre="Religious", rating=100, duration="4:59", lastPlayed="24/03/2008 2:17 PM"),
            Track(title="Does Anybody Hear Her", artist="Casting Crowns", size=4.2, album="Lifesong", genre="Religious", rating=60, duration="4:30", lastPlayed="26/12/2007 3:07 PM"),
            Track(title="Stained Glass Masquerade", artist="Casting Crowns", size=3.6, album="Lifesong", genre="Religious", rating=60, duration="3:52", lastPlayed="26/12/2007 3:11 PM"),
            Track(title="Love Them Like Jesus", artist="Casting Crowns", size=4.2, album="Lifesong", genre="Religious", rating=60, duration="4:32", lastPlayed="4/11/2007 3:00 PM"),
            Track(title="Set Me Free", artist="Casting Crowns", size=4.1, album="Lifesong", genre="Religious", rating=80, duration="4:27", lastPlayed="24/03/2008 2:12 PM"),
            Track(title="While You Were Sleeping", artist="Casting Crowns", size=4.5, album="Lifesong", genre="Religious", rating=60, duration="4:55", lastPlayed="1/01/2008 12:39 PM"),
            Track(title="Father, Spirit, Jesus", artist="Casting Crowns", size=4.8, album="Lifesong", genre="Religious", rating=80, duration="5:11", lastPlayed="24/03/2008 2:41 PM"),
            Track(title="In Me", artist="Casting Crowns", size=4.4, album="Lifesong", genre="Religious", rating=80, duration="4:44", lastPlayed="24/03/2008 2:31 PM"),
            Track(title="Prodigal", artist="Casting Crowns", size=5.3, album="Lifesong", genre="Religious", rating=60, duration="5:45", lastPlayed="26/12/2007 3:36 PM"),
            Track(title="And Now My Lifesong Sings", artist="Casting Crowns", size=3.8, album="Lifesong", genre="Religious", rating=60, duration="4:03", lastPlayed="1/01/2008 12:54 PM"),
            Track(title="Afraid", artist="Nelly Furtado", size=3.3, album="Loose", genre="Pop", rating=80, duration="3:35", lastPlayed="15/03/2008 11:41 AM"),
            Track(title="Maneater", artist="Nelly Furtado", size=4.1, album="Loose", genre="Pop", rating=40, duration="4:25", lastPlayed="19/01/2008 12:20 PM"),
            Track(title="Promiscuous", artist="Nelly Furtado", size=3.7, album="Loose", genre="Pop", rating=60, duration="4:02", lastPlayed="21/01/2008 5:01 PM"),
            Track(title="Glow", artist="Nelly Furtado", size=3.7, album="Loose", genre="Pop", rating=80, duration="4:02", lastPlayed="15/03/2008 11:45 AM"),
            Track(title="Showtime", artist="Nelly Furtado", size=3.9, album="Loose", genre="Pop", rating=80, duration="4:15", lastPlayed="15/03/2008 6:37 PM"),
            Track(title="No Hay Igual", artist="Nelly Furtado", size=3.3, album="Loose", genre="Pop", rating=80, duration="3:35", lastPlayed="15/03/2008 11:33 AM"),
            Track(title="Te Busque", artist="Nelly Furtado", size=3.4, album="Loose", genre="Pop", rating=60, duration="3:38", lastPlayed="21/01/2008 5:17 PM"),
            Track(title="Say It Right", artist="Nelly Furtado", size=3.4, album="Loose", genre="Pop", rating=60, duration="3:43", lastPlayed="21/01/2008 5:21 PM"),
            Track(title="Do It", artist="Nelly Furtado", size=3.4, album="Loose", genre="Pop", rating=60, duration="3:41", lastPlayed="21/01/2008 5:24 PM"),
            Track(title="In God's Hands", artist="Nelly Furtado", size=4.5, album="Loose", genre="Pop", rating=40, duration="4:54", lastPlayed="21/01/2008 5:29 PM"),
            Track(title="Wait for You", artist="Nelly Furtado", size=4.8, album="Loose", genre="Pop", rating=40, duration="5:11", lastPlayed="21/01/2008 5:34 PM"),
            Track(title="Somebody to Love", artist="Nelly Furtado", size=4.6, album="Loose", genre="Pop", rating=40, duration="4:56", lastPlayed="21/01/2008 5:39 PM"),
            Track(title="All Good Things (Come to an End)", artist="Nelly Furtado", size=4.8, album="Loose", genre="Pop", rating=40, duration="5:10", lastPlayed="21/01/2008 5:44 PM"),
            Track(title="Someone Somewhere In Summertime", artist="Simple Minds", size=6.5, album="New Gold Gream (81/82/83/84)", genre="Rock", rating=60, duration="4:38", lastPlayed="1/09/2007 9:11 AM"),
            Track(title="Colours Fly And Catherine Wheel", artist="Simple Minds", size=5.4, album="New Gold Gream (81/82/83/84)", genre="Rock", rating=80, duration="3:50", lastPlayed="19/11/2007 8:34 PM"),
            Track(title="Big Sleep", artist="Simple Minds", size=6.9, album="New Gold Gream (81/82/83/84)", genre="Rock", rating=40, duration="4:58", lastPlayed="1/09/2007 9:20 AM"),
            Track(title="Somebody Up There Likes You", artist="Simple Minds", size=7, album="New Gold Gream (81/82/83/84)", genre="Rock", rating=40, duration="5:02", lastPlayed="1/09/2007 9:25 AM"),
            Track(title="New Gold Dream (81-82-83-84)", artist="Simple Minds", size=7.9, album="New Gold Gream (81/82/83/84)", genre="Rock", rating=60, duration="5:39", lastPlayed="1/09/2007 9:30 AM"),
            Track(title="Glittering Prize", artist="Simple Minds", size=6.4, album="New Gold Gream (81/82/83/84)", genre="Rock", rating=60, duration="4:34", lastPlayed="13/08/2007 8:24 PM"),
            Track(title="Hunter And The Hunted", artist="Simple Minds", size=8.3, album="New Gold Gream (81/82/83/84)", genre="Rock", rating=60, duration="5:56", lastPlayed="13/08/2007 8:30 PM"),
            Track(title="King Is White And In The Crowd", artist="Simple Minds", size=9.7, album="New Gold Gream (81/82/83/84)", genre="Rock", rating=20, duration="7:00", lastPlayed="13/08/2007 8:37 PM"),
            Track(title="Promised you a miracle", artist="Simple Minds", size=4.7, album="New Gold Gream (81/82/83/84)", genre="Rock", rating=40, duration="4:01", lastPlayed="10/01/2008 12:01 AM"),
            Track(title="Psycho Killer", artist="Talking Heads", size=5.2, album="Once In A Lifetime", genre="Alternative", rating=40, duration="4:22", lastPlayed="4/02/2008 5:06 PM"),
            Track(title="Take Me To The River", artist="Talking Heads", size=6, album="Once In A Lifetime", genre="Alternative", rating=40, duration="5:03", lastPlayed="4/02/2008 5:11 PM"),
            Track(title="Once In A Lifetime", artist="Talking Heads", size=5.2, album="Once In A Lifetime", genre="Alternative", rating=80, duration="4:20", lastPlayed="4/02/2008 5:15 PM"),
            Track(title="Burning Down The House", artist="Talking Heads", size=4.8, album="Once In A Lifetime", genre="Alternative", rating=100, duration="4:02", lastPlayed="10/02/2008 12:19 AM"),
            Track(title="This Must Be The Place (Naive Melody)", artist="Talking Heads", size=5.9, album="Once In A Lifetime", genre="Alternative", rating=40, duration="4:55", lastPlayed="4/02/2008 5:24 PM"),
            Track(title="Slippery People (Live)", artist="Talking Heads", size=5.1, album="Once In A Lifetime", genre="Alternative", rating=40, duration="4:14", lastPlayed="4/02/2008 5:28 PM"),
            Track(title="Life During Wartime (Live)", artist="Talking Heads", size=6, album="Once In A Lifetime", genre="Alternative", rating=40, duration="5:05", lastPlayed="4/02/2008 5:34 PM"),
            Track(title="And She Was", artist="Talking Heads", size=4.4, album="Once In A Lifetime", genre="Alternative", rating=60, duration="3:39", lastPlayed="4/02/2008 5:37 PM"),
            Track(title="Road To Nowhere", artist="Talking Heads", size=5.2, album="Once In A Lifetime", genre="Alternative", rating=80, duration="4:20", lastPlayed="4/02/2008 5:42 PM"),
            Track(title="Wild Wild Life", artist="Talking Heads", size=4.4, album="Once In A Lifetime", genre="Alternative", rating=60, duration="3:42", lastPlayed="4/02/2008 5:45 PM"),
            Track(title="Blind", artist="Talking Heads", size=5.9, album="Once In A Lifetime", genre="Alternative", rating=40, duration="5:00", lastPlayed="4/02/2008 5:50 PM"),
            Track(title="(Nothing But) Flowers", artist="Talking Heads", size=6.6, album="Once In A Lifetime", genre="Alternative", rating=40, duration="5:35", lastPlayed="4/02/2008 5:56 PM"),
            Track(title="Sax And Violins", artist="Talking Heads", size=6.3, album="Once In A Lifetime", genre="Alternative", rating=60, duration="5:18", lastPlayed="4/02/2008 6:01 PM"),
            Track(title="Lifetime Piling Up", artist="Talking Heads", size=4.6, album="Once In A Lifetime", genre="Alternative", rating=80, duration="3:52", lastPlayed="4/02/2008 6:05 PM"),
            Track(title="Honey", artist="Moby", size=4.8, album="Play", genre="Alternative", rating=80, duration="3:29", lastPlayed="22/02/2008 10:59 AM"),
            Track(title="Find My Baby", artist="Moby", size=5.5, album="Play", genre="Alternative", rating=60, duration="3:59", lastPlayed="22/02/2008 11:03 AM"),
            Track(title="Porcelain", artist="Moby", size=5.6, album="Play", genre="Alternative", rating=40, duration="4:01", lastPlayed="14/03/2008 11:34 PM"),
            Track(title="Why Does My Heart Feel So Bad?", artist="Moby", size=6.1, album="Play", genre="Alternative", rating=80, duration="4:25", lastPlayed="22/02/2008 11:12 AM"),
            Track(title="Southside", artist="Moby", size=5.3, album="Play", genre="Alternative", rating=80, duration="3:50", lastPlayed="3/03/2008 4:20 PM"),
            Track(title="Rushing", artist="Moby", size=4.2, album="Play", genre="Instrumental", rating=60, duration="3:00", lastPlayed="14/03/2008 11:30 PM"),
            Track(title="Bodyrock", artist="Moby", size=5, album="Play", genre="Alternative", rating=100, duration="3:36", lastPlayed="14/03/2008 11:27 PM"),
            Track(title="Natural Blues", artist="Moby", size=5.9, album="Play", genre="Alternative", rating=40, duration="4:14", lastPlayed="22/02/2008 11:27 AM"),
            Track(title="Machete", artist="Moby", size=5.1, album="Play", genre="Alternative", rating=20, duration="3:38", lastPlayed="22/02/2008 11:30 AM"),
            Track(title="7", artist="Moby", size=1.5, album="Play", genre="Instrumental", rating=20, duration="1:02", lastPlayed="14/03/2008 11:23 PM"),
            Track(title="Run On", artist="Moby", size=5.2, album="Play", genre="Alternative", rating=40, duration="3:45", lastPlayed="19/03/2008 5:52 PM"),
            Track(title="Down Slow", artist="Moby", size=2.2, album="Play", genre="Instrumental", rating=40, duration="1:35", lastPlayed="14/03/2008 11:22 PM"),
            Track(title="If Things Were Perfect", artist="Moby", size=6, album="Play", genre="Alternative", rating=60, duration="4:19", lastPlayed="22/02/2008 11:40 AM"),
            Track(title="Everloving", artist="Moby", size=4.8, album="Play", genre="Alternative", rating=40, duration="3:26", lastPlayed="27/12/2007 11:06 AM"),
            Track(title="Inside", artist="Moby", size=6.7, album="Play", genre="Alternative", rating=60, duration="4:49", lastPlayed="27/12/2007 11:10 AM"),
            Track(title="Guitar Flute And String", artist="Moby", size=3, album="Play", genre="Alternative", rating=60, duration="2:09", lastPlayed="27/12/2007 11:12 AM"),
            Track(title="The Sky Is Broken", artist="Moby", size=6, album="Play", genre="Alternative", rating=60, duration="4:19", lastPlayed="4/11/2007 2:22 PM"),
            Track(title="My Weakness", artist="Moby", size=5, album="Play", genre="Alternative", rating=40, duration="3:38", lastPlayed="4/11/2007 2:26 PM"),
            Track(title="Discotheque", artist="U2", size=6.1, album="Pop", genre="Rock", rating=100, duration="5:19", lastPlayed="3/03/2008 4:16 PM"),
            Track(title="Do You Feel Loved", artist="U2", size=5.9, album="Pop", genre="Rock", rating=60, duration="5:07", lastPlayed="7/02/2008 11:04 AM"),
            Track(title="Mofo", artist="U2", size=6.7, album="Pop", genre="Rock", rating=60, duration="5:49", lastPlayed="7/02/2008 11:10 AM"),
            Track(title="If God Will Send His Angels", artist="U2", size=6.2, album="Pop", genre="Rock", rating=80, duration="5:23", lastPlayed="7/02/2008 11:16 AM"),
            Track(title="Staring At The Sun", artist="U2", size=5.3, album="Pop", genre="Rock", rating=80, duration="4:37", lastPlayed="19/03/2008 12:15 AM"),
            Track(title="Last Night On Earth", artist="U2", size=5.5, album="Pop", genre="Rock", rating=100, duration="4:46", lastPlayed="7/02/2008 11:25 AM"),
            Track(title="Gone", artist="U2", size=5.1, album="Pop", genre="Rock", rating=60, duration="4:27", lastPlayed="7/02/2008 11:29 AM"),
            Track(title="Miami", artist="U2", size=5.6, album="Pop", genre="Rock", rating=40, duration="4:53", lastPlayed="14/11/2007 5:53 PM"),
            Track(title="The Playboy Mansion", artist="U2", size=5.4, album="Pop", genre="Rock", rating=40, duration="4:41", lastPlayed="14/11/2007 5:58 PM"),
            Track(title="If You Wear That Velvet Dress", artist="U2", size=6.1, album="Pop", genre="Rock", rating=60, duration="5:15", lastPlayed="14/11/2007 6:03 PM"),
            Track(title="Please", artist="U2", size=5.8, album="Pop", genre="Rock", rating=40, duration="5:03", lastPlayed="6/02/2008 11:28 PM"),
            Track(title="Wake Up Dead Man", artist="U2", size=5.6, album="Pop", genre="Rock", rating=40, duration="4:53", lastPlayed="6/02/2008 11:20 PM"),
            Track(title="The River", artist="Live", size=4.1, album="Songs From Black Mountain", genre="Gospel & Religious", rating=80, duration="2:58", lastPlayed="24/03/2008 10:55 PM"),
            Track(title="Mystery", artist="Live", size=5.2, album="Songs From Black Mountain", genre="Gospel & Religious", rating=80, duration="3:45", lastPlayed="24/03/2008 10:59 PM"),
            Track(title="Get Ready", artist="Live", size=4.9, album="Songs From Black Mountain", genre="Gospel & Religious", rating=60, duration="3:32", lastPlayed="23/03/2008 1:02 PM"),
            Track(title="Show", artist="Live", size=4.7, album="Songs From Black Mountain", genre="Gospel & Religious", rating=80, duration="3:25", lastPlayed="24/03/2008 11:03 PM"),
            Track(title="Wings", artist="Live", size=5.3, album="Songs From Black Mountain", genre="Gospel & Religious", rating=0, duration="3:51", lastPlayed="23/03/2008 1:09 PM"),
            Track(title="Sofia", artist="Live", size=5.4, album="Songs From Black Mountain", genre="Gospel & Religious", rating=0, duration="3:54", lastPlayed="23/03/2008 1:13 PM"),
            Track(title="Love Shines (A Song For My Daughters About God)", artist="Live", size=4.6, album="Songs From Black Mountain", genre="Gospel & Religious", rating=0, duration="3:21", lastPlayed="23/03/2008 1:16 PM"),
            Track(title="Where Do We Go From Here", artist="Live", size=5.2, album="Songs From Black Mountain", genre="Gospel & Religious", rating=0, duration="3:46", lastPlayed="23/03/2008 1:20 PM"),
            Track(title="Home", artist="Live", size=4.7, album="Songs From Black Mountain", genre="Gospel & Religious", rating=0, duration="3:23", lastPlayed="23/03/2008 1:23 PM"),
            Track(title="All I Need", artist="Live", size=4.5, album="Songs From Black Mountain", genre="Gospel & Religious", rating=0, duration="3:14", lastPlayed="23/03/2008 1:26 PM"),
            Track(title="You Are Not Alone", artist="Live", size=5.2, album="Songs From Black Mountain", genre="Gospel & Religious", rating=0, duration="3:44", lastPlayed="19/02/2008 12:05 PM"),
            Track(title="Night Of Nights", artist="Live", size=4.9, album="Songs From Black Mountain", genre="Gospel & Religious", rating=0, duration="3:33", lastPlayed="19/02/2008 12:08 PM"),
            Track(title="All For Believing", artist="Missy Higgins", size=4.2, album="The Sound Of White", genre="Folk", rating=80, duration="3:30", lastPlayed="30/01/2008 4:21 PM"),
            Track(title="Don't Ever", artist="Missy Higgins", size=3.5, album="The Sound Of White", genre="Folk", rating=40, duration="2:54", lastPlayed="30/01/2008 4:24 PM"),
            Track(title="Scar", artist="Missy Higgins", size=4.3, album="The Sound Of White", genre="Folk", rating=80, duration="3:36", lastPlayed="30/01/2008 4:28 PM"),
            Track(title="Ten Days", artist="Missy Higgins", size=4.5, album="The Sound Of White", genre="Folk", rating=80, duration="3:48", lastPlayed="30/01/2008 5:10 PM"),
            Track(title="Nightminds", artist="Missy Higgins", size=4, album="The Sound Of White", genre="Folk", rating=60, duration="3:21", lastPlayed="30/01/2008 5:13 PM"),
            Track(title="Casualty", artist="Missy Higgins", size=5, album="The Sound Of White", genre="Folk", rating=60, duration="4:15", lastPlayed="15/03/2008 4:43 PM"),
            Track(title="Any Day Now", artist="Missy Higgins", size=4.6, album="The Sound Of White", genre="Folk", rating=60, duration="3:54", lastPlayed="30/12/2007 2:35 PM"),
            Track(title="Katie", artist="Missy Higgins", size=4.3, album="The Sound Of White", genre="Folk", rating=60, duration="3:37", lastPlayed="30/12/2007 2:38 PM"),
            Track(title="The River", artist="Missy Higgins", size=5.3, album="The Sound Of White", genre="Folk", rating=60, duration="4:30", lastPlayed="16/11/2007 9:06 PM"),
            Track(title="The Special Two", artist="Missy Higgins", size=5.2, album="The Sound Of White", genre="Folk", rating=100, duration="4:25", lastPlayed="30/01/2008 5:18 PM"),
            Track(title="This Is How It Goes", artist="Missy Higgins", size=4.2, album="The Sound Of White", genre="Folk", rating=60, duration="3:35", lastPlayed="30/01/2008 5:22 PM"),
            Track(title="The Sound Of White", artist="Missy Higgins", size=5.7, album="The Sound Of White", genre="Folk", rating=80, duration="4:52", lastPlayed="30/01/2008 5:27 PM"),
            Track(title="They Weren't There", artist="Missy Higgins", size=4.9, album="The Sound Of White", genre="Folk", rating=60, duration="4:08", lastPlayed="30/12/2007 2:56 PM"),
        ]
        fe = wx.FontEnumerator()
        fe.EnumerateFacenames()
        fontFaces = fe.GetFacenames()
        colours = [wx.Colour(*x[1:]) for x in colourdb.getColourInfoList()]
        for x in self.dataObjects:
            # Convert the 'duration' and 'lastPlayed' attributes into a time() and a datetime() respectively
            minsAndSeconds = x.duration.split(":")
            x.duration = time(minute=int(minsAndSeconds[0]), second=int(minsAndSeconds[1]))
            x.lastPlayed = datetime(*(strptime(x.lastPlayed, "%d/%m/%Y %I:%M %p")[0:6]))

            # Give some tracks a dark colour that can be used for the text
            x.trackColour = random.choice(colours)
            if sum(x.trackColour.Get()) > 255*3/2:
                x.trackColour = None

            # Give some tracks a funny font
            if random.random() > 0.75:
                x.font = wx.FFont(11, wx.DEFAULT, face=random.choice(fontFaces))
            else:
                x.font = None

    def InitUI(self):
        musicImage = self.olvSimple.AddImages(self._imagePath("music16.png"), self._imagePath("music32.png"))
        groupImage = self.olvSimple.AddImages(self._imagePath("Group16.bmp"), self._imagePath("Group32.bmp"))
        userImage = self.olvSimple.AddImages(self._imagePath("User16.bmp"), self._imagePath("User32.bmp"))
        starImage = self.olvSimple.AddImages(self._imagePath("star16.png"), self._imagePath("star32.png"))
        okImage = self.olvSimple.AddImages(self._imagePath("tick16.png"), self._imagePath("tick32.png"))
        dudImage = self.olvSimple.AddImages(self._imagePath("no16.png"), self._imagePath("no32.png"))
        undecidedImage = self.olvSimple.AddImages(self._imagePath("question16.png"))

        # Register handlers for editing cells that are showing a colour
        def makeColourEditor(olv, rowIndex, subItemIndex):
            odcb = OwnerDrawnEditor.ColourComboBox(olv)
            # OwnerDrawnComboxBoxes don't generate EVT_CHAR so look for keydown instead
            odcb.Bind(wx.EVT_KEY_DOWN, olv.HandleChar)
            return odcb

        CellEditorRegistry().RegisterCreatorFunction(type(wx.BLACK), makeColourEditor)

        #----------------------------------------------------------------------
        # Init Simple list

        simpleColumns = [
            ColumnDefn("Title", "left", 160, valueGetter="title", imageGetter=musicImage, minimumWidth=40, maximumWidth=200),
            ColumnDefn("Artist", valueGetter="artist", minimumWidth=40, maximumWidth=200, autoCompleteCellEditor=True),
            ColumnDefn("Album", valueGetter="album", maximumWidth=250, isSpaceFilling=True, autoCompleteCellEditor=True),
            ColumnDefn("Genre", "left", 60, valueGetter="genre", autoCompleteComboBoxCellEditor=True),
            ColumnDefn("Size", "right", valueGetter="size"),
            ColumnDefn("Rating", "center", valueGetter="rating"),
            ColumnDefn("Duration", "center", valueGetter="duration", stringConverter="%S seconds and %M minutes"),
            ColumnDefn("Date Played", valueGetter="dateLastPlayed", stringConverter="%x", valueSetter="SetDateLastPlayed"),
            ColumnDefn("Last Played", valueGetter="lastPlayed", stringConverter="%x %X", maximumWidth=100),
            ColumnDefn("Colour", "left", 60, valueGetter="trackColour", minimumWidth=40),
            ]

        self.olvSimple.SetColumns(simpleColumns)
        self.olvSimple.SetObjects(self.dataObjects)
        self.olvSimple.cellEditMode = ObjectListView.CELLEDIT_DOUBLECLICK

        #----------------------------------------------------------------------
        # Init Complex list

        soloArtists = ["Nelly Furtado", "Missy Higgins", "Moby", "Natalie Imbruglia", "Dido", "Paul Simon", "Bruce Cockburn"]
        def artistImageGetter(track):
            if track.artist in soloArtists:
                return userImage
            else:
                return groupImage

        def ratingImageGetter(track):
            if track.rating > 80:
                return starImage
            elif track.rating > 20:
                return okImage
            elif track.rating > 0:
                return dudImage
            else:
                return undecidedImage

        def rowFormatter(listItem, track):
            if track.trackColour:
                listItem.SetTextColour(track.trackColour)
            if track.font:
                listItem.SetFont(track.font)
            else:
                diff = datetime.now() - track.lastPlayed
                if diff.days > 90:
                    listItem.SetFont(wx.FFont(10, wx.DEFAULT, face="Gill Sans"))

        def colourToString(colour):
            return wx.TheColourDatabase.FindName(colour) or str(colour)

        def handleCellEditStarting(evt):
            if evt.rowIndex == 1:
                evt.Veto()
            if evt.subItemIndex in (1, 2):
                evt.cellBounds[3] += 2 # Make the textbox a bit taller

        def handleCellEditFinishing(evt):
            pass

        def makeFontEditor(olv, rowIndex, subItemIndex):
            odcb = OwnerDrawnEditor.FontFaceComboBox(olv)
            # OwnerDrawnComboxBoxes don't generate EVT_CHAR so look for keydown instead
            odcb.Bind(wx.EVT_KEY_DOWN, olv.HandleChar)
            return odcb

        self.olvComplex.SetImageList(self.olvSimple.GetImageList(wx.IMAGE_LIST_SMALL), wx.IMAGE_LIST_SMALL)

        columns = [
            ColumnDefn("Title", "left", 200, valueGetter="title", imageGetter=musicImage, minimumWidth=40, maximumWidth=200),
            ColumnDefn("Artist", "left", 150, valueGetter="artist", imageGetter=artistImageGetter, minimumWidth=40, maximumWidth=200, autoCompleteCellEditor=True),
            ColumnDefn("Album", "left", 150, valueGetter="album", maximumWidth=250, isSpaceFilling=True, autoCompleteCellEditor=True),
            ColumnDefn("Genre", "left", 100, valueGetter="genre", autoCompleteComboBoxCellEditor=True),
            ColumnDefn("Size", "right", 50, valueGetter="size"),
            ColumnDefn("Rating", "center", 50, valueGetter="rating", imageGetter=ratingImageGetter),
            ColumnDefn("Duration", "center", 150, valueGetter="duration", stringConverter="%S seconds and %M minutes"),
            ColumnDefn("Date Played", "left", 150, valueGetter="dateLastPlayed", stringConverter="%x", valueSetter="SetDateLastPlayed"),
            ColumnDefn("Last Played", "left", 150, valueGetter="lastPlayed", stringConverter="%x %X", maximumWidth=150),
            ColumnDefn("Colour", "left", 60, valueGetter="trackColour", stringConverter=colourToString, minimumWidth=60),
            ColumnDefn("Font", "left", 60, valueGetter="font", valueSetter="SetFontFace", cellEditorCreator=makeFontEditor,
                       stringConverter=lambda x: x.GetFaceName() if x is not None else ""),
        ]

        self.olvComplex.Bind(EVT_CELL_EDIT_STARTING, handleCellEditStarting)
        self.olvComplex.Bind(EVT_CELL_EDIT_FINISHING, handleCellEditFinishing)

        self.olvComplex.rowFormatter = rowFormatter
        self.olvComplex.SetColumns(columns)
        self.olvComplex.SetObjects(self.dataObjects)
        self.olvComplex.cellEditMode = ObjectListView.CELLEDIT_DOUBLECLICK

        #----------------------------------------------------------------------
        # Init Virtual list

        self.olvVirtual.SetImageList(self.olvSimple.GetImageList(wx.IMAGE_LIST_SMALL), wx.IMAGE_LIST_SMALL)

        def objectGetter(index):
            return self.dataObjects[index % len(self.dataObjects)]

        self.olvVirtual.Bind(EVT_CELL_EDIT_STARTING, handleCellEditStarting)
        self.olvVirtual.Bind(EVT_CELL_EDIT_FINISHING, handleCellEditFinishing)

        self.olvVirtual.rowFormatter = rowFormatter
        self.olvVirtual.SetColumns(columns)
        self.olvVirtual.SetObjectGetter(objectGetter)
        self.olvVirtual.SetItemCount(10000000)
        self.olvVirtual.cellEditMode = ObjectListView.CELLEDIT_DOUBLECLICK

        #----------------------------------------------------------------------
        # Init Fast list

        self.olvFast.SetImageList(self.olvSimple.GetImageList(wx.IMAGE_LIST_SMALL), wx.IMAGE_LIST_SMALL)

        objects = self._MakeAtLeast([], 10000)

        self.olvFast.Bind(EVT_CELL_EDIT_STARTING, handleCellEditStarting)
        self.olvFast.Bind(EVT_CELL_EDIT_FINISHING, handleCellEditFinishing)

        self.olvFast.SetEmptyListMsg("This is a long message that shows only when the list is empty")
        self.olvFast.SetEmptyListMsgFont(wx.FFont(24, wx.DEFAULT, face="Tekton"))

        self.olvFast.rowFormatter = rowFormatter
        self.olvFast.SetColumns(columns)
        self.olvFast.SetObjects(objects)
        self.olvFast.cellEditMode = ObjectListView.CELLEDIT_DOUBLECLICK

    def _imagePath(self, imageFile):
        return os.path.join(os.getcwd(), "images", imageFile)

    def _IncrementString(self, s):
        if s[-2:].isdigit():
            s = s[:-3]
        return s + (" %02d" % self.counter)

    def _MakeAtLeast(self, objects, atLeast):
        "Extend the given collection of objects with copy of our model objects until there is at least to given number of model objects"
        while len(objects) < atLeast:
            self.counter += 1
            for x in self.dataObjects:
                y = x.clone()
                y.title = self._IncrementString(y.title)
                y.album = self._IncrementString(y.album)
                objects.append(y)

        return objects

    #----------------------------------------------------------------------
    # Event handlers - Implementation

    def DoRepopulate(self, olv):
        self._timeCall(olv.RepopulateList, "Populating %d items took %%0.2f milliseconds" % olv.GetItemCount())

    def DoAdd1000(self, olv):
        self.counter += 1
        def func():
            objects = self._MakeAtLeast(olv.objects, len(olv.objects)+1000)
            olv.SetObjects(objects, True)
        self._timeCall(func, "Adding 1000 and repopulating %d items took %%0.2f milliseconds" % olv.GetItemCount())

    def DoAdd1000Virtual(self, olv):
        self.counter += 1
        def func():
            olv.SetItemCount(olv.GetItemCount() + 1000)
        self._timeCall(func, "Virtually adding 1000 and repopulating %d items took %%0.2f milliseconds" % olv.GetItemCount())

    def DoSelectAll(self, olv):
        self._timeCall(olv.SelectAll, "Selecting all %d items took %%0.2f milliseconds" % olv.GetItemCount())

    def DoSelectU2(self, olv):
        def func():
            objs = [x for x in olv.objects if x.artist == "U2"]
            olv.SelectObjects(objs)
        self._timeCall(func, "Selecting Ownens items out of %d items took %%0.2f milliseconds" % olv.GetItemCount())

    def DoSelectNone(self, olv):
        self._timeCall(olv.DeselectAll, "Deselecting all %d items took %%0.2f milliseconds" % olv.GetItemCount())

    def DoUpdateSelected(self, olv):
        def func():
            for x in olv.GetSelectedObjects():
                x.lastPlayed = datetime.now()
            olv.RefreshObjects(olv.GetSelectedObjects())
        self._timeCall(func, "Updating the selected items out of %d items took %%0.2f milliseconds" % olv.GetItemCount())

    def _timeCall(self, func, msg):
        t = clock()

        simpleTiming = True
        if simpleTiming:
            func()
        else:
            self.frame_1_statusbar.SetStatusText("Starting profile", 0)

            import __builtin__, cProfile, pstats
            __builtin__.__dict__["myFunctionToProfile"] = func
            cProfile.run("myFunctionToProfile()", "app.prof")

            stats = pstats.Stats("app.prof")
            stats.strip_dirs()
            stats.sort_stats('time', 'calls')
            print msg % ((clock()-t)*1000)
            stats.print_stats(30)
            os.remove("app.prof")

        statusMsg = msg % ((clock()-t)*1000)
        self.frame_1_statusbar.SetStatusText(statusMsg, 0)

    #----------------------------------------------------------------------
    # Event handlers - Simple tab

    def OnListViewDetails(self, event): # wxGlade: MyFrame.<event_handler>
        self.olvSimple.SetSingleStyle(wx.LC_REPORT)

    def OnListViewList(self, event): # wxGlade: MyFrame.<event_handler>
        self.olvSimple.SetSingleStyle(wx.LC_LIST)

    def OnListViewSmallIcon(self, event): # wxGlade: MyFrame.<event_handler>
        self.olvSimple.SetSingleStyle(wx.LC_SMALL_ICON)

    def OnListViewLargeIcon(self, event): # wxGlade: MyFrame.<event_handler>
        self.olvSimple.SetSingleStyle(wx.LC_ICON)

    def OnRepopulate(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoRepopulate(self.olvSimple)

    def OnAdd1000(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoAdd1000(self.olvSimple)

    def OnUpdateSelected(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoUpdateSelected(self.olvSimple)

    def OnSelectAll(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoSelectAll(self.olvSimple)

    def OnSelectU2s(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoSelectU2(self.olvSimple)

    def OnSelectNone(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoSelectNone(self.olvSimple)

    #----------------------------------------------------------------------
    # Event handlers - Virtual tab

    def OnRepopulateVirtual(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoRepopulate(self.olvVirtual)

    def OnAdd1000Virtual(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoAdd1000Virtual(self.olvVirtual)

    def OnUpdateSelectedVirtual(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoUpdateSelected(self.olvVirtual)

    def OnSelectAllVirtual(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoSelectAll(self.olvVirtual)

    def OnSelectNoneVirtual(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoSelectNone(self.olvVirtual)

    #----------------------------------------------------------------------
    # Event handlers - Fast tab

    def OnRepopulateFast(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoRepopulate(self.olvFast)

    def OnAdd1000Fast(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoAdd1000(self.olvFast)

    def OnUpdateSelectedFast(self, event): # wxGlade: MyFrame.<event_handler>
        #self.DoUpdateSelected(self.olvFast)
        #self.olvFast.DeleteAllItems()
        self.olvFast.SetObjects(None)

    def OnSelectAllFast(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoSelectAll(self.olvFast)

    def OnSelectU2sFast(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoSelectU2(self.olvFast)

    def OnSelectNoneFast(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoSelectNone(self.olvFast)

    def OnColDragging(self, event): # wxGlade: MyFrame.<event_handler>
        print "Event handler `OnColDragging' not implemented"
        event.Skip()

    #----------------------------------------------------------------------
    # Event handlers - Complex tab

    def OnRepopulateComplex(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoRepopulate(self.olvComplex)

    def OnAdd1000Complex(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoAdd1000(self.olvComplex)

    def OnUpdateSelectedComplex(self, event): # wxGlade: MyFrame.<event_handler>
        #self.DoUpdateSelected(self.olvComplex)
        self.olvComplex.DeleteAllItems()

    def OnSelectAllComplex(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoSelectAll(self.olvComplex)

    def OnSelectU2sComplex(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoSelectU2(self.olvComplex)

    def OnSelectNoneComplex(self, event): # wxGlade: MyFrame.<event_handler>
        self.DoSelectNone(self.olvComplex)

    def OnListViewDetailsComplex(self, event): # wxGlade: MyFrame.<event_handler>
        self.olvComplex.SetSingleStyle(wx.LC_REPORT)

    def OnListViewListComplex(self, event): # wxGlade: MyFrame.<event_handler>
        self.olvComplex.SetSingleStyle(wx.LC_LIST)

    def OnListViewSmallIconComplex(self, event): # wxGlade: MyFrame.<event_handler>
        self.olvComplex.SetSingleStyle(wx.LC_SMALL_ICON)

    def OnListViewLargeIconComplex(self, event): # wxGlade: MyFrame.<event_handler>
        self.olvComplex.SetSingleStyle(wx.LC_ICON)

    def OnClearListSimple(self, event): # wxGlade: MyFrame.<event_handler>
        self.olvSimple.SetObjects(None)

    def OnClearListComplex(self, event): # wxGlade: MyFrame.<event_handler>
        self.olvComplex.SetObjects(None)

    def OnClearListVirtual(self, event): # wxGlade: MyFrame.<event_handler>
        self.olvVirtual.SetItemCount(0)

    def OnClearListFast(self, event): # wxGlade: MyFrame.<event_handler>
        self.olvFast.SetObjects(None)

# end of class MyFrame


if __name__ == "__main__":
    app = wx.PySimpleApp(0)
    wx.InitAllImageHandlers()
    frame_1 = MyFrame(None, -1, "")
    app.SetTopWindow(frame_1)
    frame_1.Show()
    app.MainLoop()
