"""
A visual comparison of three variously created popup windows.

Ray Pasco 
2010-09-10
pascor(at)verizon(dot)net

This code is released under the "Official Beerware License" (OBL). 
If you like this program and you happen to run into me someday 
then offer to by me a beer. 
Use it at your own risk.
"""

import sys
import wx

import win32com.client
from ctypes          import c_int, WINFUNCTYPE, windll
from ctypes.wintypes import HWND, LPCSTR, UINT
    
#------------------------------------------------------------------------------

def WxValueEntryPopup() :
    
    dlg = wx.TextEntryDialog( None, 'Enter value', 'WxValueEntryPopup', 'ZZZ' )
    
    val = ''
    if dlg.ShowModal() == wx.ID_OK:
        val = dlg.GetValue()
    dlg.Destroy()
    
    print '\n----  The Text Entry Value  [ %s ]\n' % val
    
#end def

#------------------------------------------------------------------------------

def AxWshShellPopup() :
    
    axWshShell = win32com.client.Dispatch( 'WScript.Shell' )
    axWshShell.Popup( u'axWshShell.Popup' )
    
#end def
    
#------------------------------------------------------------------------------

def MessageBoxA() :
    
    prototype = WINFUNCTYPE( c_int, HWND, LPCSTR, LPCSTR, UINT )    # ???
        
    # Tuple formation:
    #              ???  Param       Param Value  
    paramFlags = ( (1, 'hwnd',      0),              \
                   (1, 'text',      'MessageBoxA'),  \
                   (1, 'caption',   None),           \
                   (1, 'flags',     0),            )
    
    print '\n----  paramFlags : ', paramFlags
    
    MessageBox = prototype( ('MessageBoxA', windll.user32), paramFlags )
    
    MessageBox( text='My Momma ?', caption='Yo Momma !' )

#end def

#==============================================================================

app = wx.PySimpleApp()

WxValueEntryPopup()
AxWshShellPopup()
MessageBoxA()
