"""
Sample program for the "MswGuiDllCallsForWxPython" wiki page.

Ray Pasco 
2010-09-10
pascor(at)verizon(dot)net

This code is released under the "Official Beerware License" (OBL). 
If you like this program and you happen to run into me someday 
then offer to by me a beer. 
Use it at your own risk.
"""

import sys
import time

import MswDllFuncs as mdf      # A collection of MSW DLL call functions
import HexCap as hc            # A "pretty print" function def used much in the demo

#-----

# Find the MSW window handle id (hwnd) of this Python app shell.
pythonAppShellTitle = mdf.GetConsoleTitle()
print '\n----  This Python App Shell Title : \n[ % s ]' % (pythonAppShellTitle)

pyAppShellHwnd = mdf.FindTopWindow( wantedText=pythonAppShellTitle, warnMultiple=True )

pythonAppShellClassName = mdf.GetClassNameA( pyAppShellHwnd )
print '----  This Python Shell Class Name : [ % s ]' % (pythonAppShellClassName)

# Find the pid of this Python app shell.
pythonAppShellPid = mdf.GetPidFromHwnd( pyAppShellHwnd )

print '    hwnd, pid = ', hc.HexCap( pyAppShellHwnd, digits=8 ),  \
                          hc.HexCap( pythonAppShellPid, digits=4 )

# Find this shell's position on the screen.
pythonAppShellSizeOrig = mdf.GetWinSize( pyAppShellHwnd )
pythonAppShellPosnOrig = mdf.GetWinPosition( pyAppShellHwnd )
print '\n----  Python Command Shell :'

sizeBeforeMoving = mdf.GetWinSize( pyAppShellHwnd )
sizeOrigX, sizeOrigY = pythonAppShellSizeOrig
posnBeforeMoving = mdf.GetWinPosition( pyAppShellHwnd )
print '\n    Size and Position Before Moving   = (%3d %3d)  (%3d %3d)' %  \
    (sizeBeforeMoving[0], sizeBeforeMoving[1], posnBeforeMoving[0], posnBeforeMoving[1])

#-----

# Reposition this shell window
mdf.SlideWindowFx( pyAppShellHwnd, 0, 0 )   # Arbitrary destination position.
#time.sleep( 2 )   # pause for "the effect".
#
#mdf.HideWin( pyAppShellHwnd )
time.sleep( 0.5 )
mdf.ShowWin( pyAppShellHwnd )

sizeAfterMoving = mdf.GetWinSize( pyAppShellHwnd )
posnAfterMoving = mdf.GetWinPosition( pyAppShellHwnd )
print '\n    Size and Position After Moving    = (%3d %3d)  (%3d %3d)' %  \
    (sizeAfterMoving[0], sizeAfterMoving[0], posnAfterMoving[0], posnAfterMoving[0])

#-----

# Command shells can't be widened, only narrowed.
mdf.GrowWinSize( pyAppShellHwnd, sizeOrigX-200, sizeOrigY+200 )

sizeAfterGrowing = mdf.GetWinSize( pyAppShellHwnd )
posnAfterGrowing = mdf.GetWinPosition( pyAppShellHwnd )
print '\n    Size and Position After Growing   = (%3d %3d)  (%3d %3d)' %  \
    (sizeAfterGrowing[0], sizeAfterGrowing[0], posnAfterGrowing[0], posnAfterGrowing[0])

time.sleep( 1.0 )

#-----

# Restore the shell window size
mdf.GrowWinSize( pyAppShellHwnd, sizeOrigX, sizeOrigY )

sizeAfterShrinking = mdf.GetWinSize( pyAppShellHwnd )
posnAfterShrinking = mdf.GetWinPosition( pyAppShellHwnd )
print '\n    Size and Position After Shrinking = (%3d %3d)  (%3d %3d)' %  \
    (sizeAfterShrinking[0], sizeAfterShrinking[1], posnAfterShrinking[0], posnAfterShrinking[1])

time.sleep( 1.0 )

#--------

# Restore the shell window position.
origX, origY = pythonAppShellPosnOrig
mdf.SlideWindowFx( pyAppShellHwnd, origX, origY )
time.sleep( 0.5 )

mdf.HideWin( pyAppShellHwnd );    
time.sleep( 0.5 )
mdf.ShowWin( pyAppShellHwnd )

sizeAfterReturning = mdf.GetWinSize( pyAppShellHwnd )
posnAfterReturning = mdf.GetWinPosition( pyAppShellHwnd )
print '\n    Size and Position After Returning = (%3d %3d)  (%3d %3d)' %  \
    (sizeAfterReturning[0], sizeAfterReturning[1], posnAfterReturning[0], posnAfterReturning[1])

sys.exit(1)

