
"""
An unabashed MSW-specific way to create processes manipulate their top-level
frames which is not built into Python ot wxPython.

Requires both the PYWIN32 and WMI packages:
    
    PYWIN32   http://sourceforge.net/projects/pywin32/files/
    WMI       http://pypi.python.org/pypi/WMI/

Ray Pasco 
2010-10-26  v1.0.1
2010-09-10  v1.0.0
pascor(at)verizon(dot)net

-------------------------------------------------

NOTES:

1) [ %SYSTEMDRIVE%\AUTOEXEC.BAT ] is called when creating the command shell window
   to ensure    that all user account environment variables get defined for use 
   in the command shell.    This is reasonable, but this should be customized 
   for your particular requirements.
   
2) Many calls to time.sleep() are made, though this is not usually acceptable 
   in a wx app. However, this was a "quick and dirty" solution for providing
   delays after window changes. wx.Timer()'s should be used in some fashon 
   to produce reliable delays. I can't find a non-blocking delay function for wx.

POSSIBLE ENHANCEMENTS:

1) Environment variable value "macro" substitution for the command shell creation, 
   perhaps used in the form [ #envname# ] or [ $envname$ ]. I think it's best 
   to avoid use of the ampersand [ & ]character since it is a control character 
   in both MSW caommand lines and wxPython strings.

-------------------------------------------------

This code is released under the "Official Beerware License" (OBL). 
If you like this program and you happen to run into me someday 
then offer to by me a beer. 
Use it at your own risk.

-------------------------------------------------

CREDITS:

Mark Hammond for his "Python for Windows Extensions" wrapper package @
http://python.net/crew/skippy/win32/Downloads.html

Tim Golden for his "WinShell" wrapper package @
http://timgolden.me.uk/python/winshell.html

DOCUMENTATION

Look for MSW, C, C#, VBS and other MSW DLL function calls examples
to figure out how to implement other DLL calls in Python. 

Googling:

    python {MSW_DLL_function_name}
    
will list hits on how to call that function using Pywin32 or Winshell.
"""

import os, sys
import time
import wx

#------------------------------------------------------------------------------

# What packages are installed ?
import platform
print
print 'Windows  ', platform.win32_ver()[1]
print 'Python   ', sys.version
print 'Wx       ', wx.VERSION_STRING
print

#------------------------------------------------------------------------------

# All the various calls to the various DLL's used in this demo.
import MswDllFuncs as mdf

# My utilities
import CustomMessagePopup   as cmp
import HexCap               as hc

#------------------------------------------------------------------------------

# Global list of this demo's window info tuples: (pid, hwnd, title)
shellWin_list = []

#------------------------------------------------------------------------------

def CreateTwoProcessWindows() :
    """ This demo creates 2 processes: A command sell and NotePad.
    
        [ %SYSTEMDRIVE%\ ]
            typically [ C:\ ]
        
        [ %HOMEDRIVE%\Users\%USERNAME%\Desktop\ ]
            typically [ C:\Users\%USERNAME%\Desktop\ ]
    """
    #print '\n----  CreateTwoProcessWindows()'
    
    posX = 20       # Position of the next process window to be created.
    posY = 100

    #-------  NOTEPAD Process Window  -----------------

    pid, success = mdf.CreateExecProc( 'NotePad.exe' )
    time.sleep( 1.0 )       # Give the OS time before trying to find its hwnd.
    hwnd = mdf.GetHwndFromPid( pid )

    notepadClassName = mdf.GetClassNameA( hwnd )
    print '\n----  Notepad Class Name : [ % s ]' % (notepadClassName)
    
    title = 'My NotePad in ' + os.getcwd() + ' at ' + time.asctime( time.localtime() )
    mdf.SetFrameTitle( hwnd, title )
    
    size = mdf.GetWinSize( hwnd )
    posn = mdf.GetWinPosition( hwnd )
    
    print '----  Notepad Original Size, Position : ', size, posn
    
    # Save the notepad process info for when it will be killed later.  
    shellWin_list.append( (pid, hwnd, title, size, posn) )    
    
    #----
    
    # Slide the window to a more appropriate position without resizing it.
    mdf.SlideWindowFx( hwnd, posX, posY )

    # The NotePad window needs to redrawn because the menuBar is not completely drawn.
    # More testing is needed to see if other app windows unexpectedly screw up 
    # in the same way.
    mdf.SetForegroundWindow( hwnd )
        
    #--------  DESKTOP SHELL WINDOW  ------
    
    # Create a shell window and know its pid from the process creation call.
    
    pid, failed = mdf.CreateCmdShell()      # WinShell call
    if not failed :
        pass
        #print '\n----  DESKTOP CMD Shell:   pid, success=', hc.HexCap( pid ), success
    else :
        print '\n####  FAILURE Creating DeskTop Shell Window:  success= ', success
        sys.exit( 1 )
    #end if
    time.sleep( 1.0 )       # Give the OS time before trying to find its hwnd.
    
    hwnd = mdf.GetHwndFromPid( pid )
    title = '%SYSEMDRIVE\Users\%USER%\Desktop' + os.sep + ' at ' + time.asctime( time.localtime() )
    mdf.SetFrameTitle( hwnd, title )
    
    cmdShellClassName = mdf.GetClassNameA( hwnd )
    print '\n----  Command Shell Class Name : [ % s ]' % (cmdShellClassName)
    
    size = mdf.GetWinSize( hwnd )
    posn = mdf.GetWinPosition( hwnd )
    print '----  Command Shell Original Size, Position : ', size, posn
        
    # Save the process info for when it will be killed later.  
    shellWin_list.append( (pid, hwnd, title, size, posn) )
    
    #----
    
    # Reposition the shell window
    posX += 100
    posY += 75
    bRepaint = True
    
    mdf.SlideWindowFx( hwnd, posX, posY )
    mdf.BlinkWindowHwnd( hwnd, duration=1.0, anteDelay=0.5, postDelay=1.0 )
    mdf.SetForegroundWindow( hwnd )
    
    #----------------------------------
    
    # List and tile all the processes.
    print '\n----  List of the New Processes :'
    for aWin in shellWin_list :
        pid, hwnd, title, sizeOrig, posnOrig = aWin
        print
        print '----  Window:    hwnd, pid = ', hc.HexCap( hwnd ), hc.HexCap( pid )
        print '[ %s ]' % (title)
        print '                 Original Size, Position : ', sizeOrig, posnOrig
        
        mdf.SetForegroundWindow( hwnd )
    #end for
    
    mdf.SetForegroundWindow( pythonAppShellHwnd )
        
#end CreateTwoProcessWindows def
    
#------------------------------------------------------------------------------

class MainFrame( wx.Frame ) :
    """ This Frame's appearance is as simple as it gets. 
    There is no use for a Panel. """
    
    def __init__( self ) :
        
        """
        Configure all aspects of the look and position of the app main Frame
        excliding the interior controls:
        """
        # [ wx.SYSTEM_MENU ] must be included when specifying any decorators.
        # This window can't be moved in any manner.
        frameStyle_noResize = wx.SYSTEM_MENU | wx.CLOSE_BOX | wx.CAPTION
        
        wx.Frame.__init__( self, parent=None, id=-1, 
                           title='Command Window Creation Test', 
                           style=frameStyle_noResize )
                           
        self.ClientSize = (250, 175)    # Frame sizes are usually very unimportant !
        self.BackgroundColour = (250, 250, 225)     # pastel yellow. This is NOT a function call !
        
        # Set this app Frame near, but not at the top of the screen.
        #
        # "There is more than one to skin a cat":
        screenSize  = wx.DisplaySize()                                  # method #1
        screenSizeY = wx.SystemSettings.GetMetric( wx.SYS_SCREEN_Y )    # method #2
        screenSizeY = mdf.GetScreenSizeY()                              # method #3; uses metrics, too.
        
        screenSizeX, screenSizeY = wx.DisplaySize()                     # the wx way
        
        # Position this Frame so it will be out of the way of the other process windows
        # that will be created.
        self.Center()
        self.Position = (400, screenSizeY/20)
        
        frmSizeX, frmSizeY = self.Size
        posnX = screenSizeX - (frmSizeX * 3 / 2)
        posnY = screenSizeY/20
        self.Position = (posnX, posnY)
        
        """
        The first control created in a Frame gets auto-expanded to the Frame's client size.
        This is almost never wanted and there is no need for an auto-expanded Panel.
        So, create a "dummy" initial control, but hide it. All future controls (including
        panels) will be "size-able" and "position-able", as all controls should be.
        """
        # Many other controls could be used for this purpose.
        sacrificial_control = wx.Panel( self, -1 ).Hide()  
        
        #------------------------------
        
        """
        Configure all aspects of the look and position this Frame's controls:
        A single button.
        """
        self.btnLabel = 'Create Two New Command Shells'
        self.newShell_btn = wx.Button( self, -1, self.btnLabel )
        self.Bind( wx.EVT_BUTTON, self.OnBtn_Create2Processes, self.newShell_btn )
        
        self.Bind( wx.EVT_SIZE, self.OnReSize )
        
        # Enable right-clicking on the Frame Client area background to quit this app.
        self.Bind( wx.EVT_RIGHT_UP, self.OnClose )
        # Enable right-clicking on even the button, too !
        self.newShell_btn.Bind( wx.EVT_RIGHT_UP, self.OnClose )
        # Handle the Menue:Close and X-Close decorator.
        self.Bind( wx.EVT_CLOSE, self.OnClose )
        
        #-----
        
        popupMsg = 'Right-Click Anywhere in the App Window\n'     +  \
                   'To Close This App, Even on the Button.\n\n'   +  \
                   'This is Also True for This Popup Window.'
        
        self.popupMsgQuitInfo_win =  \
            cmp.CustomMessagePopup( self, msg=popupMsg,
                                    label='Have a Nice Day', 
                                    title='An Important Message From Your Sponsor' )
        self.popupMsgQuitInfo_win.Show()
        
        # Place the popup to the left of this Frame.
        # Reposition the popup now that it is .Show()n
        #
        selfPosnX, selfPosnY = self.Position
        popSizeX, popSizeY = self.popupMsgQuitInfo_win.Size
        popPosnX, popPosnY = self.popupMsgQuitInfo_win.Position
        
        #print '\n----  selfPosnX, selfPosnY   ', selfPosnX, selfPosnY
        #print '\n----  popSizeX, popSizeY     ', popSizeX,  popSizeY
        #print '\n----  popPosnX, popPosnY     ', popPosnX,  popPosnY
        
        positionFudgeFactorX = 9        # ??? This should NOT be needed ?
        popNewPosnX = selfPosnX - popSizeX - positionFudgeFactorX - 20
        popNewPosn = (popNewPosnX, selfPosnY)
        
        # Check if calculated popup position is legal, then move to it.
        if (popNewPosnX >= 0)  and  (popPosnY >= 0) :       # a legal coordinate ?
            
            #print '\n----  New popNewPosn ', popNewPosn
            self.popupMsgQuitInfo_win.Position = popNewPosn     # move to that position
            
        else :
            print '\n####  Invalid Calculated popNewPosn  ', popNewPosn
        #end 
        popNewPosn = (popNewPosnX, popPosnY)
        
        #print '\n----  self.Position              ', self.Position
        #print '\n----  self.newShell_btn.Position ', self.newShell_btn.Position
        
        #-------------------------------
        
        self.Show()
        
    #end __init__ for MainFrame class
    
    #------------------------
    
    def OnBtn_Create2Processes( self, event ) :
        """
        Create 2 process windows. They have their own pids.
        As many pairs of processes may be created as desired.
        All the shells will be killed when this app is Close()ed.
        Any process can be killed using it's pid, not just the ones created here.
        
        """
        CreateTwoProcessWindows()     # create and position them with extra dynamic effects.
        
    #end OnBtn_Create2Processes def
    
    #------------------------
    
    def OnReSize( self, event ) :
        """ Center the button in the Frame's client area.
        Gets called only once when the frame is instantiated. 
        """
        self.newShell_btn.Center()
        event.Skip()        # There may be other events queued (?)
        
    #end def
        
    #------------------------
    
    def OnClose( self, event ) :
        
        print '\n----  END OF PHASE 2'
        print '\n' + '-'*70
        print '\n----  START OF PHASE 3 :    Kill All New Process.'
        
        numProcessesCreated = len( shellWin_list )
        print '\n>>>>  OnClose():    Number of Created Processes to Kill: ', numProcessesCreated
        
        for idx in xrange( numProcessesCreated ) :
            
            pid, hwnd, title, sizeOrig, posnOrig = shellWin_list[ idx ]
            print '\n----  OnClose():    Attempting to Close Process #%d :' % (idx+1)
            print   ' '*20 + 'hwnd, pid = ', hc.HexCap( hwnd, digits=8 ), hc.HexCap( pid, digits=4 )
            print '[ %s ]' % (title)
            
            print '\n----  Process Original Size, Position : ', sizeOrig, posnOrig
            
            # Shrink the window
            mdf.ShrinkWindow( hwnd )
            
            # Momentarily resize and reposition the window to its original.
            # Notepad, like many apps, store their size on exiting.
            sizeOrigX, sizeOrigY = sizeOrig
            mdf.SetWinSize(    hwnd, sizeOrigX, sizeOrigY )
            posnOrigX, posnOrigY = posnOrig
            mdf.SlideWindowFx( hwnd, posnOrigX, posnOrigY )
            
            # Kill the app.
            mdf.KillProcPid( pid )          # no status is returned
            
            time.sleep( 1.50 )      # Pause between killing the next app.
            
        #end for
        
        # Return the Python shell window to its starting posn.
        mdf.SlideWindowFx( pythonAppShellHwnd, *pythonAppShellPosnOrig )
        
        # Bring it to the top in case there happen to be other app windows shown.
        mdf.SetForegroundWindow( pythonAppShellHwnd )
        
        event.Skip()    # ? Does Destroy() also do this as a matter of course ?
        self.Destroy()
        
        print '\n----  END OF PHASE 3'
        
    #end OnClose def
    
#end MainFrame class

#==============================================================================

if __name__ == '__main__' :
    
    # This is interesting.
    print '\n----  CreateTwoProcessWindows():    mdf.GetSelfProcessName():\n  [ %s ]\n'  \
        % (mdf.GetSelfProcessName())
    
    print '-'*70
    print '\n----  START OF PHASE 1 :  Display The Python Process and Create the wx GUI.'
    
    # Find the MSW window handle of this Python app shell.
    pythonAppShellTitle = mdf.GetConsoleTitle()
    print '\n----  This Python App Shell Title : \n[ % s ]' % (pythonAppShellTitle)
    
    pythonAppShellHwnd = mdf.FindTopWindow( wantedText=pythonAppShellTitle, warnMultiple=True )
    
    pythonAppShellClassName = mdf.GetClassNameA( pythonAppShellHwnd )
    print '\n----  This Python App Shell Class Name : [ % s ]' % (pythonAppShellClassName)
    
    # Find the pid of this Python app shell.
    pythonAppShellPid = mdf.GetPidFromHwnd( pythonAppShellHwnd )
    
    print '\n----  pythonAppShell : \n   hwnd, pid = ',  \
        hc.HexCap( pythonAppShellHwnd, digits=8 ), hc.HexCap( pythonAppShellPid, digits=4 )
    
    
    # Find this shell's position on the screen. It wil be moved then restored OnExit().
    pythonAppShellPosnOrig = mdf.GetWinPosition( pythonAppShellHwnd )
    pythonAppShellSizeOrig = mdf.GetWinSize( pythonAppShellHwnd )
    
    # Position the Python shell window so it will be out of the way when it is put on top.
    mdf.SlideWindowFx( pythonAppShellHwnd, 220, 250 )
    
    #----
    
    app = wx.PySimpleApp( redirect=False )
    appFrame = MainFrame()
    print '\n----  END OF PHASE 1'
    print '\n' + '-'*70
    print '\n----  START OF PHASE 2 :    Waiting for Buuton Clicks or App Exit'
    app.MainLoop()
    
    #-----------------------------
    
    print '\n' + '-'*70
    print '\n----  START OF PHASE 4 :    Restore Python Shell Window Position.'
    
    mdf.ShrinkWindow( pythonAppShellHwnd )
    mdf.SetWinSize( pythonAppShellHwnd, *pythonAppShellSizeOrig )
    
    print '\n----  END OF PHASE 4 :    Exit to OS Control.'
    print '\n' + '-'*70
    
#end if