"""
Create a "PrettyPrint" hex value string.

Ray Pasco 
2010-09-11
pascor(at)verizon(dot)net

This code is released under the "Official Beerware License" (OBL). 
If you like this program and you happen to run into me someday 
then offer to by me a beer. 
Use it at your own risk.
"""

import sys

#------------------------------------------------------------------------------

def HexCap( val, digits=2 ) :
    """ Create a "PrettyPrint" hex value string. Dosen't handle negative integers.
    
    The original Python one is always in lower case and truncates leading zeros,
    which is harder to read. 
    
    The [ digits ] arg will pad the hex digit part of the string with zeros 
    if [ digits > len( hex(val)-2 ) ].
    """
    
    retVal= val
    if (type( val ) == type( 123 )) :
        
        # First upper-case the hex digits, only.
        retVal =  hex( val )[ 2: ].upper()    # upper case hex digits, only.
        
        # Prepend zeros if it's feasible.
        numZerosToPrepend = digits - len( retVal )
        if numZerosToPrepend > 0 :
            for idx in xrange( numZerosToPrepend ) :    retVal = '0' + retVal
            
        retVal = '0x' + retVal      # opposite case because hex digits are in upper case.
        
    else :
        print
        print '####  HexCap():   Input Value is NOT AN INTEGER TYPE.'
        print '          type( val ), val :  ', type( val ), val
        print
        sys.exit(1)
    #end if
    
    return retVal
    
#end def

