"""
Requires both the PYWIN32 and WMI packages:
    
    PYWIN32   http://sourceforge.net/projects/pywin32/files/
    WMI       http://pypi.python.org/pypi/WMI/

Ray Pasco 
2010-09-07
pascor(at)verizon(dot)net

This code is released under the "Official Beerware License" (OBL). 
If you like this program and you happen to run into me someday 
then offer to by me a beer. 
Use it at your own risk.

"""
import wx

#------------------------------------------------------------------------------

class CustomMessagePopup( wx.Dialog ) :
    """ A handy, simple custom message popup. 
    
    This is not literally a "dialog" since no user data is input and returned.
    This class is not specifically designed to be a template for subclassing, 
    though more controls could be added and DlgLayout() be overridden by
    subclassing.
    """

    def __init__( self, myParent, 
                  msg='Default Dialog Message.', 
                  pos=(0, 0), 
                  size=(300, 120), 
                  label='Default Button Label', 
                  title='Default Popup Frame Title' ) :
        
        self.myParent = myParent
        self.pos  = pos
        self.size = (280, 130)
        
        dlgStyle = wx.DEFAULT_DIALOG_STYLE      # What is the point ?
        
        wx.Dialog.__init__( self, parent=myParent, 
                            title='Default Message Popup Title')
        self.BackgroundColour = (220, 220, 240)
        
        self.msg_stText = wx.StaticText( self, label=msg )

        self.OK_btn = wx.Button( self, label=label )
        self.Bind( wx.EVT_BUTTON, self.OnExit, self.OK_btn )
        
        self.SetTitle( title )
        
        #-----
        
        self.DlgLayout()
        
        #-----
        
        # Enable right-clicking on the Frame Client area background to quit this app.
        self.Bind( wx.EVT_RIGHT_UP, self.OnExit )
        # Enable right-clicking on the button, too !
        self.OK_btn.Bind( wx.EVT_RIGHT_UP, self.OnExit )
        
    #end __init__
    
    #-----------------------------------
    
    def OnExit( self, event ) :
        
        self.Destroy()      # No data is available to the caller.
        
    #end def
    
    #-----------------------------------
    
    def DlgLayout( self ) :
        
        dlg_vertSizer = wx.BoxSizer( wx.VERTICAL )
        dlg_vertSizer.AddSpacer( 15 )
        dlg_vertSizer.Add( self.msg_stText, flag=wx.CENTER )
        dlg_vertSizer.AddSpacer( 15 )
        dlg_vertSizer.Add( self.OK_btn, flag=wx.CENTER )
        dlg_vertSizer.AddSpacer( 15 )
        
        self.SetSizer( dlg_vertSizer )
        
        self.SetClientSize( self.size )    # No one cares about the actual frame size !
        
        self.Position = self.pos
        
#end CustomMessagePopup class
