#----------------------------------------------------------------------------
# Name:         test_presenters.py
# Purpose:      Unittesting for the AlbumPresenter
#
# Author:       Peter Damoc (peter at sigmacore.net)
#               
# Created:      January 2006
# Version:      0.2
# Licence:      wxWindows license

import unittest
import mock_objects
import models
import presenters

class TestAlbumPresenter(unittest.TestCase):
    '''
    A sample test case to demonstrate the use of mock objects
    '''
    
    def setUp(self):
        self.someAlbums = models.someAlbums
    def getMVP(self):
        view = mock_objects.MockAlbumWindow();
        model = [models.Album(*data) for data in self.someAlbums]
        interactor = mock_objects.MockAlbumInteractor()
        presenter = presenters.AlbumPresenter(model, view, interactor)
        return model, view, presenter
        
    def testUpdateCausesComposerEnabledToBeRefreshed(self):
        model, view, presenter = self.getMVP()
        assert view.isClassical() is False
        assert view.composerIsEnabled is False
        view.setClassical(True)
        presenter.dataFieldUpdated()
        assert view.composerIsEnabled is True
        
    def testApplySavesDataToModel(self):
        model, view, presenter = self.getMVP()
        newTitle = "Some Other Title"
        view.title = newTitle
        presenter.updateModel()
        assert view.title == newTitle

    def testCancelRestoresDataFromModel(self):
        model, view, presenter = self.getMVP()
        newTitle = "Some Other Title"
        view.title = newTitle
        presenter.loadViewFromModel()
        assert view.title != newTitle
        
    def testOrderToggle(self):
        model, view, presenter = self.getMVP()
        assert presenter.order is 1
        assert view.getOrderLabel() == "Z->A"
        presenter.toggleOrder()
        assert presenter.order is -1
        assert view.getOrderLabel() == "A->Z"
        
    def testAddNewAlbum(self):
        model, view, presenter = self.getMVP()
        albumCount = len(presenter.albums)
        presenter.addNewAlbum()
        assert len(presenter.albums) is albumCount+1
        
if __name__ == '__main__':
    unittest.main()
