#!/usr/bin/env python
#
# wxGameCanvas demo.  Adapted from pyODE demo 2
#
# pyODE module is required: http://i31www.ira.uka.de/~baas/pyode/

from wxPython.wx import *
from wxPython.lib.anchors import LayoutAnchors
from wxGameCanvas import wxGameCanvas, InvokeLater
try:
    import ode
except:
    #Pop up a message dialog pointing to pyODE:
    app = wxPySimpleApp()
    frame = wxFrame(None,-1,"")
    dlg = wxTextEntryDialog(frame, 'The pyODE module is required for this demo, download from:',
                'Required Module Missing', 'http://i31www.ira.uka.de/~baas/pyode/', wxOK)
    dlg.ShowModal()
    dlg.Destroy()
    frame.Destroy()
    sys.exit(0)
    

################################################################################

def coord(x,y, width, height):
    "Convert world coordinates to pixel coordinates. Used for this demo."
    maximum = 3
    mind = min(width, height) / maximum
    return width/2+mind*x, height*0.8-mind*y

class Demo2Canvas(wxGameCanvas):

    def run(self):
        import pygame #here is where your "import pygame" goes instead of the top of the file

        #This code is exactly like the 2nd pyODE demo, except I changed "srf" to self.surface

        # Create a world object
        world = ode.World()
        world.setGravity((0,-9.81,0))

        # Create two bodies
        body1 = ode.Body(world)
        M = ode.Mass()
        M.setSphere(2500, 0.05)
        body1.setMass(M)
        body1.setPosition((1,2,0))

        body2 = ode.Body(world)
        M = ode.Mass()
        M.setSphere(2500, 0.05)
        body2.setMass(M)
        body2.setPosition((2,2,0))

        # Connect body1 with the static environment
        j1 = ode.BallJoint(world)
        j1.attach(body1, ode.environment)
        j1.setAnchor( (0,2,0) )

        #uncomment for a motorized double-pendulum
##        j1 = ode.HingeJoint(world)
##        j1.attach(body1, ode.environment)
##        j1.setAnchor( (0,2,0) )
##        j1.setAxis( (0,0,1) )
##        
##        j1.setParam(ode.ParamVel, 3)
##        j1.setParam(ode.ParamFMax, 22)

        # Connect body2 with body1
        j2 = ode.BallJoint(world)
        j2.attach(body1, body2)
        j2.setAnchor( (1,2,0) )

        # Simulation loop...
        fps = 50
        dt = 1.0/fps
        clk = pygame.time.Clock()
        gaugetimer = 0

        while self.running:
            self.handletasks(True) #handle resizing, pausing, etc.

            # Clear the screen
            self.surface.fill((255,255,255))

            # Draw the two bodies
            x1,y1,z1 = body1.getPosition()
            x2,y2,z2 = body2.getPosition()

            w,h = self.width,self.height
            pygame.draw.circle(self.surface, (55,0,200), coord(x1,y1,w,h), 20, 0)
            pygame.draw.line(self.surface, (55,0,200), coord(0,2,w,h), coord(x1,y1,w,h), 2)
            pygame.draw.circle(self.surface, (55,0,200), coord(x2,y2,w,h), 20, 0)
            pygame.draw.line(self.surface, (55,0,200), coord(x1,y1,w,h), coord(x2,y2,w,h), 2)

            pygame.display.flip()

            #Updates the wxGauges every 5th iteration, and convert ball coordinates to 0-100 range for gauges.
            #Updates to wxPython controls should happen in the main thread, not this drawing thread, so use InvokeLater
            #or wxCallAfter (same thing), or InvokeAndWait if you need to wait for a response from wxPython.
            gaugetimer +=1
            gaugetimer %= 5
            if gaugetimer == 0:
                #wxCallAfter(self._updategauges, int(100.0*(x1+3.0)/6.0), int(100.0*(x2+3.0)/6.0))
                InvokeLater(self._updategauges, int(100.0*(x1+3.0)/6.0), int(100.0*(x2+3.0)/6.0))

            # Next simulation step
            world.step(dt)

            # Try to keep the specified framerate    
            clk.tick(fps)

        #The drawing loop is now over.  The thread will end.


    def _updategauges(self, v1, v2):
        if self.gauge1:
            self.gauge1.SetValue(v1)
        if self.gauge2:
            self.gauge2.SetValue(v2)


class MainWindow(wxFrame):
    """ We simply derive a new class of Frame. """
    def __init__(self,parent,id,title):
        wxFrame.__init__(self,parent,-4, title, size = (500,400),
                                     style=wxDEFAULT_FRAME_STYLE|wxNO_FULL_REPAINT_ON_RESIZE)
        self.panel = wxPanel(size = wxSize(500,400), parent = self, id = -1, style = wxTAB_TRAVERSAL | wxCLIP_CHILDREN, pos = wxPoint(0, 0))
        self.panel.SetAutoLayout(True)
        self.desc = wxStaticText(self.panel, -1, "This example shows the wxGauge and wxGameCanvas, try resizing the window.",
                               wxPoint(45, 15))
        self.ball1txt = wxStaticText(self.panel,-1,"ball 1",wxPoint(80,50), style=wxALIGN_RIGHT|wxST_NO_AUTORESIZE)
        self.g1 = wxGauge(self.panel, -1, 100, wxPoint(110, 50), wxSize(250, 25),
                          wxGA_HORIZONTAL|wxGA_SMOOTH)
        self.g1.SetValue(50)
        self.g1.SetConstraints(LayoutAnchors(self.g1,True,True,True,False))

        self.ball2txt = wxStaticText(self.panel,-1,"ball 2",wxPoint(80,80), style=wxALIGN_RIGHT|wxST_NO_AUTORESIZE)
        self.g2 = wxGauge(self.panel, -1, 100, wxPoint(110, 80), wxSize(250, 25),
                          wxGA_HORIZONTAL|wxGA_SMOOTH)
        self.g2.SetValue(50)
        self.g2.SetConstraints(LayoutAnchors(self.g2,True,True,True,False))

        self.canvas = Demo2Canvas(self.panel, -1, pos=(80,120), size=(320,240))
        self.canvas.gauge1 = self.g1
        self.canvas.gauge2 = self.g2
        self.canvas.SetConstraints(LayoutAnchors(self.canvas,True,True,True,True))

        self.pausebtn = wxButton(self.panel, -1, "Pause", wxPoint(100, 370))
        self.pausebtn.SetConstraints(LayoutAnchors(self.pausebtn,True,False,False,True))
        EVT_BUTTON(self, self.pausebtn.GetId(), self.OnPause)

        self.Show(true)
    def OnPause(self, event):
        if self.pausebtn.GetLabel() == "Pause":
            self.canvas.pause()
            self.pausebtn.SetLabel("UnPause")
        else:
            self.canvas.unpause()
            self.pausebtn.SetLabel("Pause")

app = wxPySimpleApp()
frame = MainWindow(None, -1, "wxGameCanvas Demo")
app.MainLoop()
