# sample_one.py

import wx
import wx.lib.sized_controls as sized_ctrls

# class MyAddressDialog
# class MyApp

#---------------------------------------------------------------------------

class MyAddressDialog(sized_ctrls.SizedDialog):
    def __init__(self, parent, title="Address form"):
        
        style = wx.DEFAULT_DIALOG_STYLE
        
        super(MyAddressDialog, self).__init__(parent,
                                              title=title,
                                              style=style)

        #------------
        
        self.SetIcon(wx.Icon("wxwin.ico"))        

        #------------
        
        # Attributes.
        self._data = dict(name="", street="", zip="",
                          state="", city="")

        #------------
        
        # Layout.
        self.DoLayout()
        self.SetInitialSize((300, -1))

        #------------
        
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        
    #-----------------------------------------------------------------------
        
    def DoLayout(self):
        """
        Setup all the controls.
        """
        
        # Get the SizedPanel from the SizedDialog.
        # This must be used as the parent of the 
        # controls we are going to create next.
        pane = self.GetContentsPane()

        # Set the Layout Type.
        pane.SetSizerType("form")

        # Create the Controls.
        # Each time through the loop creates one row in
        # the dialogs layout ("form" is a two column grid).
        for ctrl in ("name", "street", "city",
                     "state", "zip"):
            lbltext = "%s :" % ctrl.title()
            lbl = wx.StaticText(pane, label=lbltext)
            lbl.SetSizerProps(valign="center")
            txt = wx.TextCtrl(pane, name=ctrl)
            txt.SetSizerProps(expand=True)

        # Add some buttons.
        btnOk = wx.Button(pane,
                          -1,
                          "&Ok")
        self.Bind(wx.EVT_BUTTON, self.OnCloseMe, btnOk)

        btnCancel = wx.Button(pane,
                              -1,
                              "&Cancel")
        self.Bind(wx.EVT_BUTTON, self.OnCloseMe, btnCancel)
        

    def GetAddress(self):
        """
        Get the address data from the dialog.
        """

        # Update data from controls.
        for name in self._data:
            ctrl = self.FindWindowByName(name)
            if ctrl:
                value = ctrl.GetValue()
                self._data[name] = value

        # Create a formatted address label.
        template = "%(name)s\n"
        template += "%(street)s\n"
        template += "%(city)s, %(state)s %(zip)s"
        return template % self._data


    def OnCloseMe(self, event):
        """
        ...
        """

        self.Close(True)

        
    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()
        
#---------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):

        #------------

        frame = MyAddressDialog(None)
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------

def main():
    app = MyApp(redirect=False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
