# Sample_one.py

"""

Author : Jan Bodnar
Website : zetcode.com

"""

import wx

# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, None, -1, title, size=(350, 300))

        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))

        #------------
        
        panel1 = wx.Panel(self, -1)
        
        self.tc1 = wx.TextCtrl(panel1, -1, '', (50,50), (85, -1))
        self.tc2 = wx.TextCtrl(panel1, -1, '', (180,50), (85, -1))

        wx.Button(panel1, 1, '&Copy', (50,200))
        wx.Button(panel1, 2, '&Paste', (180,200))

        #------------
        
        self.Bind(wx.EVT_BUTTON, self.OnCopy, id=1)
        self.Bind(wx.EVT_BUTTON, self.OnPaste, id=2)

        #------------
        
        self.Centre()

    #-----------------------------------------------------------------------
        
    def OnCopy(self, event):
        text = self.tc1.GetValue()
        if wx.TheClipboard.Open():
            wx.TheClipboard.Clear()
            wx.TheClipboard.SetData(wx.TextDataObject(text))
            wx.TheClipboard.Close()


    def OnPaste(self, event):
        if wx.TheClipboard.Open():
            td = wx.TextDataObject()
            success = wx.TheClipboard.GetData(td)
            wx.TheClipboard.Close()
            if not success: return
            text = td.GetText()
            if text: self.tc2.SetValue(text)
            
#---------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):
        frame = MyFrame(None, -1, 'wx.TheClipboard')
        frame.Show(True)
        self.SetTopWindow(frame)
        
        return True

#---------------------------------------------------------------------------

app = MyApp(0)
app.MainLoop()

