# sample_two.py

import wx

try:
    import wx.lib.wxcairo as wxcairo
    import cairo
    haveCairo = True
except ImportError:
    haveCairo = False

# class MyPanel
# class MyFrame
# class MyApp


"""
We want the font to be dynamically sized so the text fits.
Resizing the window should dynamically resize the text, but
this should only happen if the text is not already at a
width or height constraint.
"""

#-------------------------------------------------------------------------------

class MyPanel(wx.Panel):
    def __init__(self, parent):
        wx.Panel.__init__(self, parent, style=wx.BORDER_SIMPLE)

        #------------
        
        self.text = "Hello World !"

        #------------
        
        self.Bind(wx.EVT_SIZE, self.OnResize)        
        self.Bind(wx.EVT_PAINT, self.OnPaint)

    #---------------------------------------------------------------------------
                
    def OnPaint(self, evt):
        """
        ...
        """
        
        # Here we do some magic WX stuff.
        dc = wx.BufferedPaintDC(self)
        width, height = self.GetClientSize()
        cr = wx.lib.wxcairo.ContextFromDC(dc)

        # Here's actual Cairo drawing.
        size = min(width, height)
        cr.scale(size, size)
        cr.set_source_rgb(0, 0, 0) # black
        cr.rectangle(0, 0, width, height)
        cr.fill()

        cr.set_source_rgb(1, 1, 1) # white               
        cr.set_line_width (0.04)
        cr.select_font_face ("Sans", cairo.FONT_SLANT_NORMAL, cairo.FONT_WEIGHT_BOLD)
        cr.set_font_size (0.07)
        cr.move_to (0.5, 0.5)
        cr.show_text (self.text)
        cr.stroke ()

        
    def SetText(self, text):
        """
        ...
        """

        # Change what text is shown.        
        self.text = text
        self.Refresh()


    def OnResize(self, event):
        """
        ...
        """
        
        self.Refresh()
        self.Layout()

#-------------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, title):
        wx.Frame.__init__(self, parent, title=title, size=(320, 250))

        self.SetMinSize((320, 250))
        
        frameicon = wx.Icon("wxwin.ico")
        self.SetIcon(frameicon)

        #------------
        
        self.canvas = MyPanel(self)
        
        self.Show()

#-------------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):

        #------------

        frame = MyFrame(None, "Sample_two")
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#-------------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#-------------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
    
