# sample_three.py

import wx
import math

try:
    import wx.lib.wxcairo as wxcairo
    import cairo
    haveCairo = True
except ImportError:
    haveCairo = False

# class MyPanel
# class MyFrame
# class MyApp

#---------------------------------------------------------------------------
    
class MyPanel(wx.Panel):
    def __init__(self, parent):
        wx.Panel.__init__(self, parent, -1)

        self.Bind(wx.EVT_PAINT, self.OnPaint)

    #-----------------------------------------------------------------------
        
    def OnPaint(self, event):
        """
        ...
        """
        
        if self.IsDoubleBuffered():
            dc = wx.PaintDC(self)
        else:
            dc = wx.BufferedPaintDC(self)
        dc.SetBackground(wx.WHITE_BRUSH)
        dc.Clear()

        self.Render(dc)


    def Render(self, dc):        
        """
        ...
        """
        
        # Now draw something with cairo.
        ctx = wxcairo.ContextFromDC(dc)

        # Drawing a bitmap.  Note that we can easily load a PNG file
        # into a surface, but I wanted to show how to convert from a
        # wx.Bitmap here instead.  This is how to do it using just cairo :
        # img = cairo.ImageSurface.create_from_png(opj('bitmaps/toucan.png'))

        # And this is how to convert a wx.Bitmap to a cairo image
        # surface.  NOTE : currently on Mac there appears to be a
        # problem using conversions of some types of images.  They
        # show up totally transparent when used. The conversion itself
        # appears to be working okay, because converting back to
        # wx.Bitmap or writing the image surface to a file produces
        # the expected result.  The other platforms are okay.
        bmp = wx.Bitmap('fruit.jpg')
        img = wxcairo.ImageSurfaceFromBitmap(bmp)
        
        ctx.set_source_surface(img, 50, 50)
        ctx.paint()

        # This is how to convert an image surface to a wx.Bitmap.
        bmp2 = wxcairo.BitmapFromImageSurface(img)
        dc.DrawBitmap(bmp2, 100, 100)

        img.write_to_png('img_sample_three.png')
                
#---------------------------------------------------------------------------
        
class MyFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, -1, title,
                          style=wx.DEFAULT_FRAME_STYLE)

        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)

        #------------
        
        self.SetIcon(wx.Icon('wxwin.ico'))
        self.SetInitialSize((330, 330))

        #------------
        
        # Attributes
        self.panel= MyPanel(self)

        # Layout
        self.DoLayout()

    #-----------------------------------------------------------------------
        
    def DoLayout(self):
        """
        ...
        """
        
        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.panel, 1, wx.EXPAND)
        self.SetSizer(sizer)

        
    def OnCloseWindow(self, event):
        """
        ...
        """
        
        self.Destroy()

#---------------------------------------------------------------------------
        
class MyApp(wx.App):
    def OnInit(self):

        #------------

        frame = MyFrame(None, -1, "Sample three (image)")
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------
    
def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

    
if __name__ == "__main__" :
    main()

