# sample_one.py

import wx

# class MyGui

#---------------------------------------------------------------------------

class MyGui(wx.Frame):
    """
    Hello World!
    Once stopped, a typical stopwatch reports total time elapsed since
    started. A stopwatch can be paused after started and time won't be
    recorded until it's resumed. A paused stopwatch must be resumed.
    """
    def __init__(self, parent, title):
        # Create a non-resizable frame.
        wx.Frame.__init__(self, parent, title=title,
                          style=wx.DEFAULT_FRAME_STYLE |
                                wx.RESIZE_BORDER)

        self.SetIcon(wx.Icon('wxwin.ico'))
        
        # Simulate a stopwatch with four buttons.
        StartButton = wx.Button(self, -1, "Start")
        PauseButton = wx.Button(self, -1, "Pause")
        ResumButton = wx.Button(self, -1, "Resume")
        Stop_Button = wx.Button(self, -1, "Stop!")

        # A status bar displays current stopwatch mode.
        self.CreateStatusBar()
        self.SetStatusText("Ready.")
        
        # Put more GUI code here for a fancier application.

        # Use a plain sizer for the layout.
        MyBS = wx.BoxSizer(wx.HORIZONTAL)
        # Each non-resizable button has roomy borders (10 pixels).
        MyBS.Add(StartButton, 0, wx.ALL, 10)
        MyBS.Add(PauseButton, 0, wx.ALL, 10)
        MyBS.Add(ResumButton, 0, wx.ALL, 10)
        MyBS.Add(Stop_Button, 0, wx.ALL, 10)
        
        self.SetSizerAndFit(MyBS)

        # Create a stopwatch.
        self.MySW = wx.StopWatch()
        # Set its initial mode to be "stopped".
        self.semaphore = 0

        self.Bind(wx.EVT_BUTTON, self.onStart, StartButton)
        self.Bind(wx.EVT_BUTTON, self.onPause, PauseButton)
        self.Bind(wx.EVT_BUTTON, self.onResum, ResumButton)
        self.Bind(wx.EVT_BUTTON, self.onStop_, Stop_Button)

    #-----------------------------------------------------------------------
        
    def onStart(self, evt):
        if self.semaphore == 0:
            self.MySW.Start()
            self.semaphore = 2 # Set the mode to be "started".
            message = "Go!"
        else:
            message = "Hold. I've been started already."
        self.SetStatusText(message)

    def onPause(self, evt):
        if self.semaphore > 0: # A stopwatch was resumed or started.
            self.MySW.Pause()
            self.semaphore = -1 # Set the mode to be "paused".
            message = "Freeze!"
        else:
            message = "I cannot pause because I'm still."
        self.SetStatusText(message)

    def onResum(self, evt):
        if self.semaphore == -1:
            self.MySW.Resume()
            self.semaphore = 1 # Set the mode to be "resumed".
            message = "I'm ticking again."
        else:
            message = "I cannot resume because I'm not paused."
        self.SetStatusText(message)

    def onStop_(self, evt):
        if self.semaphore > 0:
            message = str(self.MySW.Time()) + " milliseconds recorded."
            self.semaphore = 0
        else:
            message = "I cannot stop because I'm still."
        self.SetStatusText(message)

#---------------------------------------------------------------------------

app = wx.App()
frame = MyGui(None, "Stop watch")
frame.Show()
app.MainLoop()
