# sample_one.py

"""

Author : Zetcode
Created : Apr., 2007
Updated : Nov. 16, 2020 by Ecco

"""

import wx
import wx.lib.plot as plot

# MyPlot
# MyApp

#---------------------------------------------------------------------------

class MyPlot(wx.Dialog):
    def __init__(self, parent, id, title):
        wx.Dialog.__init__(self, parent, id, title, size=(180, 280))

        #------------

        icon = wx.Icon("./icons/wxwin.ico")
        self.SetIcon(icon)

        #------------
        
        self.data = [(1,2), (2,3), (3,5), (4,6), (5,8), (6,8), (10,10)]

        btn1 = wx.Button(self,  1, '&Scatter', (50,50))
        btn2 = wx.Button(self,  2, '&Line', (50,90))
        btn3 = wx.Button(self,  3, '&Bar', (50,130))
        btn4 = wx.Button(self,  4, '&Quit', (50,170))

        #------------

        self.Bind(wx.EVT_BUTTON, self.OnScatter, id=1)
        self.Bind(wx.EVT_BUTTON, self.OnLine, id=2)
        self.Bind(wx.EVT_BUTTON, self.OnBar, id=3)
        self.Bind(wx.EVT_BUTTON, self.OnQuit, id=4)
        self.Bind(wx.EVT_CLOSE, self.OnQuit)

    #-----------------------------------------------------------------------

    def OnScatter(self, event):
        frm = wx.Frame(self, -1, 'Scatter', size=(600, 450))
        icon = wx.Icon("./icons/wxwin.ico")
        frm.SetIcon(icon)
        
        pnl = wx.Panel(frm, -1)        
        pnl.SetBackgroundColour(wx.WHITE)

        #------------
        
        client = plot.PlotCanvas(pnl)
        markers = plot.PolyMarker(self.data, legend='', colour='pink', marker='triangle_down', size=1)
        gc = plot.PlotGraphics([markers], 'Scatter Graph', 'X Axis', 'Y Axis')
        client.Draw(gc, xAxis=(0,15), yAxis=(0,15))

        #------------
        
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        mainSizer.Add(client, 1, wx.EXPAND | wx.ALL, 10)   
        pnl.SetSizer(mainSizer)

        #------------
        
        frm.Show(True)


    def OnLine(self, event):
        frm = wx.Frame(self, -1, 'Line', size=(600, 450))
        icon = wx.Icon("./icons/wxwin.ico")
        frm.SetIcon(icon)
        
        pnl = wx.Panel(frm, -1)        
        pnl.SetBackgroundColour(wx.WHITE)

        #------------
        
        client = plot.PlotCanvas(pnl)
        line = plot.PolyLine(self.data, legend='', colour='pink', width=1)
        gc = plot.PlotGraphics([line], 'Line Graph', 'X Axis', 'Y Axis')
        client.Draw(gc,  xAxis= (0,15), yAxis= (0,15))

        #------------
        
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        mainSizer.Add(client, 1, wx.EXPAND | wx.ALL, 10)   
        pnl.SetSizer(mainSizer)

        #------------
        
        frm.Show(True)


    def OnBar(self, event):
        frm = wx.Frame(self, -1, 'Bar', size=(600, 450))
        icon = wx.Icon("./icons/wxwin.ico")
        frm.SetIcon(icon)
        
        pnl = wx.Panel(frm, -1)        
        pnl.SetBackgroundColour(wx.WHITE)

        #------------
        
        client = plot.PlotCanvas(pnl)
        bar1 = plot.PolyLine([(1, 0), (1,5)], legend='', colour='gray', width=25)
        bar2 = plot.PolyLine([(3, 0), (3,8)], legend='', colour='gray', width=25)
        bar3 = plot.PolyLine([(5, 0), (5,12)], legend='', colour='gray', width=25)
        bar4 = plot.PolyLine([(6, 0), (6,2)], legend='', colour='gray', width=25)
        gc = plot.PlotGraphics([bar1, bar2, bar3, bar4],'Bar Graph', 'X Axis', 'Y Axis')
        client.Draw(gc, xAxis=(0,15), yAxis=(0,15))

        #------------
        
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        mainSizer.Add(client, 1, wx.EXPAND | wx.ALL, 10)   
        pnl.SetSizer(mainSizer)

        #------------
        
        frm.Show(True)


    def OnQuit(self, event):
        self.Destroy()

#---------------------------------------------------------------------------

class MyApp(wx.App):
   def OnInit(self):
         dlg = MyPlot(None, -1, 'Plot.py')
         dlg.Show(True)
         dlg.Centre()

         return True

#---------------------------------------------------------------------------

app = MyApp(0)
app.MainLoop()
