# sample_three.py

"""

Using wxPython for plotting
Author : Vegaseat
Created : 19 apr 2007
Updated : Octo. 19, 2020 by Ecco
Link : https://www.daniweb.com/programming/software-development/code/216913/using-wxpython-for-plotting

"""

import os
import sys
import wx
import wx.lib.plot as plot

# class MyFrame
# class MyApp

#---------------------------------------------------------------------------
     
class MyFrame(wx.Frame):
    def __init__(self):
        style = wx.DEFAULT_FRAME_STYLE ^ (wx.RESIZE_BORDER |
                                          wx.MAXIMIZE_BOX)
        wx.Frame.__init__(self, None, wx.ID_ANY, 
                          title="wx.lib.plot",
                          size=(500, 340),
                          style=style)
        
        #------------

        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------

        # Add a panel so it looks the correct on all platforms.
        self.panel = wx.Panel(self)
        self.panel.SetBackgroundColour("white")

        #------------

        self.button = wx.Button(self.panel, -1, "&Update", (200, 265))
        self.button.Bind(wx.EVT_BUTTON, self.OnRedraw)
        
        self.plotter = plot.PlotCanvas(self.panel)
        self.plotter.SetInitialSize(size=(500, 250))

        #------------

        # List of (x,y) data point tuples.        
        data = [[1, 10], [2, 5], [3, 10], [4, 5]]
        line = plot.PolyLine(data, colour='red', width=1)
     
        gc = plot.PlotGraphics([line], 'Line graph', 'x', 'y')
        self.plotter.Draw(gc)

        #------------
        
        # Simplified init method.
        self.SetProperties()

    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetMinSize((500, 340))
        self.SetBackgroundColour(wx.WHITE)
        
        #------------

        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "wxwin.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)


    def OnRedraw(self, event):
        """
        ...
        """

        self.plotter = plot.PlotCanvas(self.panel)
        self.plotter.SetInitialSize(size=(500, 250))
     
        data2 = [[1, 20], [2, 15], [3, 20], [4, -10]]
        line = plot.PolyLine(data2, colour='red', width=1)
     
        gc = plot.PlotGraphics([line], 'Line graph', 'x', 'y')
        self.plotter.Draw(gc)

#---------------------------------------------------------------------------

class MyApp(wx.App):    
    def OnInit(self):

        #------------

        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]
        
        #------------
        
        frame = MyFrame()
        self.SetTopWindow(frame)
        frame.Show(True)

        return True
    
    #-----------------------------------------------------------------------
    
    def GetInstallDir(self):
        """
        Return the installation directory for my application.
        """

        return self.installDir


    def GetIconsDir(self):
        """
        Return the icons directory for my application.
        """

        icons_dir = os.path.join(self.installDir, "icons")
        return icons_dir
    
#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
