﻿# sample_two.py

"""

Author : Beppe
Created : Sept. 22, 2010
Updated : Octo. 21, 2020 by Ecco
Link : https://www.blog.pythonlibrary.org/2010/09/27/wxpython-pyplot-graphs-with-python/

"""

import os
import sys
import wx
import wx.lib.plot as plot

# class MyPLot
# class MyForm
# class MyApp

#---------------------------------------------------------------------------

class MyPLot(plot.PlotCanvas):
    def __init__(self, parent, id):
        plot.PlotCanvas.__init__(self, parent, -1)

    #-----------------------------------------------------------------------
        
    def PlotGraph(self):
        """
        ...
        """
        
        # self.SetEnableLegend(True)
        # self.SetEnableGrid(True)

        #------------
        
        min_value = [(1, 3), (2, 3), (3, 6), (4, 8), (5, 13), (6, 17),
                     (7, 19), (8, 19), (9, 16), (10, 12), (11, 8), (12, 4)]

        max_value = [(1, 13), (2, 14), (3, 17), (4, 19), (5, 24), (6, 29),
                     (7, 32), (8, 32), (9, 27), (10, 23), (11, 17), (12, 13)]
        
        #------------
        
        min_line = plot.PolyLine(min_value, legend="Lowest", colour='blue', width=1)
        min_marker = plot.PolyMarker(min_value, marker='triangle_down')

        max_line = plot.PolyLine(max_value, legend="Maximum", colour='orange', width=1)
        max_marker = plot.PolyMarker(max_value, marker='triangle')
        
        #------------
        
        gc = plot.PlotGraphics([min_line, min_marker, max_line, max_marker],
                               "Average temperature graph for Rome",
                               'Months',
                               'Temperatures')
       
        self.Draw(gc, xAxis=(0, 13), yAxis=(0, 35))

        
    def _xticks(self, *args):
        """
        Override  _xticks to write months on x axis.
        """

        ticks = plot.PlotCanvas._xticks(self, *args)
        new_ticks = []
        
        month = ("",'Jan','Feb','Mar','Apr','May','Jiu',
                 'Jul','Aug','Sep','Ott','Nov','Dec')

        for k,v in enumerate(month):         
            s = str(month[int(k)]) 
            new_ticks.append((k, s))
                    
        return new_ticks


    def _yticks(self, *args):
        """
        Override  _yticks to write centigrade on y axis.
        """

        ticks = plot.PlotCanvas._yticks(self, *args)
        new_ticks = []

        for tick in ticks:
            t = tick[0]
            s = str(" %s °C" %t)
            new_ticks.append( (t, s) )
              
        return new_ticks

#---------------------------------------------------------------------------

class MyForm(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self, None, -1,
                          title="Axis marks",
                          size=(600, 400))

        #------------

        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------
        
        panel = wx.Panel(self)
        
        self.canvas = MyPLot(panel, -1)

        toggleGrid = wx.CheckBox(panel, label="Show Grid")
        toggleGrid.SetValue(True)
        toggleGrid.Bind(wx.EVT_CHECKBOX, self.OnToggleGrid)
        
        toggleLegend = wx.CheckBox(panel, label="Show Legend")
        toggleLegend.SetValue(False)
        toggleLegend.Bind(wx.EVT_CHECKBOX, self.OnToggleLegend)

        #------------
        
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        checkSizer = wx.BoxSizer(wx.HORIZONTAL)

        mainSizer.Add(self.canvas, 1, wx.EXPAND | wx.ALL, 10)
        checkSizer.Add(toggleGrid, 0, wx.ALL, 5)
        checkSizer.Add(toggleLegend, 0, wx.ALL, 5)

        mainSizer.Add(checkSizer)

        panel.SetSizer(mainSizer)
        self.Layout()

        #------------
        
        # Simplified init method.
        self.SetProperties()
        
    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetMinSize((600, 400))
        self.SetBackgroundColour(wx.WHITE)
        
        #------------

        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "wxwin.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)

        
    def OnToggleGrid(self, event):
        """
        ...
        """
        
        # self.canvas.SetEnableGrid(event.IsChecked())
        self.canvas.enableGrid = event.IsChecked()
        

    def OnToggleLegend(self, event):
        """
        ...
        """
        
        # self.canvas.SetEnableLegend(event.IsChecked())
        self.canvas.enableLegend = event.IsChecked()

        
    def OnOpen(self):
        """
        ...
        """
        
        self.canvas.PlotGraph()

#---------------------------------------------------------------------------

class MyApp(wx.App):    
    def OnInit(self):

        #------------

        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]
        
        #------------
        
        frame = MyForm()
        frame.OnOpen()
        self.SetTopWindow(frame)
        frame.Show(True)

        return True
    
    #-----------------------------------------------------------------------
    
    def GetInstallDir(self):
        """
        Return the installation directory for my application.
        """

        return self.installDir


    def GetIconsDir(self):
        """
        Return the icons directory for my application.
        """

        icons_dir = os.path.join(self.installDir, "icons")
        return icons_dir
    
#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
