# sample_one.py

"""

Using wxPython for plotting
Author : Vegaseat
Created : 19 apr 2007
Updated : Octo. 19, 2020 by Ecco
Link : https://www.daniweb.com/programming/software-development/code/216913/using-wxpython-for-plotting

"""

import os
import sys
import wx
import wx.lib.plot as plot

# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self, None, wx.ID_ANY, 
                          title="wx.lib.plot")
        
        #------------

        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------

        # Add a panel so it looks the correct on all platforms.
        panel = wx.Panel(self)
        panel.SetBackgroundColour("white")

        #------------
              
        self.plotter = plot.PlotCanvas(panel)
        self.plotter.SetInitialSize(size=(410, 340))
        # Enable the zoom feature (drag a box around area of interest).
        # self.plotter.SetEnableZoom(True)

        toggleZoom = wx.CheckBox(panel, label="Show zoom")
        toggleZoom.SetValue(False)
        toggleZoom.Bind(wx.EVT_CHECKBOX, self.OnToggleZoom)
        
        #------------

        # Create some sizers.
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        checkSizer = wx.BoxSizer(wx.HORIZONTAL)

        # Layout the widgets.
        mainSizer.Add(self.plotter, 1, wx.EXPAND | wx.ALL, 10)
        checkSizer.Add(toggleZoom, 0, wx.ALL, 5)
        mainSizer.Add(checkSizer)
        panel.SetSizer(mainSizer)

        #------------
        
        # List of (x,y) data point tuples.
        data = [(1, 2), (2, 3), (3, 5), (4, 6), (5, 8), (6, 8), (12, 10), (13, 4)]

        # Draw points as a line.
        line = plot.PolyLine(data, colour='red', width=1)

        # Also draw markers, default colour is black and size is 2.
        # Other shapes 'circle', 'cross', 'square', 'dot', 'plus'.
        marker = plot.PolyMarker(data, marker='triangle')

        # Set up text, axis and draw.
        gc = plot.PlotGraphics([line, marker], 'Line/Marker graph', 'X axis', 'Y axis')
        self.plotter.Draw(gc, xAxis=(0, 15), yAxis=(0, 15))
        
        #------------
        
        # Simplified init method.
        self.SetProperties()

    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetMinSize((410, 340))
        self.SetBackgroundColour(wx.WHITE)
        
        #------------

        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "wxwin.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)

        
    def OnToggleZoom(self, event):
        """
        Enable the zoom feature (drag a box around area of interest).
        """
        
        # self.canvas.SetEnableZoom(event.IsChecked())
        self.plotter.enableZoom = event.IsChecked()

#---------------------------------------------------------------------------

class MyApp(wx.App):    
    def OnInit(self):

        #------------

        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]
        
        #------------
        
        frame = MyFrame()
        self.SetTopWindow(frame)
        frame.Show(True)

        return True
    
    #-----------------------------------------------------------------------
    
    def GetInstallDir(self):
        """
        Return the installation directory for my application.
        """

        return self.installDir


    def GetIconsDir(self):
        """
        Return the icons directory for my application.
        """

        icons_dir = os.path.join(self.installDir, "icons")
        return icons_dir
    
#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
    
