# sample_one.py

import wx

# class MyFrame
# class MyEditDialog
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, id, title, pos=wx.DefaultPosition,
                 size=wx.DefaultSize, style=wx.DEFAULT_FRAME_STYLE):
        wx.Frame.__init__(self, parent, id, title, pos, size, style)

        #------------

        # Simplified init method.
        self.SetProperties()
        self.MakeMenuBar()
        self.MakeSatusBar()
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()

        #------------
        
        self.CenterOnScreen(wx.BOTH)
        
    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...   
        """

        self.SetIcon(wx.Icon("wxwin.ico"))
        self.SetSize((300, 200))
        self.SetMinSize((300, 200))

        
    def MakeMenuBar(self):
        """
        ...
        """

        # Initialize the menubar.
        menubar = wx.MenuBar()

        #------------
        
        self.menu = wx.Menu()

        self.menu.Append(101, "&Edit text...", "Edit text")
        self.menu.AppendSeparator()
        self.menu.Append(102, "&Close", "Close")

        #------------
        
        menubar.Append(self.menu, "&Menu")

        #------------
        
        self.SetMenuBar(menubar)


    def MakeSatusBar(self):
        """
        ...
        """
        
        # Initialize the statusbar.
        self.CreateStatusBar()
        self.SetStatusText("")


    def CreateCtrls(self):
        """
        ...
        """

        # Initalize some controls.
        self.panel = wx.Panel(self, -1, style=wx.BORDER_SUNKEN)
        self.panel.SetBackgroundColour(wx.WHITE)

        #------------
        
        label = "Click the button and change this text !\n(Or use the Menu...)"
        
        self.text = wx.StaticText(self.panel, -1, label,
                                  style=wx.ALIGN_CENTER |
                                        wx.ST_NO_AUTORESIZE)

        #------------

        self.button = wx.Button(self.panel, -1, "&Click me !")
        
        #------------

        self.st1 = wx.StaticText(self.panel, -1, "")
        self.st2 = wx.StaticText(self.panel, -1, "")
        self.st3 = wx.StaticText(self.panel, -1, "")


    def BindEvents(self):
        """
        ...
        """
        
        # Bind our events.
        self.Bind(wx.EVT_BUTTON, self.OnButton)
        self.Bind(wx.EVT_MENU, self.OnMenu)


    def DoLayout(self):
        """
        ...
        """
        
        # Initialize the sizers and fill them.
        sizer = wx.BoxSizer(wx.HORIZONTAL)
        vsizer = wx.BoxSizer(wx.VERTICAL)

        #------------
        
        sizer.Add(self.st1, 1, wx.EXPAND, 0)
        sizer.Add(self.button, 0, 0, 0)
        sizer.Add(self.st2, 1, wx.EXPAND, 0)

        #------------
        
        vsizer.Add(self.st3, 1, wx.EXPAND, 0)
        vsizer.Add(self.text, 1, wx.EXPAND | wx.ALL, 4)
        vsizer.Add(sizer, 1, wx.EXPAND | wx.ALL, 4)

        #------------
        
        # Finally, tell the panel to use the vsizer for layout.
        self.panel.SetSizerAndFit(vsizer)

        
    def OnMenu(self, event):
        """
        ...
        """
        
        if event.GetId() == 101:
            self.ShowEditDialog()
        else:
            self.OnClose(event)

 
    def OnButton(self, event):
        """
        ...
        """
        
        if event.GetId() == self.button.GetId():
            self.ShowEditDialog()

 
    def OnClose(self, event):
        """
        ...
        """
        
        self.Close()

 
    def ShowEditDialog(self):
        """
        ...
        """
        
        dlg = MyEditDialog(self, -1, "Edit the StaticText..")
        if dlg.ShowModal() == wx.ID_OK:
            self.text.SetLabel(dlg.value)
            self.SetStatusText("Label changed to \"" + dlg.value + "\".")

#---------------------------------------------------------------------------
            
class MyEditDialog(wx.Dialog):
    def __init__(self, parent, id, title, pos=wx.DefaultPosition, 
                 size=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE):
        wx.Dialog.__init__(self, parent, id, title, pos, size, style)

        #------------

        # Simplified init method.
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()

    #-----------------------------------------------------------------------

    def CreateCtrls(self):
        """
        ...
        """

        # Initialize some controls.
        self.text = wx.TextCtrl(self, -1, "")
        
        #------------
        
        self.okay = wx.Button(self, wx.ID_OK)
        self.cancel = wx.Button(self, wx.ID_CANCEL)

        #------------
        
        self.st = wx.StaticText(self, -1, "")
        self.label = wx.StaticText(self, -1, "Enter text :")


    def BindEvents(self):
        """
        ...
        """
        
        # Bind our events.
        self.Bind(wx.EVT_BUTTON, self.OnButton)


    def DoLayout(self):
        """
        ...
        """
        
        # Initialize the sizers and fill them.
        hsizer = wx.BoxSizer(wx.HORIZONTAL)
        sizer = wx.BoxSizer(wx.VERTICAL)
        
        #------------
        
        hsizer.Add(self.st, 1, wx.EXPAND, 0)
        hsizer.Add(self.okay, 0, wx.EXPAND, 0)
        hsizer.Add(self.cancel, 0, wx.EXPAND, 0)
 
        #------------
        
        sizer.Add(self.label, 0, wx.EXPAND | wx.ALL, 4)
        sizer.Add(self.text, 0, wx.EXPAND | wx.ALL, 4)
        sizer.Add(hsizer, 0, wx.EXPAND | wx.ALL, 4)

        #------------

        # Finally, tell the dialog to use the sizer for layout.        
        self.SetSizerAndFit(sizer)

        
    def OnButton(self, event):
        """
        ...
        """
        
        self.value = self.text.GetValue()
        self.EndModal(event.GetId())

#---------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):

        #------------

        frame = MyFrame(None, -1,
                        "wxPython OOP Demo")
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------

def main():
    app = MyApp(redirect=False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
    
