# sample_two.py

import wx

# class MyPanel
# class MyFrame
# class MyApp

#-------------------------------------------------------------------------------

class MyPanel(wx.Panel):
    def __init__(self, parent):
        super().__init__(parent)

        # Define some rows of data
        data = [[1, 'Ford', 'Mustang'],
                [2, 'Toyota', 'Yaris'],
                [3, 'Renault', 'Clio'],
                [4, 'Mercedes', 'Classe C'],
                [5, 'Ferrari', '308'],
                [6, 'Peugeot', '5008'],
                [7, 'Bmw', 'Serie 2'],
                [8, 'Fiat', 'Punto'],
                [9, 'Nissan', 'Juke']]

        #--------------
        
        # Create a listCtrl
        self.list = wx.ListCtrl(self, -1,
                                style = wx.LC_REPORT
                                | wx.LC_HRULES
                                | wx.LC_VRULES
                                | wx.LC_SINGLE_SEL)

        self.list.AppendColumn('ID')
        self.list.AppendColumn('Type')
        self.list.AppendColumn('Model')

        self.list.SetBackgroundColour('#56f452')
        
        #--------------
        
        # Attributes (textcolor, backgroundcolor, font)
        listfont = self.list.GetFont()
        headfont = listfont.MakeBold()
        headAttr = wx.ItemAttr((0,0,0), (240,240,240), headfont)

        # Currently it is implemented only for wxMSW and
        # does nothing in the other ports   
        self.list.SetHeaderAttr(headAttr)

        #--------------
        
        for items in data:
            self.list.Append(items)

        #--------------
            
        layout = wx.BoxSizer(wx.VERTICAL)
        layout.Add(self.list, 1, wx.EXPAND)
        self.SetSizer(layout)
        self.Layout()

#-------------------------------------------------------------------------------
        
class MyFrame(wx.Frame):
    def __init__(self, parent, title=""):
        super().__init__(parent, title=title)

        self.SetIcon(wx.Icon('icons/wxwin.ico'))
        
        self.SetSize((350, 240))

        # Set the panel
        self.panel = MyPanel(self)

#-------------------------------------------------------------------------------
        
class MyApp(wx.App):
    def OnInit(self):

        self.frame = MyFrame(None, title='wx.ListCtrl (SetHeaderAttr)')
        self.frame.Show()
        return True

#-------------------------------------------------------------------------------
    
if __name__ == "__main__":
    app = MyApp(False)
    app.MainLoop()
