# sample_one.py

import wx

# class MyPanel
# class MyFrame
# class MyApp

#-------------------------------------------------------------------------------

class MyPanel(wx.Panel):
    def __init__(self, parent):
        super().__init__(parent)
        
        # Define some rows of data
        rows = [[355, 'Ted', 'Zingall'],
                [1, 'ShipTo', 'Smith'],
                [56, 'Henry', 'Jeff'],
                [213, 'Antoine', 'Buzer'],
                [20, 'Tony', 'Monza'],
                [658, 'Robin', 'Hugh'],
                [67, 'Ted', 'Jefferson'],
                [153, 'Karol', 'Bertin'],
                [6, 'Alice', 'Brice']]

        #--------------
        
        # Create a listCtrl
        self.list = wx.ListCtrl(self, -1,
                                style = wx.LC_REPORT
                                | wx.LC_HRULES
                                | wx.LC_VRULES
                                | wx.LC_SINGLE_SEL)
        
        self.list.AppendColumn('ID')
        self.list.AppendColumn('First')
        self.list.AppendColumn('Surname')

        self.list.SetColumnWidth(0, 70)
        self.list.SetColumnWidth(1, 70)
        self.list.SetColumnWidth(2, 190)

        self.list.SetForegroundColour(wx.BLACK)
        self.list.SetBackgroundColour('#eceade')
        
        #--------------

        # Attributes (textcolor, backgroundcolor, font)
        font_bold = wx.Font(wx.FontInfo(10).Bold())
        head_txt_colr = wx.Colour('BLUE')
        head_bac_colr = wx.Colour('DARK GREY')

        # Currently it is implemented only for wxMSW and
        # does nothing in the other ports       
        self.list.SetHeaderAttr(wx.ItemAttr(head_txt_colr,
                                            head_bac_colr,
                                            font_bold))

        #--------------

        for items in rows:
            self.list.Append(items)

        #--------------
            
        layout = wx.BoxSizer(wx.VERTICAL)
        layout.Add(self.list, 1, wx.EXPAND)
        self.SetSizer(layout)
        self.Layout()

#-------------------------------------------------------------------------------
        
class MyFrame(wx.Frame):
    def __init__(self, parent, title=''):
        super().__init__(parent, title=title)

        self.SetIcon(wx.Icon('icons/wxwin.ico'))

        self.SetSize((350, 240))
        
        # Set the panel
        self.panel = MyPanel(self)

#-------------------------------------------------------------------------------
        
class MyApp(wx.App):
    def OnInit(self):
        
        self.frame = MyFrame(None, title='wx.ListCtrl (SetHeaderAttr)')
        self.frame.Show()
        
        return True

#-------------------------------------------------------------------------------
    
if __name__ == "__main__":
    app = MyApp(False)
    app.MainLoop()
