# sample_one.py

import wx

# class MyFrame
# class MyEvents
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, id, title)

        self.SetIcon(wx.Icon("wxwin.ico"))
        
        #------------
        
        self.functions = MyEvents(self)
        self.panel = wx.Panel(self, -1)

        #------------
        
        # Add two buttons and text control.
        self.text = wx.TextCtrl(self.panel, -1)
        self.text.SetLabel("Hello world !")
        self.text.SetForegroundColour("white")
        self.text.SetBackgroundColour(wx.BLACK)

        self.button1 = wx.Button(self.panel, -1, "Red Colour")
        self.button2 = wx.Button(self.panel, -1, "Green Colour")

        #------------
        
        # Bind events to widgets.
        self.Bind(wx.EVT_BUTTON, self.functions.OnRed, id = self.button1.GetId())
        self.Bind(wx.EVT_BUTTON, self.functions.OnGreen, id = self.button2.GetId())

        #------------
        
        # Add them to sizer [define it first to prevent python
        # automatic detector to find you red handed].
        main = wx.BoxSizer(wx.VERTICAL)
        main.Add(self.text, 1, wx.EXPAND|wx.ALL, 1)

        #------------
        
        # Add buttons in separate sizer.
        sub_main = wx.BoxSizer(wx.HORIZONTAL)
        sub_main.Add(self.button1, 0, wx.EXPAND| wx.ALL, 5)
        sub_main.Add(self.button2, 0, wx.EXPAND| wx.ALL, 5)
        main.Add(sub_main, 0, wx.EXPAND| wx.ALL, 5)

        #------------
        
        # Set sizers to Frame through panel.
        self.panel.SetSizer(main)
        self.panel.Layout()

#---------------------------------------------------------------------------
        
class MyEvents():
    def __init__(self, parent):
        
        self.gui = parent

    #-----------------------------------------------------------------------
        
    def OnRed(self, evt):
        self.gui.text.SetBackgroundColour("Red")

        dlg = wx.MessageDialog(self.gui,
                               "Changed colour ! Click on the window to see !",
                               "Successful",
                               style = wx.ICON_INFORMATION| wx.OK)
        dlg.ShowModal()
        if dlg.ShowModal == wx.ID_OK:
            dlg.Destroy()

                
    def OnGreen(self, evt):
        self.gui.text.SetBackgroundColour(wx.GREEN)

        dlg = wx.MessageDialog(self.gui,
                               "Changed colour ! Click on the window to see !",
                               "Successful",
                               style = wx.ICON_INFORMATION| wx.OK)
        dlg.ShowModal()
        if dlg.ShowModal == wx.ID_OK:
            dlg.Destroy()

#---------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):

        #------------

        frame = MyFrame(None, -1,
                        "Classes and interactions")
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------

def main():
    app = MyApp(redirect=False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
