# sample_two.py

import wx

# class MyFrame
# class MyEventsHandler
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):   
    def __init__(self, parent, id, title):       
        wx.Frame.__init__(self, parent, -1, title=title)

        self.SetIcon(wx.Icon("wxwin.ico"))
        
        #------------
        
        self.frmPanel = wx.Panel(self)
        self.frmPanel.BackgroundColour = (200, 240, 250)    # light blue
        
        #------------
        
        # Add another panel and some buttons
        self.colourPnl = wx.Panel(self.frmPanel)
        self.colourPnl.SetBackgroundColour(wx.Colour('GREY'))

        #------------
        
        self.redBtn = wx.Button(self.frmPanel, label='Red')
        self.greenBtn = wx.Button(self.frmPanel, label='Green')
        self.exitBtn = wx.Button(self.frmPanel, label='Exit')

        #------------
        
        # Add them to sizer.
        colorPnlAndBtn_vSizer = wx.BoxSizer(wx.VERTICAL)
        colorPnlAndBtn_vSizer.Add(self.colourPnl, 1, wx.EXPAND|wx.ALL, 1)
        
        # Add buttons in their own sizer
        btn_hSizer = wx.BoxSizer(wx.HORIZONTAL)
        btn_hSizer.AddStretchSpacer()
        btn_hSizer.Add(self.redBtn, proportion=0, flag=wx.EXPAND|wx.ALL, border=5)
        btn_hSizer.Add(self.greenBtn, proportion=0, flag=wx.EXPAND|wx.ALL, border=5)
        btn_hSizer.Add(self.exitBtn, proportion=0, flag=wx.EXPAND|wx.ALL, border=5)
        btn_hSizer.AddStretchSpacer()
        
        colorPnlAndBtn_vSizer.Add(btn_hSizer, 0, wx.EXPAND| wx.ALL, 5)
        
        # SetSizer both sizers in the most senior control that has sizers in it.
        self.frmPanel.SetSizer(colorPnlAndBtn_vSizer)
        self.frmPanel.Layout()
        
        #------------
        
        # Must call before any event handler is referenced.
        self.eventsHandler = MyEventsHandler(self)

        #------------
        
        # Bind event handlers to all controls that have one.
        self.redBtn.Bind(wx.EVT_BUTTON, self.eventsHandler.OnRedBtn)
        self.greenBtn.Bind(wx.EVT_BUTTON, self.eventsHandler.OnGreenBtn)
        self.exitBtn.Bind(wx.EVT_BUTTON, self.eventsHandler.OnExitBtn)
        
        # Create more convenient ways to close this app.
        # Adding these makes a total of 5 separate ways to exit.
        self.frmPanel.Bind(wx.EVT_LEFT_DCLICK, self.eventsHandler.OnExitBtn)
        self.colourPnl.Bind(wx.EVT_LEFT_DCLICK, self.eventsHandler.OnExitBtn)
        
#---------------------------------------------------------------------------

class MyEventsHandler() :
    def __init__(self, parent):
        
        self.parent = parent

    #-----------------------------------------------------------------------
        
    def OnRedBtn(self, event):
        """
        ...
        """
        
        self.ShowColourAndDialog(wx.RED)


    def OnGreenBtn(self, event):
        """
        ...
        """
        
        self.ShowColourAndDialog(wx.GREEN)

        
    def ShowColourAndDialog(self, pnlColour):
        """
        ...
        """
        
        self.parent.colourPnl.SetBackgroundColour(pnlColour)
        self.parent.colourPnl.Refresh()
        dlg = wx.MessageDialog(self.parent, 'Changed colour !', 'Successful', 
                               style = wx.ICON_INFORMATION| wx.OK)
        dlg.ShowModal()
        dlg.Destroy()


    def OnExitBtn(self, event):
        """
        ...
        """
        
        self.parent.Destroy()

#---------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):

        #------------

        frame = MyFrame(None, -1,
                        "Separate the Gui from the logic")
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------

def main():
    app = MyApp(redirect=False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
    
