# sample_one.py

import wx

# class SingleAppFrame
# class SingleApp

#---------------------------------------------------------------------------

class SingleAppFrame(wx.Frame):
    """
    ...
    """
    def __init__(self, parent, title):
        wx.Frame.__init__(self, parent, title=title, size=(400, 250))

        self.SetIcon(wx.Icon('icons/wxwin.ico'))
        
        #------------

        self.panel = wx.Panel(self, -1, (0, 0), (400 , 200))
        self.panel.SetBackgroundColour("#eceade")

        #------------
        
        self.sizer = wx.BoxSizer(wx.VERTICAL)
        self.sizer.Add(self.panel, 1, wx.EXPAND )

        self.SetSizer(self.sizer)
        self.SetAutoLayout(True)
        self.sizer.Fit(self)
        self.Centre()

#---------------------------------------------------------------------------

class SingleApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        self.name = "SingleApp-%s" % wx.GetUserId()
        self.instance = wx.SingleInstanceChecker(self.name)

        if self.instance.IsAnotherRunning():
            wx.MessageBox("Another instance is running.", "ERROR")
            return False

        #------------

        frame = SingleAppFrame(None, "Single application")
        frame.Show()

        return True

#---------------------------------------------------------------------------

def main():
    app = SingleApp(redirect=False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
