# sample_one.py

import wx

# class MyPanel
# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyPanel(wx.Panel):
    def __init__(self, *args, **kwargs):
        wx.Panel.__init__(self, *args, **kwargs)

        self.Bind(wx.EVT_PAINT, self.OnPaint)

    #-----------------------------------------------------------------------
        
    def OnPaint(self, event):
        """
        ...
        """
        
        pdc = wx.PaintDC(self)
        gc = wx.GCDC(pdc)
        gc.Clear()

        pen = wx.Pen("black", 2, wx.SOLID)
        pen.SetCap(wx.CAP_BUTT)
        gc.SetPen(pen)
        gc.SetBrush(wx.RED_BRUSH)
        
        x = 100 
        y = 30
        w = 50
        h = 50
        
        for radius in [0, 90, 180, 270, -90, -180, -270]:
            # x, y , width, height, start, end
            gc.DrawEllipticArc(x, y, w, h, 0, radius)
            gc.DrawText(str(radius), int(x+w+10), int(y+h/2))
            y+=100

#---------------------------------------------------------------------------
            
class MyFrame(wx.Frame):
    def __init__(self, *args, **kwargs):
        wx.Frame.__init__(self, *args, **kwargs)

        #------------
        
        frameicon = wx.Icon("icon_wxWidgets.ico")
        self.SetIcon(frameicon)

        #------------
        
        self.Panel = MyPanel(self)

#--------------------------------------------------------------------------- 

class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        frame = MyFrame(None, title="Sample_one - A", size=(270, 750))
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------  

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
