# lines.py

import wx
import random

# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    """
    This window displays a button.
    """
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, None, -1, title,
                         wx.DefaultPosition,
                         size=(400, 400),
                         style=wx.DEFAULT_FRAME_STYLE |
                               wx.NO_FULL_REPAINT_ON_RESIZE)

        self.SetIcon(wx.Icon('wxwin.ico'))
        self.SetBackgroundColour(wx.WHITE)
        self.SetMinSize((220, 220))

        self.Bind(wx.EVT_CLOSE, self.OnQuit)
        
        self.Bind(wx.EVT_TIMER, self.OnTimer)
        self.Bind(wx.EVT_SIZE, self.BuildImage)

        self.Numtimer = 0
        self.NumLines = 100

        self.timer = wx.Timer(self)
        self.BuildImage()
        self.timer.Start(100)

    #-----------------------------------------------------------------------
        
    def OnQuit(self, event):
        """
        ...
        """
        
        self.Destroy()


    def BuildImage(self, event=None):
        """
        ...
        """
        
        Size = self.GetClientSize()

        # Make new offscreen bitmap : this bitmap will always have the
        # current drawing in it, so it can be used to save the image to
        # a file, or whatever.
        print("making new buffer :", Size)
        self._Buffer = wx.Bitmap(Size[0], Size[1])

        dc = wx.MemoryDC()
        dc.SelectObject(self._Buffer)
        dc = wx.GCDC(dc)
        
        self.Lines = []
        
        for i in range(self.NumLines):
            x1, y1, x2, y2 = (random.randint(1, max(Size)),
                              random.randint(1, max(Size)),
                              random.randint(1, max(Size)),
                              random.randint(1, max(Size)))
            
            color = self.random_color()
            self.Lines.append([color, (x1 ,y1, x2, y2)])
        
        dc.Clear()
        
        for line in self.Lines:
            dc.SetPen(wx.Pen(line[0], 2))
            dc.DrawLine(*line[1])


    def OnTimer(self,event):
        """
        ...
        """
        
        self.Numtimer += 1
        print("Timer fired : %i times" % self.Numtimer)

        # Change one color.
        self.Lines[random.randrange(self.NumLines)][0] = self.random_color()

        # Update the screen.
        dc = wx.MemoryDC()
        dc.SelectObject(self._Buffer)
        dc = wx.GCDC(dc)
        dc.Clear()
        
        for line in self.Lines:
            dc.SetPen(wx.Pen(line[0], 2))
            dc.DrawLine(*line[1])

        del dc
        
        wx.ClientDC(self).DrawBitmap(self._Buffer, 0, 0)

        
    def random_color(self):
        """
        ...
        """
        
        col = wx.Colour(random.randrange(255),
                        random.randrange(255),
                        random.randrange(255))

        return col
        
#---------------------------------------------------------------------------

class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        frame = MyFrame(None, -1, title="Lines")
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------  

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()


