# Balls.py

# https://bty.sakura.ne.jp/wp/archives/78
 
import wx
import wx.lib.mixins.listctrl as listmix

# class MyBall
# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyBall(object):
    def __init__(self, panel, x, y, color, pen):

        #------------
        
        self.pos_x = x
        self.pos_y = y
        self.dir_x = 1
        self.dir_y = 1
        self.pos_dif = 20
        self.pos_x_max, self.pos_y_max = panel.GetSize()
        self.color = color
        self.pen = pen

    #-----------------------------------------------------------------------
        
    def Move(self):
        """
        ...
        """
        
        if self.dir_x > 0:
            self.pos_x += self.pos_dif
        else:
            self.pos_x -= self.pos_dif
 
        if self.pos_x > self.pos_x_max:
            self.pos_x -= self.pos_dif
            self.dir_x = -1
         
        if self.pos_x < 0:
            self.pos_x += self.pos_dif
            self.dir_x = 1
 
        if self.dir_y > 0:
            self.pos_y += self.pos_dif
        else:
            self.pos_y -= self.pos_dif
 
        if self.pos_y > self.pos_y_max:
            self.pos_y -= self.pos_dif
            self.dir_y = -1
         
        if self.pos_y < 0:
            self.pos_y += self.pos_dif
            self.dir_y = 1

 
    def Draw(self, dc):
        """
        ...
        """
  
        dc.SetPen(wx.Pen(self.pen, 3))
        dc.SetBrush(wx.Brush(self.color))
        dc.DrawCircle(self.pos_x, self.pos_y, 20)
        
#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, title):
        wx.Frame.__init__(self, None, -1,
                          title)

        #------------
        
        self.SetIcon(wx.Icon('wxwin.ico'))
        self.SetMinSize((420, 240))

        #------------
        
        self.panel = wx.Panel(self, size=(404, 200))
        self.panel.SetBackgroundColour('light gray')
        self.Fit() 
 
        self.ball1 = MyBall(self.panel, 150, 100, 'red', 'black')
        self.ball2 = MyBall(self.panel, 100,  50, 'blue', 'gray')
        self.ball3 = MyBall(self.panel,  50, 150, 'green', 'blue')
 
        self.Bind(wx.EVT_CLOSE, self.CloseWindow)

        #------------
        
        self.cdc = wx.ClientDC(self.panel)
        w, h = self.panel.GetSize()
        self.bmp = wx.Bitmap(w, h)

        #------------
        
        self.timer = wx.Timer(self)
        self.Bind(wx.EVT_TIMER, self.OnTimer)
        self.timer.Start(100)

    #-----------------------------------------------------------------------
        
    def CloseWindow(self, event):
        """
        ...
        """
      
        self.timer.Stop()
        self.Destroy()
        wx.Exit()

 
    def OnTimer(self, event):
        """
        ...
        """
        
        bdc = wx.BufferedDC(self.cdc, self.bmp)
        gcdc = wx.GCDC(bdc)
        gcdc.SetBackground(wx.Brush("light gray"))
        gcdc.Clear()

        self.ball1.Move()
        self.ball2.Move()
        self.ball3.Move()
 
        self.ball1.Draw(gcdc)
        self.ball2.Draw(gcdc)
        self.ball3.Draw(gcdc)
 
        gcdc.DrawText("Moving Ball", 110, 70)
        gcdc.DrawBitmap(self.bmp, 0, 0)

#---------------------------------------------------------------------------

class MyApp(wx.App):    
    def OnInit(self):

        #------------

        frame = MyFrame("Balls")
        self.SetTopWindow(frame)
        frame.Show(True)

        return True
    
#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
    
