# sample_one.py

import wx

"""

Author : Jan Bodnar
Website : zetcode.com

"""

# class MyIsabelle
# class MyApp
    
#---------------------------------------------------------------------------

class MyIsabelle(wx.Frame):
    def __init__(self, parent, id, title, size):
        wx.Frame.__init__(self, parent, id,
                          title, (0, 0), size,
                          style=wx.DEFAULT_FRAME_STYLE)

        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))        
        
        #------------
        
        self.timer = wx.Timer(self, 1)

        #------------
        
        self.blick = 0

        #------------
        
        self.statusbar = self.CreateStatusBar()
        self.statusbar.SetStatusText("Welcome to Isabelle")

        #------------
        
        File = wx.Menu()
        File.Append(30, "&Quit\tCtrl+Q", "Quit Isabelle")

        Help = wx.Menu()
        Help.Append(31, "&About", "About this program")

        menuBar = wx.MenuBar()
        menuBar.Append(File, "&File")
        menuBar.Append(Help, "&Help")
        self.SetMenuBar(menuBar)

        #------------
        
        tb = self.CreateToolBar(wx.TB_HORIZONTAL | wx.NO_BORDER |
                                wx.TB_FLAT | wx.TB_TEXT)

        self.CommandLine = wx.TextCtrl(tb, 21, size=(100, -1))

        self.LaunchCommand = wx.Button(tb, 20, "Ok", size=wx.Size(40, 20))

        tb.AddControl(self.CommandLine)
        tb.AddSeparator()
        tb.AddControl(self.LaunchCommand)
        tb.Realize()

        #------------
        
        self.Bind(wx.EVT_TEXT_ENTER, self.OnLaunchCommandOk, id=21)  
        self.Bind(wx.EVT_BUTTON, self.OnLaunchCommandOk, id=20)
        self.Bind(wx.EVT_MENU, self.OnAbout, id=31)
        self.Bind(wx.EVT_MENU, self.OnExit, id=30)
        self.Bind(wx.EVT_TIMER, self.OnTimer, id=1)

        #------------
        
        self.panel = wx.Panel(self, -1, (0, 0), (400 , 200))
        self.panel.SetBackgroundColour("#707070")

        #------------
        
        self.sizer = wx.BoxSizer(wx.VERTICAL)
        self.sizer.Add(self.panel, 1, wx.EXPAND )

        self.SetSizer(self.sizer)
        self.SetAutoLayout(1)
        self.sizer.Fit(self)
        self.Centre()

    #-----------------------------------------------------------------------
        
    def OnExit(self, event):
        """
        ...
        """
        
        dlg = wx.MessageDialog(self,
                               'Are you sure to quit Isabelle ?',
                               'Please Confirm',
                               wx.YES_NO |
                               wx.NO_DEFAULT |
                               wx.ICON_QUESTION)

        if dlg.ShowModal() == wx.ID_YES:
                self.Close(True)         


    def OnAbout(self, event):
        """
        ...
        """
        
        dlg = wx.MessageDialog(self,
                               "Isabelle\t\n"
                               "2004\t",
                               "About",
                               wx.OK |
                               wx.ICON_INFORMATION)
        dlg.ShowModal()
        dlg.Destroy()


    def OnLaunchCommandOk(self, event):
        """
        ...
        """
        
        input = self.CommandLine.GetValue()

        if input == '/bye':
                self.OnExit(self)
        elif input == '/about':
                self.OnAbout(self)
        elif input == '/bell':
                wx.Bell()
        else:
                self.statusbar.SetBackgroundColour("RED")
                self.statusbar.SetStatusText("Unknown Command ")
                self.statusbar.Refresh()
                self.timer.Start(10)
        
        self.CommandLine.Clear()


    def OnTimer(self, event):
        """
        ...
        """
        
        self.blick = self.blick + 1

        if self.blick == 25:
                self.statusbar.SetBackgroundColour("#E0E2EB")
                self.statusbar.Refresh()

                self.timer.Stop()
                self.blick = 0

#---------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):

        #------------

        frame = MyIsabelle(None, -1,
                           "Isabelle",
                           (-1, -1))
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------

def main():
    app = MyApp(redirect=False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
