# demo.py

#-------------------------------------------------------------------------------
# Site internet :  www.noethys.com
# Auteur:          Noethys
# Copyright:       (c) 2012 Noethys
# Licence:         Licence wxWidgets
# Based on wx.lib.ticker by Chris Mellon
#-------------------------------------------------------------------------------

import wx
import newsticker
import wx.lib.colourselect as csel

# class DemoPanel
# class DemoFrame

PAGES = """<t>PAGE 1</t>This is the first page.
<t>PAGE 2</t>This is the second page.
This page doesn't have header.
<t>INFO</t>Note this control supports multiline texts.
<t>NOTE</t>Mouse over control stops scrolling.
"""

#-------------------------------------------------------------------------------

class DemoPanel(wx.Panel):
    def __init__(self, *args, **kwds):
        kwds["style"] = wx.TAB_TRAVERSAL
        wx.Panel.__init__(self, *args, **kwds)
        
        # Preview
        self.box_preview_staticbox = wx.StaticBox(self, -1, "Preview")
        self.ctrl_newsticker = newsticker.Newsticker(self)
        self.ctrl_newsticker.SetMinSize((-1, 100)) 
        
        # Properties
        self.box_properties_staticbox = wx.StaticBox(self, -1, "Properties")
        self.label_fcolor = wx.StaticText(self, -1, "Foreground Color :")
        self.ctrl_fcolor = csel.ColourSelect(self, -1, colour=self.ctrl_newsticker.GetForegroundColour())
        self.label_bcolor = wx.StaticText(self, -1, "Background Color :")
        self.ctrl_bcolor = csel.ColourSelect(self, -1, colour=self.ctrl_newsticker.GetBackgroundColour())
        self.label_font = wx.StaticText(self, -1, "Font :")
        self.ctrl_font = wx.FontPickerCtrl(self, -1, 
                                           font=self.ctrl_newsticker.GetFont(),
                                           style=wx.FNTP_FONTDESC_AS_LABEL |
                                                 wx.FNTP_USEFONT_FOR_LABEL
                                                 )
        self.label_fps = wx.StaticText(self, -1, "Frame per second :")
        self.ctrl_fps = wx.Slider(self, -1, 20, 1, 100, style=wx.SL_HORIZONTAL)
        self.label_ppf = wx.StaticText(self, -1, "Pixels per frame :")
        self.ctrl_ppf = wx.Slider(self, -1, 2, 1, 10, style=wx.SL_HORIZONTAL)
        self.label_pause = wx.StaticText(self, -1, "Pause time (sec) :")
        self.ctrl_pause = wx.SpinCtrl(self, -1, "2", min=0, max=100, size=(60, -1))
        self.label_heading = wx.StaticText(self, -1, "Heading style :")
        self.ctrl_heading = wx.Choice(self, -1, choices=["Without heading",
                                                         "Style 1",
                                                         "Style 2",
                                                         "Style 3",
                                                         "Style 4",
                                                         "Style 5"])
        self.ctrl_heading.SetSelection(5)
        
        # Examples
        self.box_examples_staticbox = wx.StaticBox(self, -1, "Pages")
        self.label_intro = wx.StaticText(self, -1, "Just write a text per line :")
        self.ctrl_pages = wx.TextCtrl(self, -1, PAGES, style=wx.TE_MULTILINE)

        # Layout
        grid_sizer_base = wx.FlexGridSizer(2, 1, 10, 10)
        grid_sizer_parameters = wx.FlexGridSizer(1, 2, 10, 10)

        box_preview = wx.StaticBoxSizer(self.box_preview_staticbox, wx.VERTICAL)
        box_preview.Add(self.ctrl_newsticker, 1, wx.ALL|wx.EXPAND, 10)
        grid_sizer_base.Add(box_preview, 1, wx.LEFT|wx.RIGHT|wx.TOP|wx.EXPAND, 10)

        box_properties = wx.StaticBoxSizer(self.box_properties_staticbox, wx.VERTICAL)
        grid_sizer_properties = wx.FlexGridSizer(7, 2, 10, 10)
        grid_sizer_properties.Add(self.label_fcolor, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_properties.Add(self.ctrl_fcolor, 0, 0, 0)
        grid_sizer_properties.Add(self.label_bcolor, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_properties.Add(self.ctrl_bcolor, 0, 0, 0)
        grid_sizer_properties.Add(self.label_font, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_properties.Add(self.ctrl_font, 0, 0, 0)
        grid_sizer_properties.Add(self.label_fps, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_properties.Add(self.ctrl_fps, 0, wx.EXPAND, 0)
        grid_sizer_properties.Add(self.label_ppf, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_properties.Add(self.ctrl_ppf, 0, wx.EXPAND, 0)
        grid_sizer_properties.Add(self.label_pause, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_properties.Add(self.ctrl_pause, 0, 0, 0)
        grid_sizer_properties.Add(self.label_heading, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_properties.Add(self.ctrl_heading, 0, 0, 0)
        box_properties.Add(grid_sizer_properties, 1, wx.ALL|wx.EXPAND, 10)
        grid_sizer_parameters.Add(box_properties, 1, wx.EXPAND, 0)

        box_examples = wx.StaticBoxSizer(self.box_examples_staticbox, wx.VERTICAL)
        box_examples.Add(self.label_intro, 0, wx.ALL|wx.EXPAND, 10)
        box_examples.Add(self.ctrl_pages, 1, wx.LEFT|wx.RIGHT|wx.BOTTOM|wx.EXPAND, 10)
        
        grid_sizer_parameters.Add(box_examples, 1, wx.EXPAND, 0)
        grid_sizer_parameters.AddGrowableCol(1)
        grid_sizer_base.Add(grid_sizer_parameters, 1, wx.LEFT|wx.RIGHT|wx.BOTTOM|wx.EXPAND, 10)
        
        self.SetSizer(grid_sizer_base)
        grid_sizer_base.Fit(self)
        grid_sizer_base.AddGrowableCol(0)
        
        # Binds
        self.Bind(csel.EVT_COLOURSELECT, self.OnChangeForegroundColor, self.ctrl_fcolor)
        self.Bind(csel.EVT_COLOURSELECT, self.OnChangeBackgroundColor, self.ctrl_bcolor)
        self.Bind(wx.EVT_FONTPICKER_CHANGED, self.OnChangeFont, self.ctrl_font)
        self.Bind(wx.EVT_COMMAND_SCROLL, self.OnChangePPS, self.ctrl_fps)
        self.Bind(wx.EVT_COMMAND_SCROLL, self.OnChangePPF, self.ctrl_ppf)
        self.Bind(wx.EVT_SPINCTRL, self.OnChangePause, self.ctrl_pause)
        self.Bind(wx.EVT_CHOICE, self.OnChangeHeading, self.ctrl_heading)
        self.Bind(wx.EVT_TEXT, self.OnChangePages, self.ctrl_pages)
        
        # Init pages
        self.ctrl_newsticker.SetPages(self.GetPages())
        
    #---------------------------------------------------------------------------
        
    def OnChangeForegroundColor(self, event):
        self.ctrl_newsticker.SetForegroundColour(event.GetValue())

    def OnChangeBackgroundColor(self, event):
        self.ctrl_newsticker.SetBackgroundColour(event.GetValue())
    
    def OnChangeFont(self, event):
        self.ctrl_newsticker.SetFont(event.GetFont())
        
    def OnChangePPS(self, event): 
        self.ctrl_newsticker.SetFPS(event.GetPosition())

    def OnChangePPF(self, event): 
        self.ctrl_newsticker.SetPPF(event.GetPosition())

    def OnChangePause(self, event):
        self.ctrl_newsticker.SetPauseTime(event.EventObject.GetValue()*1000)

    def OnChangeHeading(self, event): 
        self.ctrl_newsticker.SetHeadingStyle(event.GetSelection())

    def OnChangePages(self, event): 
        self.ctrl_newsticker.SetPages(self.GetPages())
    
    def GetPages(self):
        text = self.ctrl_pages.GetValue()
        if len(text) == 0 :
            listePages = []
        else :
            listePages = text.split("\n")
        return listePages

#-------------------------------------------------------------------------------
    
class DemoFrame(wx.Frame):
    def __init__(self, *args, **kwds):
        wx.Frame.__init__(self, *args, **kwds)
        self.SetMinSize((720, 600))
        panel = DemoPanel(self)
        self.Layout()
        self.CenterOnScreen()

#-------------------------------------------------------------------------------
        
if __name__ == '__main__':
    app = wx.App(0)
    frame_1 = DemoFrame(None, -1, "DEMO Newsticker")
    app.SetTopWindow(frame_1)
    frame_1.Show()
    app.MainLoop()


