# sample_one.py

"""

https://discuss.wxpython.org/t/staticboxsizer-question/23987/3

"""

import wx

# class MyFrame

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self, None, -1, "wx.StaticBoxSizer", size=(300,150))

        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico', wx.BITMAP_TYPE_ICO))
        self.SetMinSize((300,150))
         
        #------------

        self.panel = wx.Panel(self)

        box = wx.StaticBox(self.panel, -1, "Label text here :")
         
        txt = wx.StaticText(self.panel, -1,
                            "Some other text here.\n"
                            "Some other text here.\nSome other text here.\n"
                            "Some other text here. Some other text here. Some other....")

        #------------         
         
        sizer = wx.BoxSizer(wx.HORIZONTAL)
        psizer = wx.BoxSizer(wx.VERTICAL)
        bsizer = wx.StaticBoxSizer(box, wx.VERTICAL)
         
        sizer.Add(self.panel, 1, wx.EXPAND)
        psizer.Add(bsizer, 1, wx.EXPAND|wx.ALL, 10)
        bsizer.Add(txt, proportion=1, flag=wx.ALL, border=10)

        self.panel.SetSizer(psizer)
        self.SetSizer(sizer)
        self.Fit()

#---------------------------------------------------------------------------

if __name__ == '__main__':
    app = wx.App(False)
    frm = MyFrame()
    frm.Show(True)
    app.MainLoop()
