# sample_two.py

"""

https://maku77.github.io/python/wxpython/splitterwindow.html

wx.SplitterWindow(Window parent, int id=-1, Point pos=DefaultPosition,
    Size size=DefaultSize, long style=SP_3D, String name=SplitterNameStr) -> SplitterWindow

wx.SPLIT_VERTICAL
wx.SPLIT_HORIZONTAL

"""

import wx

# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, None, -1, title, size=(300, 200))

        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))

        #------------
        
        self.InitializeComponents()

    #-----------------------------------------------------------------------
        
    def InitializeComponents(self):
        sp = wx.SplitterWindow(self)
        
        p1 = wx.Panel(sp, style=wx.SUNKEN_BORDER)
        p1.SetBackgroundColour('#fc751b')
        
        p2 = wx.Panel(sp, style=wx.SUNKEN_BORDER)
        p2.SetBackgroundColour('#1bb4fc')
        
        sp.SplitVertically(p1, p2, 100)  # Split the window left and right.
        sp.SetMinimumPaneSize(1)         # Minimum size of subwindow.

#---------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):
        frame = MyFrame(None, -1, 'wx.SplitterWindow')
        frame.Show(True)
        self.SetTopWindow(frame)
        
        return True

#---------------------------------------------------------------------------

app = MyApp(0)
app.MainLoop()
