# Sample_one.py

"""

Author : Jan Bodnar
Website : zetcode.com

"""

import wx

# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, None, -1, title, size=(350, 300))

        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))

        #------------
        
        splitter = wx.SplitterWindow(self, -1)
        splitter.SetMinimumPaneSize(20)
        
        panel1 = wx.Panel(splitter, -1)
        panel1.SetBackgroundColour(wx.LIGHT_GREY)
        
        wx.StaticText(panel1, -1,
                      "Whether you think that you can, or that you can't, you are usually right."
                      "\n\n Henry Ford",
                      (100,100), style=wx.ALIGN_CENTRE)

        panel2 = wx.Panel(splitter, -1)
        panel2.SetBackgroundColour(wx.YELLOW)

        splitter.SplitVertically(panel1, panel2)

        #------------
        
        self.Centre()

#---------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):
        frame = MyFrame(None, -1, 'wx.SplitterWindow')
        frame.Show(True)
        self.SetTopWindow(frame)
        
        return True

#---------------------------------------------------------------------------

app = MyApp(0)
app.MainLoop()

