# sample_one.py

"""
This is a minimal wxPython program to show a SplashScreen widget.
"""

import wx
from   wx.adv import SplashScreen as SplashScreen

# class MyGui
# class MySplashScreen
# class MyApp

#---------------------------------------------------------------------------

class MyGui(wx.Frame):
    """
    Hello World!
    """
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, id, title)

        #------------

        frameicon = wx.Icon("icon_wxWidgets.ico")
        self.SetIcon(frameicon)

        #------------

        # Put more GUI code here for a fancier application.
        self.panel = wx.Panel(self, -1)

        #------------

        # MainSizer is the top-level one that manages everything.
        mainSizer = wx.BoxSizer(wx.VERTICAL)

        # Finally, tell the panel to use the sizer for layout.
        self.panel.SetAutoLayout(True)
        self.panel.SetSizer(mainSizer)

        mainSizer.Fit(self.panel)

#---------------------------------------------------------------------------

class MySplashScreen(SplashScreen):
    """
    Create a splash screen widget.
    """
    def __init__(self, parent=None):

        #------------

        # This is a recipe to a the screen.
        # Modify the following variables as necessary.
        bitmap = wx.Bitmap(name="wxPyWiki.jpg", type=wx.BITMAP_TYPE_JPEG)
        splash = wx.adv.SPLASH_CENTRE_ON_SCREEN | wx.adv.SPLASH_TIMEOUT
        duration = 3000 # milliseconds

        # Call the constructor with the above arguments
        # in exactly the following order.
        super(MySplashScreen, self).__init__(bitmap=bitmap,
                                             splashStyle=splash,
                                             milliseconds=duration,
                                             parent=None,
                                             id=-1,
                                             pos=wx.DefaultPosition,
                                             size=wx.DefaultSize,
                                             style=wx.STAY_ON_TOP |
                                                   wx.BORDER_NONE)

        self.Bind(wx.EVT_CLOSE, self.OnExit)

    #-----------------------------------------------------------------------

    def OnExit(self, event):
        """
        ...
        """

        # The program will freeze without this line.
        event.Skip()  # Make sure the default handler runs too...
        self.Hide()

        #------------

        # MyFrame is the main frame.
        MyFrame = MyGui(None, -1, "Hello from wxPython")
        MyFrame.CenterOnScreen(wx.BOTH)
        MyFrame.Show(True)

#---------------------------------------------------------------------------

class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        MySplash = MySplashScreen()
        MySplash.CenterOnScreen(wx.BOTH)
        MySplash.Show(True)

        return True

#---------------------------------------------------------------------------

def main():
    app = MyApp(redirect=True, filename = "demo.log")
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
