# sample_one.py

"""

Author : Jan Bodnar
Website : zetcode.com

"""

import wx

# class MyDialog
# class MyApp

#---------------------------------------------------------------------------

class MyDialog(wx.Dialog):
    def __init__(self, parent, id, title):
        wx.Dialog.__init__(self, parent, id, title,
                           wx.DefaultPosition, wx.Size(350, 350))

        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico', wx.BITMAP_TYPE_ICO))
  
        #------------

        # wx.Font(pointSize, family, style, weight, underline, faceName)
        font = wx.SystemSettings.GetFont(wx.SYS_DEFAULT_GUI_FONT)
        font.SetWeight(wx.BOLD)
        
        #------------
        
        self.convert = wx.StaticText(self, -1,
                                     '  Convert Fahrenheit temperature to Celsius  ',
                                     (20, 20), (-1, -1), wx.ALIGN_CENTER)
        self.convert.SetFont(font)
        self.convert.SetForegroundColour('White')
        self.convert.SetBackgroundColour('Red')


        self.Fahrenheit = wx.StaticText(self, -1, 'Fahrenheit : ', (20, 80))
        self.Fahrenheit.SetFont(font)
        
        self.celsius = wx.StaticText(self, -1, 'Celsius : ', (20, 150))
        self.celsius.SetFont(font)
      
        self.result =  wx.StaticText(self, -1, '...............', (150, 150))
        self.result.SetForegroundColour('Blue')
        
        self.sc = wx.SpinCtrl(self, -1, '', (150, 75), (60, -1))
        self.sc.SetRange(-459, 1000)
        self.sc.SetValue(0)

        compute_btn = wx.Button(self, 1, 'Co&mpute', (70, 250))
        compute_btn.SetFocus()

        clear_btn = wx.Button(self, 2, '&Close', (185, 250))

        #------------

        self.Bind(wx.EVT_BUTTON, self.OnCompute, id=1)
        self.Bind(wx.EVT_BUTTON, self.OnClose, id=2)
        self.Bind(wx.EVT_CLOSE, self.OnClose)

    #-----------------------------------------------------------------------

    def OnCompute(self, event):
        fahr = self.sc.GetValue()
        cels = round((fahr-32)*5/9.0, 2)
        self.result.SetLabel(str(cels))


    def OnClose(self, event):
        self.Destroy()

#---------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):
        dlg = MyDialog(None, -1, 'wx.SpinCtrl')
        dlg.Centre()
        dlg.Show(True)
        
        return True

#---------------------------------------------------------------------------

app = MyApp(0)
app.MainLoop()

