# sample_one.py

"""

Author : Jan Bodnar
Website : zetcode.com

"""

import wx

# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, id, title,
                          wx.DefaultPosition, (300, 150))

        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico', wx.BITMAP_TYPE_ICO))

        #------------
        
        panel = wx.Panel(self, -1)

        self.sld = wx.Slider(panel, -1, 200, 150, 500, wx.DefaultPosition, (250, -1),
                              wx.SL_AUTOTICKS | wx.SL_HORIZONTAL | wx.SL_LABELS)

        btn1 = wx.Button(panel, 8, '&Adjust')
        btn2 = wx.Button(panel, 9, '&Close')

        #------------
        
        vbox = wx.BoxSizer(wx.VERTICAL)
        hbox = wx.BoxSizer(wx.HORIZONTAL)

        hbox.Add(btn1, 1, wx.RIGHT, 10)
        hbox.Add(btn2, 1)       

        vbox.Add(self.sld, 1, wx.ALIGN_CENTRE | wx.ALL, 10)
        vbox.Add(hbox, 0, wx.ALIGN_CENTRE | wx.ALL, 20)

        panel.SetSizer(vbox)

        #------------
        
        self.Bind(wx.EVT_BUTTON, self.OnAdjust, id=8)
        self.Bind(wx.EVT_BUTTON, self.OnClose, id=9)
        
    #-----------------------------------------------------------------------
        
    def OnAdjust(self, event):
        val = self.sld.GetValue()
        self.SetSize((val*2, val))
        

    def OnClose(self, event):
        self.Close()

#---------------------------------------------------------------------------
        
class MyApp(wx.App):
    def OnInit(self):
        frame = MyFrame(None, -1, 'wx.Slider')
        frame.Centre()
        frame.Show(True)
        
        return True

#---------------------------------------------------------------------------
    
app = MyApp(0)
app.MainLoop()
