# sample_one.py

"""

Author : Jan Bodnar
Website : zetcode.com

"""

import wx

# class MyFrame
# class MyApp

#---------------------------------------------------------------------------
      
class MyFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, id, title, size=(500, 400))

        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico', wx.BITMAP_TYPE_ICO))
  
        #------------
        
        sw = wx.ScrolledWindow(self)
        
        bmp = wx.Image('./bitmaps/aliens.jpg', wx.BITMAP_TYPE_JPEG).ConvertToBitmap()
        wx.StaticBitmap(sw, -1, bmp)
       
        sw.SetScrollbars(20, 20, 55, 40)

        #------------
       
        self.Bind(wx.EVT_CLOSE, self.OnClose)

    #-----------------------------------------------------------------------
       
    def OnClose(self, event):
        self.Destroy()
        wx.Exit()

#---------------------------------------------------------------------------
        
class MyApp(wx.App):
    def OnInit(self):
       frame = MyFrame(None, -1, 'wx.ScrolledWindow')
       frame.Centre()
       frame.Show(True)
       
       return True

#---------------------------------------------------------------------------
    
app = MyApp(0)
app.MainLoop()
