# sample_one.py

import wx

# class MyPanel
# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyPanel(wx.Panel):
    def __init__(self, *args, **kwargs):
        wx.Panel.__init__(self, *args, **kwargs)

        self.Bind(wx.EVT_PAINT, self.OnPaint)

    #-----------------------------------------------------------------------
        
    def OnPaint(self, event):
        """
        ...
        """
        
        pdc = wx.PaintDC(self)
        gc = wx.GCDC(pdc)
        gc.Clear()
        
        gc.SetPen(wx.Pen("black", 2))
        gc.SetBrush(wx.YELLOW_BRUSH)
        
        x = 100 
        y = 30
        w = 100
        h = 50
        
        for radius in [3, 6, 9, 12, 15, 18, 21]:
            # x, y , width, height, radius
            gc.DrawRoundedRectangle(x, y, w, h, radius)
            gc.DrawText(str(radius), int(x+w+10), int(y+h/2))
            y+=100

#---------------------------------------------------------------------------
            
class MyFrame(wx.Frame):
    def __init__(self, *args, **kwargs):
        wx.Frame.__init__(self, *args, **kwargs)

        #------------
        
        frameicon = wx.Icon("icon_wxWidgets.ico")
        self.SetIcon(frameicon)

        #------------
        
        self.Panel = MyPanel(self)

#--------------------------------------------------------------------------- 

class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        frame = MyFrame(None, title="Sample_one", size=(320, 750))
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------  

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
