# sample_two.py

"""

Author : Jan Bodnar
Website : zetcode.com

"""

import wx
import wx.grid
#from wx.lib import sheet

# class MySheet
# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MySheet(wx.grid.Grid):
    def __init__(self, *args, **kw):
        super(MySheet, self).__init__(*args, **kw)

        self.SetLabelBackgroundColour('#DBD4D4')

        #------------
        
        self.InitUI()

    #-----------------------------------------------------------------------
        
    def InitUI(self):
        nOfRows = 55
        nOfCols = 25

        self.row = self.col = 0
        self.CreateGrid(nOfRows, nOfCols)

        self.SetColLabelSize(20)
        self.SetRowLabelSize(50)

#---------------------------------------------------------------------------
    
class MyFrame(wx.Frame):
    def __init__(self, *args, **kw):
        super(MyFrame, self).__init__(*args, **kw)

        self.InitUI()

    #-----------------------------------------------------------------------
        
    def InitUI(self):
        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))
        self.SetTitle("SpreadSheet")
        self.SetSize((550, 550))
        
        #------------
        
        menuBar = wx.MenuBar()
        
        file = wx.Menu()
        file.Append(101, 'Quit', '' )
        menuBar.Append(file, "&File")
        self.SetMenuBar(menuBar)

        self.Bind(wx.EVT_MENU, self.OnQuit, id=101)
        
        #------------

        notebook = wx.Notebook(self, style=wx.RIGHT)

        sheet1 = MySheet(notebook)
        sheet2 = MySheet(notebook)
        sheet3 = MySheet(notebook)
        sheet1.SetFocus()

        notebook.AddPage(sheet1, 'Sheet1')
        notebook.AddPage(sheet2, 'Sheet2')
        notebook.AddPage(sheet3, 'Sheet3')

        #------------
        
        box = wx.BoxSizer(wx.VERTICAL)
        box.Add(notebook, 1, wx.EXPAND)
        
        self.SetSizer(box)

        #------------
        
        self.StatusBar()

        #------------
        
        self.Centre()

    #-----------------------------------------------------------------------
        
    def StatusBar(self):
        self.statusbar = self.CreateStatusBar()


    def OnQuit(self, event):
        self.Close()
        
#---------------------------------------------------------------------------
        
class MyApp(wx.App):
    def OnInit(self):
         frame = MyFrame(None)
         frame.Centre()
         frame.Show(True)
    
         return True

#---------------------------------------------------------------------------

def main():
    app = MyApp(redirect=False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()

