# sample_one.py

import wx

# class MyPageOne
# class MyPageTwo
# class MyPageThree
# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyPageOne(wx.Panel):
    def __init__(self, parent):
        wx.Panel.__init__(self, parent)

        #------------
        
        self.SetBackgroundColour(wx.Colour("Green"))

        #------------
        
        txt = wx.StaticText(self, -1,
                            """This is a "MyPageOne" object""",
                            (20, 20))

#---------------------------------------------------------------------------
        
class MyPageTwo(wx.Panel):
    def __init__(self, parent):
        wx.Panel.__init__(self, parent)

        #------------
        
        self.SetBackgroundColour(wx.Colour("Yellow"))

        #------------
        
        txt = wx.StaticText(self, -1,
                            """This is a "MyPageTwo" object""",
                            (40, 40))

#---------------------------------------------------------------------------
        
class MyPageThree(wx.Panel):
    def __init__(self, parent):
        wx.Panel.__init__(self, parent)

        #------------
        
        self.SetBackgroundColour(wx.Colour("Light Gray"))

        #------------
        
        txt = wx.StaticText(self, -1,
                            """This is a "MyPageThree" object""",
                            (60, 60))

#---------------------------------------------------------------------------
        
class MyFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, id, title)

        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))
        
        #------------
        
        # Here we create a panel and a notebook on the panel.
        pnl = wx.Panel(self)
        nb = wx.Notebook(pnl)

        #------------
        
        # Ccreate the page windows as children of the notebook.
        page1 = MyPageOne(nb)
        page2 = MyPageTwo(nb)
        page3 = MyPageThree(nb)

        #------------
        
        # Add the pages to the notebook with the label to show on the tab.
        nb.AddPage(page1, "Page 1")
        nb.AddPage(page2, "Page 2")
        nb.AddPage(page3, "Page 3")

        #------------
        
        # Finally, put the notebook in a sizer for  
        # the panel to manage the layout.
        sizer = wx.BoxSizer()
        sizer.Add(nb, 1, wx.EXPAND)
        pnl.SetSizer(sizer)

#---------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):

        #------------

        frame = MyFrame(None, -1,
                        "Simple notebook example")
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------

def main():
    app = MyApp(redirect=False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
