# sample_six.py

import os
import sys
import wx
import wx.lib.mixins.listctrl as listmix

# class MyFrame
# class MyListCtrl
# class MyApp

#---------------------------------------------------------------------------

data = [
    ['Noel', 'Louise'],
    ['Martin', 'Justine'],
    ['Antoine', 'Eloise'],
    ['Jenifer', 'Marguerite'],
    ['Marc', 'Sophie'],
    ['Etienne', 'Edith'],
    ['Jhon', 'Doe']
    ]

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, title):
        wx.Frame.__init__(self, None, -1,
                          title,
                          size=(420, 225),
                          pos=(400, 448))

        #------------

        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------
        
        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        
    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetMinSize((420, 225))

        #------------

        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "wxwin.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)


    def CreateCtrls(self):
        """
        ...
        """

        self.btnCopy = wx.Button(self, -1, "Copy")
        self.Bind(wx.EVT_BUTTON, self.OnBtnCopy, self.btnCopy)
        
        self.listCtrl = MyListCtrl(self)

        #------------
        
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        btnSizer = wx.BoxSizer(wx.HORIZONTAL)
        
        btnSizer.Add(self.btnCopy, 1)
        
        mainSizer.Add(btnSizer, 0, wx.EXPAND)
        mainSizer.Add(self.listCtrl, 1, wx.EXPAND)

        self.SetSizer(mainSizer)

        
    def OnBtnCopy(self, event):
        """
        ...
        """
        
        if not wx.TheClipboard.Open():
            wx.MessageBox("Unable to copy to clipboard !")
            return

        text = ""
        for i in range(self.listCtrl.GetItemCount()):
            item = self.listCtrl.GetItem(i)
            if item.GetState() & wx.LIST_STATE_SELECTED:
                d = self.listCtrl.items[i]
                text += str(d[0])+' '+str(d[1])+'\r\n'
                print("Copy to wx.TheClipboard :", text)
                
        do = wx.TextDataObject(text)
        wx.TheClipboard.SetData(do)
        wx.TheClipboard.Close()
        
#---------------------------------------------------------------------------

class MyListCtrl(wx.ListCtrl,
                 listmix.ListCtrlAutoWidthMixin):
    def __init__(self, parent):
        wx.ListCtrl.__init__(self, parent, -1,
                             style=wx.LC_REPORT |
                                   wx.LC_HRULES |
                                   wx.LC_VRULES)

        #------------

        # Initialize the listCtrl auto width.
        listmix.ListCtrlAutoWidthMixin.__init__(self)

        #------------

        self.SetBackgroundColour("#d1ff00")
        
        #------------

        
        # Add some columns.
        columns = ["Firstname", "Surname"]
        
        for col, text in enumerate(columns):
            self.InsertColumn(col, text)

        #------------
            
        # Set the width of the columns.
        self.SetColumnWidth(0, 100)  # (0, -2)
        self.SetColumnWidth(1, 300)  # (1, -2)

        #------------

        # Add the rows.       
        for item in data:
            index = self.InsertItem(self.GetItemCount(), item[0])
            for col, text in enumerate(item[1:]):
                self.SetItem(index, col+1, text)

        #------------

        self.items = data
        print("Items :",  self.items)

    #-----------------------------------------------------------------------

    def GetListCtrl(self):
        """
        ...
        """
        
        return self
        
#---------------------------------------------------------------------------

class MyApp(wx.App):    
    def OnInit(self):
        
        #------------

        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]
        
        #------------

        frame = MyFrame("Sample six (copy to wx.Clipboard)")
        self.SetTopWindow(frame)
        frame.Show(True)

        return True
    
    #-----------------------------------------------------------------------
    
    def GetInstallDir(self):
        """
        Return the installation directory for my application.
        """

        return self.installDir


    def GetIconsDir(self):
        """
        Return the icons directory for my application.
        """

        icons_dir = os.path.join(self.installDir, "icons")
        return icons_dir
    
#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
    
