# sample_ten.py

"""

Author       : Chris Meyers
               Modified and updated for wxPython Phoenix by Ecco
Date (d/m/y) : 2003-2015 (v0.0.1)
               08/02/2020 (v0.0.2)
License      : http://www.gnu.org/licenses/copyleft.html
Link         : http://openbookproject.net/py4fun/gui/wxPhone.html
Version      : 0.0.2

"""

import os
import sys
import wx
import wx.lib.mixins.listctrl as listmix

# class MyAddDlg
# class MyFrame
# class MyApp

#-------------------------------------------------------------------------------

phoneList = [
    ("Muggs - J. Fred", "683-2341"),
    ("Andrea - James", "862-8654"),
    ("Tell - Guillaume", "235-3254"),
    ("Teddy - Mink", "458-7943"),
    ("Marc - Dyos", "973-5463"),
    ("Henry - Mask", "162-1023"),
    ("John - Lenon", "284-6354"),
    ("Andy - Smith", "462-1596"),
]

phoneList.sort()

#-------------------------------------------------------------------------------

class MyAddDlg(wx.Dialog):
    def __init__(self, parent, id, title, pos=wx.DefaultPosition, 
                 size=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE):
        wx.Dialog.__init__(self, parent, id, title, pos, size, style)

        #------------

        # Simplified init method.
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()

    #-----------------------------------------------------------------------

    def CreateCtrls(self):
        """
        ...
        """

        # Initialize some controls.
        self.text1 = wx.TextCtrl(self, -1, "")
        self.text2 = wx.TextCtrl(self, -1, "")
        
        #------------
        
        self.okay = wx.Button(self, wx.ID_OK)
        self.cancel = wx.Button(self, wx.ID_CANCEL)

        #------------
        
        self.st = wx.StaticText(self, -1, "")
        self.label1 = wx.StaticText(self, -1, "Name :")
        self.label2 = wx.StaticText(self, -1, "Phone :")
        

    def BindEvents(self):
        """
        ...
        """
        
        # Bind our events.
        self.Bind(wx.EVT_BUTTON, self.OnButton)


    def DoLayout(self):
        """
        ...
        """
        
        # Initialize the sizers and fill them.
        hsizer = wx.BoxSizer(wx.HORIZONTAL)
        sizer = wx.BoxSizer(wx.VERTICAL)
        
        #------------
        
        hsizer.Add(self.st, 1, wx.EXPAND, 0)
        hsizer.Add(self.okay, 0, wx.EXPAND, 0)
        hsizer.Add(self.cancel, 0, wx.EXPAND, 0)
 
        #------------
        
        sizer.Add(self.label1, 0, wx.EXPAND | wx.ALL, 4)
        sizer.Add(self.text1, 0, wx.EXPAND | wx.ALL, 4)
        sizer.Add(self.label2, 0, wx.EXPAND | wx.ALL, 4)
        sizer.Add(self.text2, 0, wx.EXPAND | wx.ALL, 4)
        sizer.Add(hsizer, 0, wx.EXPAND | wx.ALL, 4)

        #------------

        # Finally, tell the dialog to use the sizer for layout.        
        self.SetSizerAndFit(sizer)

        
    def OnButton(self, event):
        """
        ...
        """
        
        self.value1 = self.text1.GetValue()
        self.value2 = self.text2.GetValue()
        self.EndModal(event.GetId())

#-------------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, -1,
                          title,
                          size=(380, 320))

        #------------

        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()

        #------------

        self.CenterOnScreen(wx.BOTH)

    #---------------------------------------------------------------------------

    def SetProperties(self):
        """
        Set the frame properties (title, icon, transparency...).
        """

        self.SetMinSize((380, 320))

        #------------

        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "wxwin.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)


    def CreateCtrls(self):
        """
        Make widgets for my frame.
        """

        self.pnl = wx.Panel(self, -1)
        self.pnl.SetBackgroundColour("#e6e6e6")

        #------------

        self.txt1 = wx.StaticText(self.pnl, -1, "Name : ", size=(50, -1))
        self.name = wx.TextCtrl(self.pnl, 12, "", (-1, -1), (150, -1))

        #------------

        self.txt2 = wx.StaticText(self.pnl, -1, "Phone : ", size=(50, -1))
        self.phone = wx.TextCtrl(self.pnl, 12, "", (-1, -1), (150, -1))

        #------------

        self.b1 = wx.Button(self.pnl, 11, "&Add")
        self.b2 = wx.Button(self.pnl, 12, "&Update")
        self.b3 = wx.Button(self.pnl, 13, "&Delete")

        #------------

        self.lc = wx.ListCtrl(self.pnl, 15,
                              style=wx.LC_REPORT |
                                    wx.BORDER_SUNKEN |
                                    wx.LC_VRULES |
                                    wx.LC_HRULES |
                                    wx.LC_SINGLE_SEL)
        self.lc.InsertColumn(0, "Name")
        self.lc.InsertColumn(1, "Phone")

        self.lc.SetColumnWidth(0, wx.LIST_AUTOSIZE)
        self.lc.SetColumnWidth(1, 230)

        self.lc.SetBackgroundColour("#f3e8c4")


    def BindEvents(self):
        """
        Bind all the events related to my frame.
        """

        self.Bind(wx.EVT_BUTTON, self.AddEntry, id=11)
        self.Bind(wx.EVT_BUTTON, self.UpdateEntry, id=12)
        self.Bind(wx.EVT_BUTTON, self.DeleteEntry, id=13)

        self.Bind(wx.EVT_LIST_ITEM_SELECTED, self.GetSelect, id=15)


    def DoLayout(self):
        """
        ...
        """

        # MainSizer is the top-level one that manages everything.
        mainSizer = wx.BoxSizer(wx.VERTICAL)

        #------------

        nameSizer = wx.BoxSizer(wx.HORIZONTAL)
        phoneSizer = wx.BoxSizer(wx.HORIZONTAL)
        btnSizer = wx.BoxSizer(wx.HORIZONTAL)
        listSizer = wx.BoxSizer(wx.VERTICAL)
        borderSizer = wx.BoxSizer(wx.VERTICAL)

        #------------

        nameSizer.Add(self.txt1, 0, wx.ALIGN_CENTER)
        nameSizer.Add(self.name, 0)

        phoneSizer.Add(self.txt2, 0, wx.ALIGN_CENTER)
        phoneSizer.Add(self.phone, 0)

        btnSizer.Add(self.b1, 1, wx.EXPAND|wx.RIGHT, 5)
        btnSizer.Add(self.b2, 1, wx.EXPAND, 5)
        btnSizer.Add(self.b3, 1, wx.EXPAND|wx.LEFT, 5)

        listSizer.Add(self.lc, 1, wx.EXPAND)

        #------------

        borderSizer.Add(nameSizer, 0, wx.ALL, 5)
        borderSizer.Add(phoneSizer, 0, wx.ALL, 5)
        borderSizer.Add(btnSizer, 0, wx.ALL, 5)
        borderSizer.Add(listSizer, 1, wx.EXPAND|wx.ALL, 5)

        #------------

        mainSizer.Add(borderSizer, 1, wx.EXPAND|wx.ALL, 5)

        #------------

        # Finally, tell the panel to use the sizer for layout.
        self.pnl.SetSizer(mainSizer)
        self.Layout()


    def SetSelect (self) :
        """
        ...
        """


        print("Phone list :", phoneList)

        #------------

        self.lc.DeleteAllItems()

        #------------

        for i in range(len(phoneList)) :
            name, phone = phoneList[i]
            self.lc.InsertItem(i, name)
            self.lc.SetItem(i, 1, phone)

        #------------

        self.lc.SetColumnWidth(0, wx.LIST_AUTOSIZE)

        #------------

        # Just in case update attempted before load.
        self.currentSel = 0


    def GetSelect (self, event) :
        """
        ...
        """

        self.currentSel = event.Index

        name, phone = phoneList[self.currentSel]
        self.name.SetValue(name)
        print("Name :", self.name.GetValue())

        self.phone.SetValue(phone)
        print("Phone :", self.phone.GetValue())

        print("Selected row :", self.currentSel)


    def AddEntry (self, event) :
        """
        ...
        """

        dlg = MyAddDlg(self, -1, "Add...")
        if dlg.ShowModal() == wx.ID_OK:
            phoneList.append([dlg.value1,
                              dlg.value2])

        self.SetSelect()


    def UpdateEntry(self, event) :
        """
        ...
        """

        phoneList[self.currentSel] = [self.name.GetValue(),
                                      self.phone.GetValue()]

        self.SetSelect()


    def DeleteEntry(self, event) :
        """
        ...
        """

        del phoneList[self.currentSel]

        self.SetSelect()

#-------------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):

        #------------

        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]
        
        #------------

        frame = MyFrame(None, -1, "Sample ten (Phone list v0.0.2)")
        frame.SetSelect()
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

    #-----------------------------------------------------------------------
    
    def GetInstallDir(self):
        """
        Return the installation directory for my application.
        """

        return self.installDir


    def GetIconsDir(self):
        """
        Return the icons directory for my application.
        """

        icons_dir = os.path.join(self.installDir, "icons")
        return icons_dir
    
#-------------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#-------------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
