# sample_eight.py

import os
import sys
import wx
import wx.lib.mixins.listctrl as listmix

# class MyFrame
# class MyListCtrl
# class MyApp

#---------------------------------------------------------------------------

data = [
    ['Noel', 'Louise'],
    ['Martin', 'Justine'],
    ['Antoine', 'Eloise'],
    ['Jenifer', 'Marguerite'],
    ['Marc', 'Sophie'],
    ['Etienne', 'Edith'],
    ['Jhon', 'Doe']
    ]

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, title):
        wx.Frame.__init__(self, None, -1,
                          title,
                          size=(420, 200),
                          pos=(400, 448))

        #------------

        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------
        
        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        
    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetMinSize((420, 200))

        #------------

        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "wxwin.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)


    def CreateCtrls(self):
        """
        ...
        """

        self.listCtrl = MyListCtrl(self)
         
#---------------------------------------------------------------------------

class MyListCtrl(wx.ListCtrl,
                 listmix.ListCtrlAutoWidthMixin,
                 listmix.ColumnSorterMixin):
    def __init__(self, parent):
        wx.ListCtrl.__init__(self, parent, -1,
                             style=wx.LC_REPORT |
                                   wx.LC_HRULES |
                                   wx.LC_VRULES)

        #------------

        # Initialize the listCtrl auto width.
        listmix.ListCtrlAutoWidthMixin.__init__(self)

        #------------

        # Return bitmaps folder.
        self.bitmaps_dir = wx.GetApp().GetBitmapsDir()

        #------------

        self.SetBackgroundColour("#ffbb55")
        
        #------------

        # Load some images into an image list.
        il = wx.ImageList(16, 16, True)

        # Add row icon. 
        self.bmp = wx.Bitmap(os.path.join(self.bitmaps_dir,
                                          "folder.png"))

        # Add some arrows for the column sorter.
        self.up = wx.Bitmap(os.path.join(self.bitmaps_dir,
                                          "sm_up.png"))

        self.dn = wx.Bitmap(os.path.join(self.bitmaps_dir,
                                          "sm_down.png"))

        # Add image to list.
        self.idx = il.Add(self.bmp)
        self.sm_up = il.Add(self.up)
        self.sm_dn = il.Add(self.dn)
        
        # Assign the image list to it.
        self.AssignImageList(il, wx.IMAGE_LIST_SMALL)

        #------------
        
        # Add some columns.
        columns = ["Firstname", "Surname"]
        
        for col, text in enumerate(columns):
            self.InsertColumn(col, text)

        #------------
            
        # Set the width of the columns.
        self.SetColumnWidth(0, 100)  # (0, -2)
        self.SetColumnWidth(1, 300)  # (1, -2)

        #------------

        # Add the rows.
        self.itemDataMap = {}
        
        for item in data:
            index = self.InsertItem(self.GetItemCount(), item[0], self.idx)
            for col, text in enumerate(item[1:]):
                self.SetItem(index, col+1, text)

            # Give each item a data value, and map it back 
            # to the item values, for the column sorter.
            self.SetItemData(index, index)
            self.itemDataMap[index] = item

            # Give each item a image.
            self.SetItemImage(index, self.idx)
            
        #------------

        # Initialize the column sorter.
        listmix.ColumnSorterMixin.__init__(self, self.GetItemCount())
        
        # Column sorted by default.
        self.SortListItems(0, True)
        
        #------------
        
        self.items = data
        print("Items :",  self.items)

    #-----------------------------------------------------------------------
        
    def GetListCtrl(self):
        """
        ...
        """
        
        return self


    def GetSortImages(self):
        """
        ...
        """
        
        return (self.sm_dn, self.sm_up)
        
#---------------------------------------------------------------------------

class MyApp(wx.App):    
    def OnInit(self):
        
        #------------

        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]
        
        #------------

        frame = MyFrame("Sample eight (row/header icon)")
        self.SetTopWindow(frame)
        frame.Show(True)

        return True
    
    #-----------------------------------------------------------------------
    
    def GetInstallDir(self):
        """
        Return the installation directory for my application.
        """

        return self.installDir


    def GetIconsDir(self):
        """
        Return the icons directory for my application.
        """

        icons_dir = os.path.join(self.installDir, "icons")
        return icons_dir


    def GetBitmapsDir(self):
        """
        Return the bitmaps directory for my application.
        """

        bitmaps_dir = os.path.join(self.installDir, "bitmaps")
        return bitmaps_dir
    
#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
    
