# snake.py

"""

Created on 2011-03-23
Classic game - Snake
Author : 123
Website : https://www.programmersought.com/article/9994279643/

"""
 
import wx
import random,time
 
# class MyWesticeSnakeBody
# class MyWesticeSnake
# class MyFrame

#---------------------------------------------------------------------------

class MyWesticeSnakeBody():
    def __init__(self):

        randnum=int(random.random()*4)
        imagename='snakeskin'+str(randnum)+'.jpg'
        img1=wx.Image(imagename,wx.BITMAP_TYPE_ANY)
        self.img1=img1.Scale(30, 30) # Reduce the image.
        self.x=-1
        self.y=-1
 
#---------------------------------------------------------------------------
        
class MyWesticeSnake():
    def __init__(self):

        self.bodys=[]
        self.headx=int(random.random()*(10))+5
        self.heady=int(random.random()*(10))+5
        self.direct=int(random.random()*4)
        self.img1=wx.Image('snakehead.jpg',wx.BITMAP_TYPE_ANY)
        self.headimg90=self.img1.Rotate90(True)
        self.headimg180=self.headimg90.Rotate90(True)
        self.headimg_90=self.img1.Rotate90(False)
        self.headimg1=self.img1
        self.prev_snakex=self.headx
        self.prev_snakey=self.heady

    #-----------------------------------------------------------------------
        
    def update(self):
        """
        ...
        """
        
        # Save the last position of the snake before the moment.
        if len(self.bodys)!=0:
            self.prev_snakex=self.bodys[len(self.bodys)-1].x
            self.prev_snakey=self.bodys[len(self.bodys)-1].y
        else:
            self.prev_snakex=self.headx
            self.prev_snakey=self.heady
        
        if len(self.bodys)!=0:
            for index in range(len(self.bodys)-1,0,-1):
                self.bodys[index].x=self.bodys[index-1].x
                self.bodys[index].y=self.bodys[index-1].y
            self.bodys[0].x=self.headx
            self.bodys[0].y=self.heady        

        if self.direct==0:
                         self.headx+=1 # To the right.
        if self.direct==1:
                         self.heady+=1 # Down.
        if self.direct==2:
                         self.headx-=1 # To the left.
        if self.direct==3:
                         self.heady-=1 # Up.

        self.headimg1=self.img1
        if self.direct==0:
            self.headimg1=self.headimg90
        if self.direct==1:
            self.headimg1=self.headimg180
        if self.direct==2:
            self.headimg1=self.headimg_90
        self.headimg1=self.headimg1.Scale(30, 30)
 
#---------------------------------------------------------------------------
        
class MyFrame(wx.Frame):
    gridwidth=20
    gridheight=20
    landsqurelist=[]
    first=True
    def __init__(self):
        wx.Frame.__init__(self, None, -1,
                          "Snake game",
                          style=wx.SYSTEM_MENU |
                                wx.MINIMIZE_BOX |
                                wx.CLOSE_BOX |
                                wx.CAPTION)

        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))

        #------------

        self.InitUI()

        #------------

        # wx.Font(pointSize, family, style, weight, underline, faceName)
        font = wx.SystemSettings.GetFont(wx.SYS_DEFAULT_GUI_FONT)
        font.SetWeight(wx.BOLD)

        #------------
        
        self.panel=wx.Panel(self,-1)
        self.panel.SetBackgroundColour("#696767")
        self.score=0

        self.command0 = wx.StaticText(self.panel,-1,'Commands (AZERTY) :',pos=(630,20))
        self.command0.SetFont(font)
        self.command1 = wx.StaticText(self.panel,-1,'(Q) Left',pos=(630,50))
        self.command2 = wx.StaticText(self.panel,-1,'(D) Right',pos=(630,80))
        self.command3 = wx.StaticText(self.panel,-1,'(Z) Top',pos=(630,110))
        self.command4 = wx.StaticText(self.panel,-1,'(S) Bottom',pos=(630,140))
        self.command0.SetForegroundColour("#f38e3c")
        self.command1.SetForegroundColour(wx.WHITE)
        self.command2.SetForegroundColour(wx.WHITE)
        self.command3.SetForegroundColour(wx.WHITE)
        self.command4.SetForegroundColour(wx.WHITE)

        self.scoretxt=wx.StaticText(self.panel,-1,'Score : '+str(self.score),pos=(630,300))
        self.gamestatustxt=wx.StaticText(self.panel, -1, 'Game status : Running', pos=(630,350))
        self.scoretxt.SetForegroundColour(wx.WHITE)
        self.gamestatustxt.SetForegroundColour(wx.WHITE)
        
        fgs=wx.FlexGridSizer(cols=self.gridwidth,hgap=0,vgap=0)


        self.panel.SetFocus()
        
        for col in range(self.gridwidth):
            random.seed(time.time())
            for row in range(self.gridheight):
                
                # Loading grass.
                randnum=int(random.random()*4)
 
                if random.random()<0.02:
                    randnum=-1
                imagename='land'+str(randnum)+'.jpg'
                # print(imagename)
                img1=wx.Image(imagename,wx.BITMAP_TYPE_ANY)
                img1=img1.Scale(30, 30)# Reduce the image.
                sb1=wx.StaticBitmap(self.panel,-1,wx.Bitmap(img1))
                sb1.randnum=randnum # Save the image name.
                fgs.Add(sb1)
                self.landsqurelist.append(sb1)
        self.panel.SetSizerAndFit(fgs)

        # Initialize position.
        self.westicesnake=MyWesticeSnake()
 
        self.timer1=wx.Timer(self)
        self.Bind(wx.EVT_TIMER,self.frameUpdate,self.timer1)
        self.timer1.Start(300) # Can set the speed here.

        # wx.EVT_KEY_DOWN, self.OnKeyDown
        self.panel.Bind(wx.EVT_KEY_UP,self.OnKeyUp)   
        
    #-----------------------------------------------------------------------

    def InitUI(self):
        """
        ...
        """
        
        menuBar = wx.MenuBar()
        filemenu = wx.Menu()
        
        qmi = wx.MenuItem(filemenu, wx.ID_EXIT, "&Quit\tCtrl+Q")
        qmi.SetBitmap(wx.Bitmap("./images/exit.png"))
        filemenu.Append(qmi)
        
        self.Bind(wx.EVT_MENU, self.OnQuit, id=wx.ID_EXIT)

        menuBar.Append(filemenu, '&File')
        self.SetMenuBar(menuBar)

        self.statusbar = self.CreateStatusBar()
        self.statusbar.SetStatusText('Ready')
        
        self.SetSize((800, 683))
        self.Centre()
        
        
    def OnKeyUp(self,event):
        """
        ...
        """
        
        if ord('Q')==event.GetKeyCode()and self.westicesnake.direct!=0:
            # To the left.
            self.westicesnake.direct=2
        if ord('D')==event.GetKeyCode()and self.westicesnake.direct!=2:
            # To the right.
            self.westicesnake.direct=0
        if ord('S')==event.GetKeyCode()and self.westicesnake.direct!=3:
            # To the bottom.
            self.westicesnake.direct=1
        if ord('Z')==event.GetKeyCode()and self.westicesnake.direct!=1:
            # To the top.
            self.westicesnake.direct=3

        
    def frameUpdate(self,event):        
        """
        ...
        """
       
        if self.westicesnake.headx>=0and self.westicesnake.headx<self.gridwidth\
           and self.westicesnake.heady>=0and self.westicesnake.heady<self.gridheight:
            tempindex=self.getIndex(self.westicesnake.headx,self.westicesnake.heady)

            self.landsqurelist[tempindex].SetBitmap(wx.Bitmap(self.westicesnake.headimg1))
            
            # Show the snake body.             
            for body in self.westicesnake.bodys:
                tempindex=self.getIndex(body.x,body.y)
                self.landsqurelist[tempindex].SetBitmap(wx.Bitmap(body.img1))
                
            # Show the last vacated location.
            if not self.first:
                tempindex=self.getIndex(self.westicesnake.prev_snakex,self.westicesnake.prev_snakey)
                tempimagenum=self.landsqurelist[tempindex].randnum
                tempimagename='land'+str(tempimagenum)+'.jpg'
                img1=wx.Image(tempimagename,wx.BITMAP_TYPE_ANY)
                img1=img1.Scale(30, 30)
                self.landsqurelist[tempindex].SetBitmap(wx.Bitmap(img1))
            else:
                self.first=False

            # Long snake body, replace the cake with land.
            if self.landsqurelist[tempindex].randnum==(-1):
                # print('Eat the cake')
                self.score+=1
                self.scoretxt.SetLabel('Score : '+str(self.score))
                self.landsqurelist[tempindex].randnum=int(random.random()*4)
                
                # Body, set the coordinates, it should be added in the last vacated place.
                snakebody=MyWesticeSnakeBody()
                snakebody.x=self.westicesnake.prev_snakex
                snakebody.y=self.westicesnake.prev_snakey
                self.westicesnake.bodys.append(snakebody)
                
            # Randomly generate cakes in the land.
            tempindex=int(random.random()*self.gridwidth*self.gridheight)
            
            if self.landsqurelist[tempindex].randnum==-1:
                randnum=int(random.random()*4)
                imagename='land'+str(randnum)+'.jpg'
                self.landsqurelist[tempindex].randnum=randnum
            else:
                imagename='land-1.jpg'
                self.landsqurelist[tempindex].randnum=-1 
               
            img1=wx.Image(imagename,wx.BITMAP_TYPE_ANY)
            img1=img1.Scale(30, 30)
            self.landsqurelist[tempindex].SetBitmap(wx.Bitmap(img1))
        else:
            self.gamestatustxt.SetLabel('Game status : Game over !')
            
        self.westicesnake.update()    


    def getX_Y(self,imageindex):
        """
        Get the x,y coordinates of the image.
        """
        
        x=imageindex%self.gridwidth
        y=imageindex/self.gridwidth
        
        return [x,y]


    def getIndex(self,x,y):
        """
        ...
        """
        
        return y*self.gridwidth+x        


    def OnQuit(self, event):
        self.Close()
        
#---------------------------------------------------------------------------
 
def main():
    app = wx.App()
    frame = MyFrame()
    frame.Show(True)
    app.MainLoop()

#---------------------------------------------------------------------------
    
if __name__ == '__main__':
    main()
