# tetris_bis.py

"""
wxPython Tetris game.

Author : Hanming Zhang
Link : https://github.com/HanmingZhang/Tetris
"""

import wx
import random

# class SplitterFrame
# class Info
# class Board
# class Tetrominoes
# class Shape

#---------------------------------------------------------------------------

class SplitterFrame(wx.Frame):
    def __init__(self, parent, id, title):
        style=wx.DEFAULT_FRAME_STYLE ^ wx.RESIZE_BORDER ^ wx.MAXIMIZE_BOX
        wx.Frame.__init__(self, parent, id, title, size=(500, 600), style=style)

        #------------

        self.SetIcon(wx.Icon(".\icons\wxwin.ico"))
        
        #------------
        
        self.initpos = 600

        #------------
        
        self.sp = wx.SplitterWindow(self)
        self.board = Board(self.sp, style=wx.SUNKEN_BORDER)
        self.board.SetBackgroundColour("pink")

        self.info = Info(self.sp, style=wx.SUNKEN_BORDER)
        self.info.SetBackgroundColour("sky blue")

        self.sp.SplitVertically(self.board, self.info, self.initpos)
        self.sp.SetMinimumPaneSize(210)

        #------------
        
        self.ShowNextPiece = Shape()
        # self.board.SetFocus()

        #------------
        
        # self.Music = wx.Sound('E:\Lab7\s.mp3')

        #------------
        
        self.board.Start()

        #------------
        
        self.CenterOnScreen(wx.BOTH)  
        self.Show(True)  
        
#---------------------------------------------------------------------------        

class Info(wx.Panel):
    BoardWidth = 6
    BoardHeight = 25
    def __init__(self, parent, style):
        wx.Panel.__init__(self, parent) 

        #------------
        
        self.upspeedButton = wx.Button(self, -1, "Up Speed", pos=(15, 500))
        self.lowerButton = wx.Button(self, -1, "Lower Speed", pos=(100, 500))
        self.Bind(wx.EVT_BUTTON, self.OnUpSpeed, self.upspeedButton)
        self.Bind(wx.EVT_BUTTON, self.OnLowerSpeed, self.lowerButton)
        self.Bind(wx.EVT_PAINT, self.OnPaint)

        #------------
        
        temp = wx.StaticText(self, -1,"Coming next :", pos=(20, 40))
        temp.SetFont(wx.Font(18, wx.SCRIPT, wx.NORMAL, wx.NORMAL, False))
        temp.SetForegroundColour(wx.Colour(255, 255, 255))
        temp = wx.StaticText(self, -1, "Number of lines removed :", pos=(20, 360))
        temp.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.BOLD, False))
        temp = wx.StaticText(self, -1, "Your Score :", pos=(20, 420))
        temp.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.BOLD, False))

    #-----------------------------------------------------------------------
        
    def OnUpSpeed(self,event):
         if Board.Speed >= 100:
              Board.Speed = Board.Speed -50 
              self.GetParent().GetParent().board.timer.Start(Board.Speed)

          
    def OnLowerSpeed(self,event):
         Board.Speed = Board.Speed +50 
         self.GetParent().GetParent().board.timer.Start(Board.Speed)

              
    def SquareWidth(self):
        return self.GetClientSize().GetWidth() / Info.BoardWidth  

          
    def SquareHeight(self):
        return self.GetClientSize().GetHeight() / Info.BoardHeight

    
    def OnPaint(self, event):
        dc = wx.PaintDC(self)           
        size = self.GetClientSize()
        boardTop = size.GetHeight() - Info.BoardHeight * self.SquareHeight()
        
        # dc.DrawText("Coming next:", 20, 40)
       
        # temp = wx.StaticText(self, -1, "Coming next:", pos=(20, 40))
        # temp.SetFont(wx.Font(5, wx.SWISS, wx.NORMAL, wx.BOLD, False))
        
        # dc.DrawText("Number of lines removed:", 5, 380)
        dc.DrawText("%d" %(self.GetParent().GetParent().board.numLinesRemoved), 90, 400)
        # dc.DrawText("Your Score:", 5, 420)
        dc.DrawText("%d" %(self.GetParent().GetParent().board.Score), 90, 460)
        #linesRemoved=wx.StaticText(self, -1, "", pos=(100, 400))
        #linesRemoved.SetFont(wx.Font(15, wx.SWISS, wx.NORMAL, wx.BOLD, False))
        #linesRemoved.SetForegroundColour(wx.Colour(0, 0, 0, 255))
        #linesRemoved.SetLabel("%d" %(self.GetParent().GetParent().board.numLinesRemoved))
      
        
        if self.GetParent().GetParent().ShowNextPiece.shape() != Tetrominoes.NoShape:
            for i in range(4):
                x = self.GetParent().GetParent().ShowNextPiece.x(i)
                y = self.GetParent().GetParent().ShowNextPiece.y(i)
                self.DrawSquare(dc, 0 + x * self.SquareWidth()+80,
                    boardTop + (Info.BoardHeight + y - 1) * self.SquareHeight()-400,
                    self.GetParent().GetParent().ShowNextPiece.shape())
                    

    def DrawSquare(self, dc, x, y, shape):
        colors = ['#000000', '#CC6666', '#66CC66', '#6666CC',
                  '#CCCC66', '#CC66CC', '#66CCCC', '#DAAA00']

        light = ['#000000', '#F89FAB', '#79FC79', '#7979FC', 
                 '#FCFC79', '#FC79FC', '#79FCFC', '#FCC600']

        dark = ['#000000', '#803C3B', '#3B803B', '#3B3B80', 
                '#80803B', '#803B80', '#3B8080', '#806200']

        pen = wx.Pen(light[shape])
        pen.SetCap(wx.CAP_PROJECTING)
        dc.SetPen(pen)

        dc.DrawLine(x, y + self.SquareHeight() - 1, x, y)
        dc.DrawLine(x, y, x + self.SquareWidth() - 1, y)

        darkpen = wx.Pen(dark[shape])
        darkpen.SetCap(wx.CAP_PROJECTING)
        dc.SetPen(darkpen)

        dc.DrawLine(x + 1, y + self.SquareHeight() - 1,
            x + self.SquareWidth() - 1, y + self.SquareHeight() - 1)
        dc.DrawLine(x + self.SquareWidth() - 1, 
        y + self.SquareHeight() - 1, x + self.SquareWidth() - 1, y + 1)

        dc.SetPen(wx.TRANSPARENT_PEN)
        dc.SetBrush(wx.Brush(colors[shape]))
        dc.DrawRectangle(x + 1, y + 1, self.SquareWidth() - 2, 
                         self.SquareHeight() - 2)

#---------------------------------------------------------------------------
        
class Board(wx.Panel):
    BoardWidth = 12
    BoardHeight = 20
    Speed = 300
    ID_TIMER = 1
    def __init__(self, parent, style):
        wx.Panel.__init__(self, parent, style=wx.WANTS_CHARS)
        # You can use arrow keys after adding style = wx.WANTS_CHARS.


        #------------
        
        # Delete flickers.
        if wx.Platform == "__WXMSW__":
            self.SetDoubleBuffered(True)

        #------------
    
        self.timer = wx.Timer(self, Board.ID_TIMER)
        self.isWaitingAfterLine = False
        self.curPiece = Shape()
        self.nextPiece = Shape() 
        self.nextPiece.SetRandomShape()
        self.curX = 0
        self.curY = 0
        self.numLinesRemoved = 0
        self.Score = 0
        self.board = []

        #------------
        
        self.isStarted = False
        self.isPaused = False

        #------------
        
        self.Bind(wx.EVT_PAINT, self.OnPaint)
        self.Bind(wx.EVT_KEY_DOWN, self.OnKeyDown)
        self.Bind(wx.EVT_TIMER, self.OnTimer, id=Board.ID_TIMER)

        #------------
        
        self.ClearBoard()

    #-----------------------------------------------------------------------
        
    def ShapeAt(self, x, y):
        return self.board[(int(y) * int(Board.BoardWidth)) + int(x)]


    def SetShapeAt(self, x, y, shape):
        self.board[(int(y) * int(Board.BoardWidth)) + int(x)] = shape


    def SquareWidth(self):
        return self.GetClientSize().GetWidth() / Board.BoardWidth


    def SquareHeight(self):
        return self.GetClientSize().GetHeight() / Board.BoardHeight


    def Start(self):
        if self.isPaused:
            return

        self.isStarted = True
        self.isWaitingAfterLine = False
        self.numLinesRemoved = 0
        self.Score = 0
        self.ClearBoard()
        
        wx.MessageBox("""Hello !\n"""
                      """Welcome to Tetris World.\n\n"""
                      """Here are some information you may need.\n\n"""
                      """Azerty keyboard :\n"""
                      """--------------------\n"""
                      """Z --> Rotate\n"""
                      """Q/D --> Left or Right move\n"""
                      """S --> One line down\n"""
                      """Space --> Drop down\n"""
                      """P --> Pause\n\n"""
                      """Hope you enjoy ! ^.^""",
                      "Tetris",
                      wx.OK | wx.ICON_INFORMATION,
                      self)
        
        # self.GetParent().GetParent().Music.Play(wx.SOUND_ASYNC)
        
        self.NewPiece()
        self.timer.Start(Board.Speed)


    def Pause(self):
        if not self.isStarted:
            return

        self.isPaused = not self.isPaused
        # statusbar = self.GetParent().statusbar

        if self.isPaused:
            self.timer.Stop()
            # statusbar.SetStatusText('Paused')
        else:
            self.timer.Start(Board.Speed)
            # statusbar.SetStatusText(str(self.numLinesRemoved))
        self.Refresh()


    def ClearBoard(self):
        for i in range(Board.BoardHeight * Board.BoardWidth):
            self.board.append(Tetrominoes.NoShape)


    def OnPaint(self, event):
        dc = wx.PaintDC(self)        

        size = self.GetClientSize()
        boardTop = size.GetHeight() - Board.BoardHeight * self.SquareHeight()
        
        for i in range(Board.BoardHeight):
            for j in range(Board.BoardWidth):
                shape = self.ShapeAt(j, Board.BoardHeight - i - 1)
                if shape != Tetrominoes.NoShape:
                    self.DrawSquare(dc,
                        0 + j * self.SquareWidth(),
                        boardTop + i * self.SquareHeight(), shape)

        if self.curPiece.shape() != Tetrominoes.NoShape:
            for i in range(4):
                x = self.curX + self.curPiece.x(i)
                y = self.curY - self.curPiece.y(i)
                self.DrawSquare(dc, 0 + x * self.SquareWidth(),
                    boardTop + (Board.BoardHeight - y - 1) * self.SquareHeight(),
                    self.curPiece.shape())


    def OnKeyDown(self, event):
        if not self.isStarted or self.curPiece.shape() == Tetrominoes.NoShape:
            event.Skip()
            return

        keycode = event.GetKeyCode()

        if keycode == ord('P') or keycode == ord('p'):
            self.Pause()
            return
        if self.isPaused:
            return
        elif keycode == ord('Q') or keycode == ord('q'):
            self.TryMove(self.curPiece, self.curX - 1, self.curY)
        elif keycode == ord('D') or keycode == ord('d'):
            self.TryMove(self.curPiece, self.curX + 1, self.curY)
        #elif keycode == wx.WXK_DOWN:
            #self.TryMove(self.curPiece.rotatedRight(), self.curX, self.curY)
        elif keycode == ord('Z') or keycode == ord('z'):
            self.TryMove(self.curPiece.RotatedLeft(), self.curX, self.curY)
        elif keycode == ord('S') or keycode == ord('s'):
            self.OneLineDown()
        elif keycode == wx.WXK_SPACE:
            self.DropDown()
        else:
            event.Skip()


    def OnTimer(self, event):
        if event.GetId() == Board.ID_TIMER:
            if self.isWaitingAfterLine:
                self.isWaitingAfterLine = False
                self.NewPiece()
            else:
                self.OneLineDown()
        else:
            event.Skip()


    def DropDown(self):
        newY = self.curY
        while newY > 0:
            if not self.TryMove(self.curPiece, self.curX, newY - 1):
                break
            newY -= 1

        self.PieceDropped()


    def OneLineDown(self):
        if not self.TryMove(self.curPiece, self.curX, self.curY - 1):
            self.PieceDropped()


    def PieceDropped(self):
        for i in range(4):
            x = self.curX + self.curPiece.x(i)
            y = self.curY - self.curPiece.y(i)
            self.SetShapeAt(x, y, self.curPiece.shape())

        self.RemoveFullLines()

        if not self.isWaitingAfterLine:
            self.NewPiece()


    def RemoveFullLines(self):
        numFullLines = 0

        # statusbar = self.GetParent().statusbar

        rowsToRemove = []

        for i in range(Board.BoardHeight):
            n = 0
            for j in range(Board.BoardWidth):
                if not self.ShapeAt(j, i) == Tetrominoes.NoShape:
                    n = n + 1

            if n == 12:
                rowsToRemove.append(i)

        rowsToRemove.reverse()
        
        for m in rowsToRemove: 
            for k in range(m, Board.BoardHeight):
                for l in range(Board.BoardWidth):
                        self.SetShapeAt(l, k, self.ShapeAt(l, k + 1))

            numFullLines = numFullLines + len(rowsToRemove)
            
            
            if numFullLines > 0:
                #if numFullLines == 1:
                    #self.Score += 10
                #else :
                    #self.Score += numFullLines*20
                #self.numLinesRemoved += numFullLines
                # statusbar.SetStatusText(str(self.numLinesRemoved)) 
                self.isWaitingAfterLine = True
                self.curPiece.SetShape(Tetrominoes.NoShape)
                self.Refresh()
        
        if len(rowsToRemove) != 0:
            self.numLinesRemoved += len(rowsToRemove)
            if len(rowsToRemove) == 1:
                self.Score += 10
            else:
                self.Score += len(rowsToRemove)*20
            self.GetParent().GetParent().info.Refresh()
            
    
    def NewPiece(self):
        # self.curPiece = self.nextPiece (it's wrong !)
        # The original one has problem !!
        # self.curPiece will always be the same as self.nextPiece
        # This is the proper way !
        self.curPiece.SetShape(self.nextPiece.shape())      
        # statusbar = self.GetParent().statusbar
        self.nextPiece.SetRandomShape()
        
        self.GetParent().GetParent().ShowNextPiece = self.nextPiece
        # self.GetParent is a SpiltterWindow, and SpiltterWIndow's parent is SplitterFrame !
        self.GetParent().GetParent().info.Refresh()
        
        self.curX = Board.BoardWidth / 2 + 1
        self.curY = Board.BoardHeight - 1 + self.curPiece.MinY()

        if not self.TryMove(self.curPiece, self.curX, self.curY):
            self.curPiece.SetShape(Tetrominoes.NoShape)
            self.timer.Stop()
            self.isStarted = False
            wx.MessageBox("Sorry ! Game Over !", "Game Over",
                          wx.OK | wx.ICON_INFORMATION, self)
            # Once the game is over, the program will quit.
            self.GetParent().GetParent().Close()  


    def TryMove(self, NewPiece, newX, newY):
        for i in range(4):
            x = newX + NewPiece.x(i)
            y = newY - NewPiece.y(i)
            if x < 0 or x >= Board.BoardWidth or y < 0 or y >= Board.BoardHeight:
                return False
            if self.ShapeAt(x, y) != Tetrominoes.NoShape:
                return False

        self.curPiece = NewPiece
        self.curX = newX
        self.curY = newY
        self.Refresh()
        return True


    def DrawSquare(self, dc, x, y, shape):
        colors = ['#000000', '#CC6666', '#66CC66', '#6666CC',
                  '#CCCC66', '#CC66CC', '#66CCCC', '#DAAA00']

        light = ['#000000', '#F89FAB', '#79FC79', '#7979FC', 
                 '#FCFC79', '#FC79FC', '#79FCFC', '#FCC600']

        dark = ['#000000', '#803C3B', '#3B803B', '#3B3B80', 
                 '#80803B', '#803B80', '#3B8080', '#806200']

        pen = wx.Pen(light[shape])
        pen.SetCap(wx.CAP_PROJECTING)
        dc.SetPen(pen)

        dc.DrawLine(x, y + self.SquareHeight() - 1, x, y)
        dc.DrawLine(x, y, x + self.SquareWidth() - 1, y)

        darkpen = wx.Pen(dark[shape])
        darkpen.SetCap(wx.CAP_PROJECTING)
        dc.SetPen(darkpen)

        dc.DrawLine(x + 1, y + self.SquareHeight() - 1,
            x + self.SquareWidth() - 1, y + self.SquareHeight() - 1)
        dc.DrawLine(x + self.SquareWidth() - 1, 
        y + self.SquareHeight() - 1, x + self.SquareWidth() - 1, y + 1)

        dc.SetPen(wx.TRANSPARENT_PEN)
        dc.SetBrush(wx.Brush(colors[shape]))
        dc.DrawRectangle(x + 1, y + 1, self.SquareWidth() - 2, 
        self.SquareHeight() - 2)

#---------------------------------------------------------------------------
        
class Tetrominoes(object):
    NoShape = 0
    ZShape = 1
    SShape = 2
    LineShape = 3
    TShape = 4
    SquareShape = 5
    LShape = 6
    MirroredLShape = 7

#---------------------------------------------------------------------------

class Shape(object):
    coordsTable = (
        ((0, 0),     (0, 0),     (0, 0),     (0, 0)),
        ((0, -1),    (0, 0),     (-1, 0),    (-1, 1)),
        ((0, -1),    (0, 0),     (1, 0),     (1, 1)),
        ((0, -1),    (0, 0),     (0, 1),     (0, 2)),
        ((-1, 0),    (0, 0),     (1, 0),     (0, 1)),
        ((0, 0),     (1, 0),     (0, 1),     (1, 1)),
        ((-1, -1),   (0, -1),    (0, 0),     (0, 1)),
        ((1, -1),    (0, -1),    (0, 0),     (0, 1))
    )
    def __init__(self):
        self.coords = [[0,0] for i in range(4)]
        self.pieceShape = Tetrominoes.NoShape
        self.SetShape(Tetrominoes.NoShape)

    #-----------------------------------------------------------------------
        
    def shape(self):
        return self.pieceShape


    def SetShape(self, shape):
        table = Shape.coordsTable[shape]
        for i in range(4):
            for j in range(2):
                self.coords[i][j] = table[i][j]

        self.pieceShape = shape


    def SetRandomShape(self):
        self.SetShape(random.randint(1, 7))


    def x(self, index):
        return self.coords[index][0]


    def y(self, index):
        return self.coords[index][1]


    def SetX(self, index, x):
        self.coords[index][0] = x


    def SetY(self, index, y):
        self.coords[index][1] = y


    def MinX(self):
        m = self.coords[0][0]
        for i in range(4):
            m = min(m, self.coords[i][0])
        return m


    def MaxX(self):
        m = self.coords[0][0]
        for i in range(4):
            m = max(m, self.coords[i][0])
        return m


    def MinY(self):
        m = self.coords[0][1]
        for i in range(4):
            m = min(m, self.coords[i][1])
        return m


    def MaxY(self):
        m = self.coords[0][1]
        for i in range(4):
            m = max(m, self.coords[i][1])
        return m


    def RotatedLeft(self):
        if self.pieceShape == Tetrominoes.SquareShape:
            return self

        result = Shape()
        result.pieceShape = self.pieceShape
        for i in range(4):
            result.SetX(i, self.y(i))
            result.SetY(i, -self.x(i))

        return result

#---------------------------------------------------------------------------
    
def main():
    app = wx.App()
    SplitterFrame(None, -1, 'Tetris')
    app.MainLoop()

#---------------------------------------------------------------------------
    
if __name__ == '__main__':
    main()
