# memory_game.py

"""
wxPython Memory game.
All images should be in folder named "Images".
Images used are W : 100px H : 150px, though any size works if all images same size.
Line 32 has some commented out code to print the key to terminal for testing.

Author : Zoenberger
Link : https://github.com/zoenberger/Memory-Game-using-wxPython
"""

import wx
import os
import random
import time

# class MemoryGame
# def Winner
# def GetJpgList

#---------------------------------------------------------------------------

class MemoryGame(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self, None, title="")

        #------------
        
        self.SetIcon(wx.Icon(".\icons\wxwin.ico"))
        self.SetTitle("Memory game")
        self.SetSize((900,700))
        
        #------------
        
        self.Move((50,25))

        #------------
        
        self.panel = wx.Panel(self)   

        #------------
        
        # Define how big game is...can be useful
        # for making skill options later.
        self.numPairs = 12
        
        # Get all images in directory called
        # "Images" & shuffle order
        self.imageArray = GetJpgList("./images")
        random.shuffle(self.imageArray)
        
        # Create array with how many cards needed
        # and double it to make matched pairs.        
        self.imagePairs = self.imageArray[0:self.numPairs]
        self.imagePairs = self.imagePairs * 2

        # Because we doubled, we need to re-shuffle order.
        random.shuffle(self.imagePairs)

        #------------
        
        # PRINT KEY TO TERMINAL SO YOU CAN QUICKLY SOLVE.
        # countrow=0
        # for card in self.imagePairs:
        #     countrow +=1
        #     if countrow%6 == 0:
        #         print card
        #     else:
        #         print card,
        
        # Create blank card and give name of file name.
        card = wx.Image('./images/main_card.jpg',wx.BITMAP_TYPE_ANY).ConvertToBitmap()
        self.blankCards =[]
        for i in range(len(self.imagePairs)):
            self.blankCards.append(wx.StaticBitmap(self.panel,wx.ID_ANY, card,name=self.imagePairs[i]))
            
        # Bind left click to each card that calls check function.
        for img in self.blankCards:
            img.Bind(wx.EVT_LEFT_DOWN, self.OnClick)

        #------------
            
        # Visual Layout.
        hbox = wx.BoxSizer(wx.HORIZONTAL)
        gs = wx.GridSizer(4, 6, 15, 15)
        gs.AddMany(self.blankCards)       
        hbox.Add(gs, proportion=0, flag = wx.LEFT | wx.TOP, border = 10)
        
        title = wx.StaticText(self.panel, label="Memory Game")
        hbox.Add(title,proportion=1, flag = wx.LEFT | wx.TOP | wx.RIGHT | wx.EXPAND, border = 10)
        
        self.panel.SetSizer(hbox)
        self.Show()
        
        #------------
        
        # Keeps track to see if you've won.        
        self.foundMatches= 0
        # Keeps track of 1st or second click.
        self.clickCount = 0
        # Holding spot if it's first click.
        self.card1 = '' 
        self.totalTries = 0

    #-----------------------------------------------------------------------

    def OnClick(self, event):
        self.clickCount += 1

        #------------
        
        # Get card clicked on, swap out blank
        # image with image by filename.
        newCard = event.GetEventObject()
        img = wx.Image(newCard.GetName(), wx.BITMAP_TYPE_ANY)
        newCard.SetBitmap(wx.Bitmap(img))        

        #------------
        
        if self.clickCount == 1:
            # Put into holding space if 1st click.
            self.card1 = newCard 
            self.card1.Unbind(wx.EVT_LEFT_DOWN)
        
        else:
            # FOUND MATCH : unbind click events. Update match tracker.
            self.totalTries += 1
            if (newCard.GetName() == self.card1.GetName()):
                for findItem in self.blankCards:
                    if findItem.GetName() == newCard.GetName():
                        findItem.Unbind(wx.EVT_LEFT_DOWN)
                self.foundMatches += 1
                print(self.foundMatches)
            else:  
                # NO MATCH : wait then hide both cards again.
                # This basically freezes screen, but clicks still captured.
                time.sleep(1) 
                blankCard = wx.Image('./images/main_card.jpg', wx.BITMAP_TYPE_ANY)
                newCard.SetBitmap(wx.Bitmap(blankCard))
                self.card1.SetBitmap(wx.Bitmap(blankCard))
                self.card1.Bind(wx.EVT_LEFT_DOWN, self.OnClick)
            self.clickCount = 0
        
        if self.foundMatches == self.numPairs:
            Winner()
            print("Total Tries = " + str(self.totalTries))
            total = ("Total Tries = " + str(self.totalTries))
            
            dlg = wx.MessageDialog(self,
                                   total,
                                   "Winner !",
                                   wx.OK | wx.CENTRE | wx.ICON_INFORMATION)
            dlg.ShowModal()
            dlg.Destroy()
        
#---------------------------------------------------------------------------
          
# NOTE : make the winning more exciting. Hahahaha.
def Winner():
    print("WINNER WINNER WINNER !")

#---------------------------------------------------------------------------

# Get all JPEGs in a directory that is passed and return image names array.
# Note I found this code snippet here :
# http ://wiki.wxpython.org/wxStaticBitmap
def GetJpgList(loc):
    jpgs = [f for f in os.listdir(loc) if f[-4:] == ".jpg"]
    #print "JPGS are:", jpgs

    return [os.path.join(loc, f) for f in jpgs]

#---------------------------------------------------------------------------
    
def main():
    app = wx.App(False)
    frame = MemoryGame()
    app.MainLoop()

#---------------------------------------------------------------------------
    
if __name__ == '__main__':
    main()
    
